/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public abstract class ObjectBodiedNodeContextProvider<T extends Node>
extends AbstractCompletionProvider<T> {
    public ObjectBodiedNodeContextProvider(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    protected List<LSCompletionItem> getBodyContextItems(BallerinaCompletionContext context, Node node) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
            return this.getCompletionItemList(typesInModule, context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getTypeDescContextItems(context));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_PRIVATE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_PUBLIC.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FINAL.get()));
        if (this.isServiceOrClientObject(node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_REMOTE.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_RESOURCE.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_REMOTE_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_RESOURCE_FUNCTION_SIGNATURE.get()));
        }
        if (this.onSuggestInitMethod(node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_INIT_FUNCTION.get()));
        }
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get()));
        return completionItems;
    }

    private boolean isServiceOrClientObject(Node node) {
        return node.kind() == SyntaxKind.SERVICE_DECLARATION || node.kind() == SyntaxKind.OBJECT_CONSTRUCTOR && ((ObjectConstructorExpressionNode)node).objectTypeQualifiers().stream().anyMatch(token -> token.kind() == SyntaxKind.CLIENT_KEYWORD);
    }

    private boolean onSuggestInitMethod(Node node) {
        NodeList members = null;
        if (node.kind() == SyntaxKind.SERVICE_DECLARATION) {
            members = ((ServiceDeclarationNode)node).members();
        } else if (node.kind() == SyntaxKind.OBJECT_CONSTRUCTOR) {
            members = ((ObjectConstructorExpressionNode)node).members();
        }
        return members != null && members.stream().filter(member -> member.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION).map(member -> (FunctionDefinitionNode)member).noneMatch(funcDef -> "init".equals(funcDef.functionName().text()));
    }
}

