/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class OnFailClauseNodeContext
extends AbstractCompletionProvider<OnFailClauseNode> {
    public OnFailClauseNodeContext() {
        super(OnFailClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, OnFailClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestFailKeyword(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FAIL.get()));
        } else {
            if (!this.onSuggestTypeDescriptors(context, node)) {
                return Collections.emptyList();
            }
            NonTerminalNode symbolAtCursor = context.getNodeAtCursor();
            Predicate<Symbol> errorPredicate = SymbolUtil::isError;
            if (symbolAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                QualifiedNameReferenceNode qRef = (QualifiedNameReferenceNode)symbolAtCursor;
                List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qRef, errorPredicate);
                completionItems.addAll(this.getCompletionItemList(moduleContent, context));
            } else {
                completionItems.addAll(this.getModuleCompletionItems(context));
                List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
                List<Symbol> errEntries = visibleSymbols.stream().filter(errorPredicate).toList();
                completionItems.addAll(this.getCompletionItemList(errEntries, context));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
            }
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, OnFailClauseNode node) {
        return !node.onKeyword().isMissing();
    }

    private boolean onSuggestFailKeyword(BallerinaCompletionContext context, OnFailClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        if (node.onKeyword().isMissing()) {
            return false;
        }
        return node.failKeyword().isMissing() && node.onKeyword().textRange().endOffset() < cursor;
    }

    private boolean onSuggestTypeDescriptors(BallerinaCompletionContext context, OnFailClauseNode node) {
        int cursor = context.getCursorPositionInTree();
        BlockStatementNode blockStatement = node.blockStatement();
        Token failKeyword = node.failKeyword();
        if (failKeyword.isMissing()) {
            return false;
        }
        return cursor > failKeyword.textRange().endOffset() && (blockStatement.isMissing() || cursor < blockStatement.openBraceToken().textRange().endOffset());
    }
}

