/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OrderByClauseNode;
import io.ballerina.compiler.syntax.tree.OrderKeyNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.IntermediateClauseNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class OrderByClauseNodeContext
extends IntermediateClauseNodeContext<OrderByClauseNode> {
    public OrderByClauseNodeContext() {
        super(OrderByClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, OrderByClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (this.onSuggestDirectionKeywords(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ASCENDING.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_DESCENDING.get()));
            completionItems.addAll(this.getKeywordCompletions(context, node));
        } else if (this.cursorAtTheEndOfClause(context, node)) {
            completionItems.addAll(this.getKeywordCompletions(context, node));
        } else if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, OrderByClauseNode node) {
        return !node.orderKeyword().isMissing();
    }

    @Override
    public void sort(BallerinaCompletionContext context, OrderByClauseNode node, List<LSCompletionItem> completionItems) {
        List<TypeDescKind> basicTypes = Arrays.asList(TypeDescKind.STRING, TypeDescKind.INT, TypeDescKind.BOOLEAN, TypeDescKind.FLOAT, TypeDescKind.DECIMAL);
        Optional<QueryExpressionNode> queryExprNode = SortingUtil.getTheOutermostQueryExpressionNode((Node)node);
        if (queryExprNode.isEmpty()) {
            return;
        }
        completionItems.forEach(lsCItem -> {
            int rank = 3;
            if (SortingUtil.isSymbolCItemWithinNodeAndCursor(context, lsCItem, (Node)queryExprNode.get())) {
                rank = 1;
            } else if (CommonUtil.isCompletionItemOfType(lsCItem, basicTypes)) {
                rank = 2;
            }
            lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)));
        });
    }

    private boolean onSuggestDirectionKeywords(BallerinaCompletionContext context, OrderByClauseNode node) {
        OrderKeyNode lastOrderKey;
        SeparatedNodeList orderKeyNodes = node.orderKey();
        if (orderKeyNodes.isEmpty()) {
            return false;
        }
        int cursor = context.getCursorPositionInTree();
        return cursor > (lastOrderKey = (OrderKeyNode)orderKeyNodes.get(orderKeyNodes.size() - 1)).textRange().endOffset();
    }

    @Override
    protected boolean cursorAtTheEndOfClause(BallerinaCompletionContext context, OrderByClauseNode node) {
        if (node.orderKey().isEmpty()) {
            return false;
        }
        OrderKeyNode lastOrderKey = (OrderKeyNode)node.orderKey().get(node.orderKey().size() - 1);
        int cursor = context.getCursorPositionInTree();
        if (lastOrderKey.orderDirection().isPresent()) {
            return ((Token)lastOrderKey.orderDirection().get()).textRange().endOffset() < cursor;
        }
        if (lastOrderKey.expression() != null && !lastOrderKey.expression().isMissing()) {
            return lastOrderKey.expression().textRange().endOffset() < cursor;
        }
        return false;
    }

    @Override
    protected Optional<Node> getLastNodeOfClause(OrderByClauseNode node) {
        if (node.orderKey().isEmpty()) {
            return Optional.empty();
        }
        OrderKeyNode lastOrderKey = (OrderKeyNode)node.orderKey().get(node.orderKey().size() - 1);
        if (lastOrderKey.orderDirection().isPresent()) {
            return lastOrderKey.orderDirection().flatMap(Optional::of);
        }
        return Optional.of(lastOrderKey.expression());
    }
}

