/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.JoinClauseNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OrderByClauseNode;
import io.ballerina.compiler.syntax.tree.OrderKeyNode;
import io.ballerina.compiler.syntax.tree.QueryPipelineNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.WhereClauseNode;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.QueryExpressionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class QueryPipelineNodeContext
extends AbstractCompletionProvider<QueryPipelineNode> {
    public QueryPipelineNodeContext() {
        super(QueryPipelineNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, QueryPipelineNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.fromClause().isMissing() || node.fromClause().fromKeyword().isMissing()) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FROM.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.CLAUSE_FROM.get()));
        } else if (this.onMissingWhereNode(context)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FROM.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.CLAUSE_FROM.get()));
            completionItems.addAll(QueryExpressionUtil.getCommonKeywordCompletions(context));
            if (this.onSuggestDirectionKeywords(context, node)) {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ASCENDING.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_DESCENDING.get()));
            }
        } else if (this.onMissingJoinKeyword(context)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_JOIN.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.CLAUSE_JOIN.get()));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean onMissingWhereNode(BallerinaCompletionContext context) {
        NonTerminalNode nextIntermediate = context.getNodeAtCursor().parent();
        return !nextIntermediate.isMissing() && nextIntermediate.kind() == SyntaxKind.WHERE_CLAUSE && ((WhereClauseNode)nextIntermediate).whereKeyword().isMissing();
    }

    private boolean onMissingJoinKeyword(BallerinaCompletionContext context) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        NonTerminalNode evalNode = nodeAtCursor.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE ? nodeAtCursor.parent().parent() : nodeAtCursor;
        return !evalNode.isMissing() && evalNode.kind() == SyntaxKind.JOIN_CLAUSE && ((JoinClauseNode)evalNode).joinKeyword().isMissing();
    }

    private boolean onSuggestDirectionKeywords(BallerinaCompletionContext context, QueryPipelineNode node) {
        if (!this.onMissingWhereNode(context) || context.currentSyntaxTree().isEmpty()) {
            return false;
        }
        int cursor = context.getCursorPositionInTree();
        NonTerminalNode nextIntermediate = context.getNodeAtCursor().parent();
        LinePosition startLinePosition = nextIntermediate.lineRange().startLine();
        int startOffset = PositionUtil.getPositionOffset(PositionUtil.toPosition(startLinePosition), (SyntaxTree)context.currentSyntaxTree().get());
        Iterator iterator = node.intermediateClauses().iterator();
        IntermediateClauseNode closestNode = null;
        while (iterator.hasNext()) {
            IntermediateClauseNode next = (IntermediateClauseNode)iterator.next();
            int endOffset = PositionUtil.getPositionOffset(PositionUtil.toPosition(next.lineRange().endLine()), (SyntaxTree)context.currentSyntaxTree().get());
            if (endOffset >= startOffset) continue;
            closestNode = next;
        }
        if (closestNode == null || closestNode.kind() != SyntaxKind.ORDER_BY_CLAUSE) {
            return false;
        }
        SeparatedNodeList orderKeyNodes = ((OrderByClauseNode)closestNode).orderKey();
        if (orderKeyNodes.isEmpty()) {
            return false;
        }
        OrderKeyNode lastOrderKey = (OrderKeyNode)orderKeyNodes.get(orderKeyNodes.size() - 1);
        return cursor > lastOrderKey.textRange().endOffset();
    }
}

