/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ReturnStatementNodeContext
extends AbstractCompletionProvider<ReturnStatementNode> {
    public ReturnStatementNodeContext() {
        super(ReturnStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ReturnStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.expression().isPresent() && QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            List<Symbol> entries = QNameRefCompletionUtil.getExpressionContextEntries(context, (QualifiedNameReferenceNode)context.getNodeAtCursor());
            completionItems.addAll(this.getCompletionItemList(entries, context));
        } else {
            completionItems.addAll(this.actionKWCompletions(context));
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ReturnStatementNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbolAtCursor = context.getContextType();
        if (typeSymbolAtCursor.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbolAtCursor.get();
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, symbol));
        }
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ReturnStatementNode node) {
        int cursor = context.getCursorPositionInTree();
        return !node.returnKeyword().isMissing() && node.returnKeyword().textRange().endOffset() <= cursor;
    }
}

