/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.QueryExpressionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class SelectClauseNodeContext
extends AbstractCompletionProvider<SelectClauseNode> {
    public SelectClauseNodeContext() {
        super(SelectClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, SelectClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.CLAUSE_ON_CONFLICT.get()));
            if (this.containsGroupByNode(node)) {
                List<FunctionSymbol> functionSymbols = QueryExpressionUtil.getLangLibMethods(context);
                functionSymbols.stream().filter(symbol -> symbol.typeDescriptor().restParam().isPresent()).filter(symbol -> symbol.getName().isPresent() && !((String)symbol.getName().get()).contains("$")).forEach(symbol -> completionItems.addAll(this.populateBallerinaFunctionCompletionItems((FunctionSymbol)symbol, context)));
            }
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private boolean containsGroupByNode(SelectClauseNode selectClauseNode) {
        boolean foundNode = false;
        NonTerminalNode parentNode = selectClauseNode.parent();
        if (selectClauseNode.parent().kind() != SyntaxKind.QUERY_EXPRESSION) {
            return false;
        }
        QueryExpressionNode queryExpNode = (QueryExpressionNode)parentNode;
        for (IntermediateClauseNode node : queryExpNode.queryPipeline().intermediateClauses()) {
            if (node.kind() != SyntaxKind.GROUP_BY_CLAUSE) continue;
            foundNode = true;
        }
        return foundNode;
    }

    @Override
    public void sort(BallerinaCompletionContext context, SelectClauseNode node, List<LSCompletionItem> completionItems) {
        Optional<QueryExpressionNode> queryExprNode = SortingUtil.getTheOutermostQueryExpressionNode((Node)node);
        if (queryExprNode.isEmpty()) {
            return;
        }
        completionItems.forEach(lsCItem -> {
            int rank = 2;
            if (SortingUtil.isSymbolCItemWithinNodeAndCursor(context, lsCItem, (Node)queryExprNode.get())) {
                rank = 1;
            }
            lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)));
        });
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, SelectClauseNode node) {
        return !node.selectKeyword().isMissing() && context.getCursorPositionInTree() >= node.selectKeyword().textRange().startOffset();
    }
}

