/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.ObjectBodiedNodeContextProvider;
import org.ballerinalang.langserver.completions.providers.context.util.ModulePartNodeContextUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;

public class ServiceDeclarationNodeContext
extends ObjectBodiedNodeContextProvider<ServiceDeclarationNode> {
    public ServiceDeclarationNodeContext() {
        super(ServiceDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ServiceDeclarationNode node) {
        ServiceContext cursorContext;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onMemberContext(context, node)) {
            completionItems.addAll(this.getBodyContextItems(context, (Node)node));
            cursorContext = ServiceContext.MEMBERS;
        } else if (this.onTypeDescContext(context, node)) {
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getTokenAtCursor().parent())) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getTokenAtCursor().parent();
                List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, ModulePartNodeContextUtil.serviceTypeDescPredicate());
                completionItems.addAll(this.getCompletionItemList(moduleContent, context));
            } else {
                List<Symbol> typeDescs = ModulePartNodeContextUtil.serviceTypeDescContextSymbols(context);
                completionItems.addAll(this.getCompletionItemList(typeDescs, context));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
                completionItems.addAll(this.getModuleCompletionItems(context));
                if (node.onKeyword().isMissing()) {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ON.get()));
                }
            }
            cursorContext = ServiceContext.TYPE_DESC;
        } else if (this.onExpressionContext(context, node)) {
            Predicate<Symbol> predicate = symbol -> symbol instanceof VariableSymbol && SymbolUtil.isListener(symbol);
            NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
                List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, (QualifiedNameReferenceNode)nodeAtCursor, predicate);
                completionItems.addAll(this.getCompletionItemList(moduleContent, context));
            } else {
                List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
                List<Symbol> listeners = visibleSymbols.stream().filter(predicate).toList();
                completionItems.addAll(this.getCompletionItemList(listeners, context));
                completionItems.addAll(this.getModuleCompletionItems(context));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_NEW.get()));
            }
            cursorContext = ServiceContext.EXPR_LIST;
        } else {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ON.get()));
            cursorContext = ServiceContext.OTHER;
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{cursorContext});
        return completionItems;
    }

    private boolean onTypeDescContext(BallerinaCompletionContext context, ServiceDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token onKeyword = node.onKeyword();
        Token serviceKeyword = node.serviceKeyword();
        Optional tDesc = node.typeDescriptor();
        NodeList resourcePath = node.absoluteResourcePath();
        boolean afterResourcePath = resourcePath.isEmpty() || cursor >= resourcePath.get(resourcePath.size() - 1).textRange().endOffset() + 1;
        boolean afterTypeDesc = tDesc.isEmpty() || cursor < ((TypeDescriptorNode)tDesc.get()).textRange().endOffset() + 1;
        boolean beforeOnKw = onKeyword.isMissing() || onKeyword.textRange().startOffset() > cursor;
        return cursor > serviceKeyword.textRange().endOffset() && beforeOnKw && afterTypeDesc && afterResourcePath;
    }

    private boolean onMemberContext(BallerinaCompletionContext context, ServiceDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openBrace = node.openBraceToken();
        Token closeBrace = node.closeBraceToken();
        if (openBrace.isMissing() || closeBrace.isMissing()) {
            return false;
        }
        return cursor > openBrace.textRange().startOffset() && cursor < closeBrace.textRange().endOffset();
    }

    private boolean onExpressionContext(BallerinaCompletionContext context, ServiceDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token onKeyword = node.onKeyword();
        return !onKeyword.isMissing() && cursor > onKeyword.textRange().endOffset();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ServiceDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token serviceKeyword = node.serviceKeyword();
        return serviceKeyword.textRange().endOffset() < cursor && cursor <= node.closeBraceToken().textRange().endOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, ServiceDeclarationNode node, List<LSCompletionItem> completionItems, Object ... metaData) {
        ServiceContext serviceContext = (ServiceContext)((Object)metaData[0]);
        switch (serviceContext.ordinal()) {
            case 0: {
                this.sortMemberContextItems(context, completionItems);
                break;
            }
            case 1: {
                this.sortTypeDescContextItems(context, completionItems);
                break;
            }
            case 2: {
                this.sortExprListContextItems(context, completionItems);
                break;
            }
            default: {
                super.sort(context, node, completionItems, metaData);
            }
        }
    }

    private void sortTypeDescContextItems(BallerinaCompletionContext context, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem lsItem : completionItems) {
            Object sortText = "";
            boolean isModuleCItem = SortingUtil.isModuleCompletionItem(lsItem);
            if (!isModuleCItem && lsItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL) {
                Symbol symbol = ((SymbolCompletionItem)lsItem).getSymbol().orElse(null);
                Optional<TypeSymbol> typeDesc = SymbolUtil.getTypeDescriptor(symbol);
                if (typeDesc.isPresent()) {
                    TypeSymbol rawType = CommonUtil.getRawType(typeDesc.get());
                    sortText = rawType.kind() == SymbolKind.CLASS ? SortingUtil.genSortText(1) : SortingUtil.genSortText(2);
                }
            } else if (isModuleCItem && !SortingUtil.isLangLibModuleCompletionItem(lsItem)) {
                sortText = SortingUtil.genSortText(3) + SortingUtil.genSortTextForModule(context, lsItem);
            }
            if (((String)sortText).isEmpty()) {
                sortText = SortingUtil.genSortText(4);
            }
            lsItem.getCompletionItem().setSortText((String)sortText);
        }
    }

    private void sortExprListContextItems(BallerinaCompletionContext context, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem lsItem : completionItems) {
            CompletionItem cItem = lsItem.getCompletionItem();
            boolean isModuleCItem = SortingUtil.isModuleCompletionItem(lsItem);
            Object sortText = this.isListenerSymbol(lsItem) ? SortingUtil.genSortText(1) : (isModuleCItem ? SortingUtil.genSortText(2) + SortingUtil.genSortTextForModule(context, lsItem) : (Snippet.KW_NEW.equals(lsItem) ? SortingUtil.genSortText(3) : (SortingUtil.isLangLibModuleCompletionItem(lsItem) || lsItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL ? SortingUtil.genSortText(4) : SortingUtil.genSortText(5))));
            cItem.setSortText((String)sortText);
        }
    }

    private boolean isListenerSymbol(LSCompletionItem completionItem) {
        if (completionItem.getType() != LSCompletionItem.CompletionItemType.SYMBOL) {
            return false;
        }
        return ((SymbolCompletionItem)completionItem).getSymbol().map(SymbolUtil::isListener).orElse(false);
    }

    private void sortMemberContextItems(BallerinaCompletionContext context, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem lsItem : completionItems) {
            CompletionItem cItem = lsItem.getCompletionItem();
            Object sortText = Snippet.DEF_REMOTE_FUNCTION.equals(lsItem) || Snippet.DEF_RESOURCE_FUNCTION_SIGNATURE.equals(lsItem) || Snippet.DEF_FUNCTION.equals(lsItem) || Snippet.DEF_INIT_FUNCTION.equals(lsItem) ? SortingUtil.genSortText(1) : (SortingUtil.isTypeCompletionItem(lsItem) ? SortingUtil.genSortText(2) : (SortingUtil.isModuleCompletionItem(lsItem) && !SortingUtil.isLangLibModuleCompletionItem(lsItem) ? SortingUtil.genSortText(3) + SortingUtil.genSortTextForModule(context, lsItem) : SortingUtil.genSortText(4)));
            cItem.setSortText((String)sortText);
        }
    }

    static enum ServiceContext {
        MEMBERS,
        TYPE_DESC,
        EXPR_LIST,
        OTHER;

    }
}

