/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpreadFieldNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class SpreadFieldNodeContext
extends AbstractCompletionProvider<SpreadFieldNode> {
    public SpreadFieldNodeContext() {
        super(SpreadFieldNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, SpreadFieldNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> moduleEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(moduleEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context, node));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, SpreadFieldNode node, List<LSCompletionItem> completionItems) {
        completionItems.forEach(lsCItem -> {
            int rank;
            if (lsCItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && ((SymbolCompletionItem)((Object)lsCItem)).getSymbol().isPresent()) {
                Optional<Symbol> symbol = ((SymbolCompletionItem)((Object)lsCItem)).getSymbol();
                Optional<Object> tDesc = switch (symbol.get().kind()) {
                    case SymbolKind.RECORD_FIELD, SymbolKind.OBJECT_FIELD, SymbolKind.CLASS_FIELD, SymbolKind.PARAMETER, SymbolKind.PATH_PARAMETER, SymbolKind.VARIABLE -> {
                        Optional<TypeSymbol> symbolType = SymbolUtil.getTypeDescriptor(symbol.get());
                        if (symbolType.isEmpty()) {
                            yield Optional.empty();
                        }
                        yield Optional.ofNullable(CommonUtil.getRawType(symbolType.get()));
                    }
                    case SymbolKind.FUNCTION, SymbolKind.METHOD, SymbolKind.RESOURCE_METHOD -> {
                        FunctionSymbol functionSymbol = (FunctionSymbol)symbol.get();
                        Optional returnType = functionSymbol.typeDescriptor().returnTypeDescriptor();
                        if (returnType.isEmpty()) {
                            yield Optional.empty();
                        }
                        yield Optional.ofNullable(CommonUtil.getRawType((TypeSymbol)returnType.get()));
                    }
                    default -> Optional.empty();
                };
                rank = tDesc.isPresent() && (((TypeSymbol)tDesc.get()).typeKind() == TypeDescKind.RECORD || ((TypeSymbol)tDesc.get()).typeKind() == TypeDescKind.MAP) ? 1 : 2;
            } else {
                rank = 3;
            }
            String sortText = SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem));
            lsCItem.getCompletionItem().setSortText(sortText);
        });
    }
}

