/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.InterpolationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.RegexpCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.wso2.ballerinalang.compiler.util.Names;

public class TemplateExpressionNodeContext
extends AbstractCompletionProvider<TemplateExpressionNode> {
    public TemplateExpressionNodeContext() {
        super(TemplateExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, TemplateExpressionNode node) {
        Optional<InterpolationNode> interpolationNode;
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.kind() == SyntaxKind.REGEX_TEMPLATE_EXPRESSION && this.isCursorWithInBackticks(context, node)) {
            completionItems.addAll(RegexpCompletionProvider.getRegexCompletions(nodeAtCursor, context));
        }
        if ((interpolationNode = this.findInterpolationNode(nodeAtCursor, node)).isEmpty() || !this.isWithinInterpolation(context, node)) {
            return completionItems;
        }
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, this.symbolFilterPredicate());
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        SyntaxKind interpolationParent = interpolationNode.get().parent().kind();
        this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{interpolationParent});
        return completionItems;
    }

    private Optional<InterpolationNode> findInterpolationNode(NonTerminalNode cursorNode, TemplateExpressionNode node) {
        while (cursorNode.kind() != node.kind()) {
            if (cursorNode.kind() == SyntaxKind.INTERPOLATION) {
                return Optional.of((InterpolationNode)cursorNode);
            }
            cursorNode = cursorNode.parent();
        }
        return Optional.empty();
    }

    private boolean isWithinInterpolation(BallerinaCompletionContext context, TemplateExpressionNode node) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        Optional<InterpolationNode> interpolationNode = this.findInterpolationNode(nodeAtCursor, node);
        int cursor = context.getCursorPositionInTree();
        if (interpolationNode.isEmpty()) {
            return false;
        }
        Token startToken = interpolationNode.get().interpolationStartToken();
        Token endToken = interpolationNode.get().interpolationEndToken();
        return !startToken.isMissing() && startToken.textRange().endOffset() <= cursor && (endToken.isMissing() || cursor <= endToken.textRange().startOffset());
    }

    @Override
    public void sort(BallerinaCompletionContext context, TemplateExpressionNode node, List<LSCompletionItem> completionItems, Object ... interpolationParent) {
        if (interpolationParent.length == 0 || !(interpolationParent[0] instanceof SyntaxKind)) {
            throw new RuntimeException("Invalid sorting meta data provided");
        }
        for (LSCompletionItem lsCItem : completionItems) {
            Symbol symbol;
            Optional<TypeSymbol> typeSymbol;
            Object sortText = lsCItem.getType() != LSCompletionItem.CompletionItemType.SYMBOL || ((SymbolCompletionItem)lsCItem).getSymbol().isEmpty() ? SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem, 1)) : ((typeSymbol = SymbolUtil.getTypeDescriptor(symbol = ((SymbolCompletionItem)lsCItem).getSymbol().get())).isEmpty() ? SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem, 1)) : SortingUtil.genSortText(1) + this.getSortTextForResolvedType(typeSymbol.get(), (SyntaxKind)interpolationParent[0]) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)));
            lsCItem.getCompletionItem().setSortText((String)sortText);
        }
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, TemplateExpressionNode node) {
        return node.textRange().startOffset() <= context.getCursorPositionInTree() && context.getCursorPositionInTree() <= node.textRange().endOffset();
    }

    private boolean isCursorWithInBackticks(BallerinaCompletionContext context, TemplateExpressionNode node) {
        return node.startBacktick().textRange().startOffset() < context.getCursorPositionInTree() && context.getCursorPositionInTree() < node.endBacktick().textRange().endOffset();
    }

    private Predicate<Symbol> symbolFilterPredicate() {
        return CommonUtil.getVariableFilterPredicate().or(symbol -> symbol.kind() == SymbolKind.FUNCTION && !symbol.getName().orElse("").equals(Names.ERROR.getValue()));
    }

    private TypeSymbol getResolvedType(TypeSymbol typeSymbol) {
        TypeSymbol resolvedType = typeSymbol.typeKind() == TypeDescKind.FUNCTION ? ((FunctionTypeSymbol)typeSymbol).returnTypeDescriptor().orElse(typeSymbol) : typeSymbol;
        return CommonUtil.getRawType(resolvedType);
    }

    private String getSortTextForResolvedType(TypeSymbol typeSymbol, SyntaxKind interpolationParent) {
        TypeSymbol resolvedType = this.getResolvedType(typeSymbol);
        TypeDescKind typeKind = resolvedType.typeKind();
        switch (interpolationParent) {
            case STRING_TEMPLATE_EXPRESSION: {
                if (typeKind != TypeDescKind.BOOLEAN && typeKind != TypeDescKind.INT && typeKind != TypeDescKind.FLOAT && typeKind != TypeDescKind.DECIMAL && typeKind != TypeDescKind.STRING) break;
                return SortingUtil.genSortText(1);
            }
            case XML_ATTRIBUTE: {
                if (typeKind != TypeDescKind.BOOLEAN && typeKind != TypeDescKind.INT && typeKind != TypeDescKind.FLOAT && typeKind != TypeDescKind.DECIMAL) break;
                return SortingUtil.genSortText(1);
            }
            case XML_ELEMENT: {
                if (typeKind == TypeDescKind.XML || typeKind == TypeDescKind.XML_COMMENT || typeKind == TypeDescKind.XML_ELEMENT || typeKind == TypeDescKind.XML_TEXT || typeKind == TypeDescKind.XML_PROCESSING_INSTRUCTION) {
                    return SortingUtil.genSortText(1);
                }
                if (typeKind != TypeDescKind.BOOLEAN && typeKind != TypeDescKind.INT && typeKind != TypeDescKind.FLOAT && typeKind != TypeDescKind.DECIMAL) break;
                return SortingUtil.genSortText(2);
            }
        }
        return SortingUtil.genSortText(3);
    }
}

