/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class TypeParameterContextProvider<T extends Node>
extends AbstractCompletionProvider<T> {
    public TypeParameterContextProvider(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, T node) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.parent().kind() == SyntaxKind.XML_TYPE_DESC) {
            completionItems.addAll(this.getXMLTypeDescSymbols(context, node));
        } else if (node.parent().kind() == SyntaxKind.ERROR_TYPE_DESC) {
            completionItems.addAll(this.getErrorTypeDescSymbols(context, node));
        } else if (node.parent().kind() == SyntaxKind.TABLE_TYPE_DESC) {
            completionItems.addAll(this.getTableTypeDescSymbols(context, node));
        } else {
            completionItems.addAll(this.getOtherTypeDescSymbols(context, node));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private Collection<? extends LSCompletionItem> getOtherTypeDescSymbols(BallerinaCompletionContext context, T node) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode refNode = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getTypesInModule(context, refNode);
            return this.getCompletionItemList(moduleContent, context);
        }
        return this.getTypeDescContextItems(context);
    }

    private List<LSCompletionItem> getTableTypeDescSymbols(BallerinaCompletionContext context, T node) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        Predicate<Symbol> predicate = symbol -> {
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
                return false;
            }
            TypeSymbol rawType = CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor());
            return rawType.typeKind() == TypeDescKind.MAP || CommonUtil.isUnionOfType(rawType, TypeDescKind.MAP) || rawType.typeKind() == TypeDescKind.RECORD || CommonUtil.isUnionOfType(rawType, TypeDescKind.RECORD);
        };
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode refNode = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, refNode, predicate);
            return this.getCompletionItemList(moduleContent, context);
        }
        List<Symbol> filtered = context.visibleSymbols(context.getCursorPosition()).stream().filter(predicate).toList();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.addAll(this.getModuleCompletionItems(context));
        completionItems.addAll(this.getCompletionItemList(filtered, context));
        completionItems.addAll(Arrays.asList(new SnippetCompletionItem(context, Snippet.KW_RECORD.get()), new SnippetCompletionItem(context, Snippet.DEF_RECORD_TYPE_DESC.get()), new SnippetCompletionItem(context, Snippet.DEF_CLOSED_RECORD_TYPE_DESC.get())));
        return completionItems;
    }

    private List<LSCompletionItem> getErrorTypeDescSymbols(BallerinaCompletionContext context, T node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        Predicate<Symbol> predicate = symbol -> {
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
                return false;
            }
            TypeSymbol typeDesc = ((TypeDefinitionSymbol)symbol).typeDescriptor();
            return CommonUtil.getRawType(typeDesc).typeKind() == TypeDescKind.MAP || CommonUtil.getRawType(typeDesc).typeKind() == TypeDescKind.RECORD;
        };
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            List<Symbol> mappingTypes = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, (QualifiedNameReferenceNode)nodeAtCursor, predicate);
            completionItems.addAll(this.getCompletionItemList(mappingTypes, context));
        } else {
            completionItems.addAll(Arrays.asList(new SnippetCompletionItem(context, Snippet.DEF_RECORD_TYPE_DESC.get()), new SnippetCompletionItem(context, Snippet.DEF_CLOSED_RECORD_TYPE_DESC.get())));
            List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
            List<Symbol> mappingTypes = visibleSymbols.stream().filter(predicate).toList();
            completionItems.addAll(this.getCompletionItemList(mappingTypes, context));
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        return completionItems;
    }

    private List<LSCompletionItem> getXMLTypeDescSymbols(BallerinaCompletionContext context, T node) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Predicate<Symbol> predicate = symbol -> {
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION) {
                return false;
            }
            return SymbolUtil.getTypeDescriptor(symbol).map(CommonUtil::getRawType).filter(typeSymbol -> typeSymbol.typeKind().isXMLType()).isPresent();
        };
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode refNode = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, refNode, predicate);
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else {
            List<Symbol> filtered = visibleSymbols.stream().filter(predicate).toList();
            completionItems.addAll(this.getCompletionItemList(filtered, context));
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, T node, List<LSCompletionItem> completionItems) {
        if (node.parent().kind() == SyntaxKind.KEY_TYPE_CONSTRAINT && node.parent().parent().kind() == SyntaxKind.TABLE_TYPE_DESC) {
            TableTypeDescriptorNode tableTypeDesc = (TableTypeDescriptorNode)node.parent().parent();
            TypeParameterNode typeParameterNode = (TypeParameterNode)tableTypeDesc.rowTypeParameterNode();
            Optional typeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)typeParameterNode.typeNode())).flatMap(SymbolUtil::getTypeDescriptor);
            if (typeSymbol.isPresent() && CommonUtil.getRawType((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.RECORD) {
                RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)CommonUtil.getRawType((TypeSymbol)typeSymbol.get());
                Set typeNames = recordTypeSymbol.fieldDescriptors().values().stream().filter(recordFieldSymbol -> recordFieldSymbol.qualifiers().contains(Qualifier.READONLY)).map(recordFieldSymbol -> recordFieldSymbol.typeDescriptor().getName().orElse(recordFieldSymbol.typeDescriptor().typeKind().getName())).filter(name -> !name.isEmpty()).collect(Collectors.toSet());
                completionItems.forEach(lsCItem -> {
                    String sortText = typeNames.contains(lsCItem.getCompletionItem().getInsertText()) ? SortingUtil.genSortText(1) + SortingUtil.genSortTextForTypeDescContext(context, lsCItem) : SortingUtil.genSortText(2) + SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
                    lsCItem.getCompletionItem().setSortText(sortText);
                });
                return;
            }
        }
        completionItems.forEach(lsCItem -> {
            String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
            lsCItem.getCompletionItem().setSortText(sortText);
        });
    }
}

