/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.projects.Module;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.TypeCompletionItem;
import org.ballerinalang.langserver.completions.builder.TypeCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class TypeTestExpressionNodeContext
extends AbstractCompletionProvider<TypeTestExpressionNode> {
    public TypeTestExpressionNodeContext() {
        super(TypeTestExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, TypeTestExpressionNode node) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onExpressionContext(context, node)) {
            completionItems.addAll(this.expressionCompletions(context, node));
        } else if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(typesInModule, context));
        } else {
            if (this.isValidTypeName(node.typeDescriptor()) && context.getCursorPosition().getCharacter() > node.typeDescriptor().lineRange().endLine().offset()) {
                return CompletionUtil.route(context, (Node)node.parent());
            }
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.addAll(this.getModuleTypeDescCompletionsForExpression(context, node));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private boolean isValidTypeName(Node node) {
        if (node.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return !((SimpleNameReferenceNode)node).name().text().isEmpty();
        }
        return true;
    }

    private List<LSCompletionItem> getModuleTypeDescCompletionsForExpression(BallerinaCompletionContext context, TypeTestExpressionNode node) {
        List<TypeReferenceTypeSymbol> typeReferences;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional typeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node.expression()));
        Optional currentModule = context.currentModule();
        if (typeSymbol.isEmpty() || currentModule.isEmpty()) {
            return completionItems;
        }
        if (((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.UNION) {
            typeReferences = ((UnionTypeSymbol)typeSymbol.get()).memberTypeDescriptors().stream().filter(type -> type.typeKind() == TypeDescKind.TYPE_REFERENCE).map(type -> (TypeReferenceTypeSymbol)type).toList();
        } else if (((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.TYPE_REFERENCE) {
            typeReferences = List.of((TypeReferenceTypeSymbol)typeSymbol.get());
        } else {
            return completionItems;
        }
        typeReferences.stream().filter(typeRef -> this.isQualifiedTypeReference(context, (TypeSymbol)typeRef)).forEach(typeRef -> {
            String typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, (TypeSymbol)typeRef);
            if (!typeName.isEmpty()) {
                TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)typeRef);
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(context, (Symbol)rawType, TypeCompletionItemBuilder.build((Symbol)rawType, typeName)));
            }
        });
        return completionItems;
    }

    private boolean isQualifiedTypeReference(BallerinaCompletionContext context, TypeSymbol typeSymbol) {
        Optional module = typeSymbol.getModule();
        Optional currentModule = context.currentModule();
        Optional name = typeSymbol.getName();
        if (typeSymbol.typeKind() != TypeDescKind.TYPE_REFERENCE && module.isEmpty() || name.isEmpty() || currentModule.isEmpty()) {
            return false;
        }
        ModuleID moduleID = ((ModuleSymbol)module.get()).id();
        Optional moduleName = ((ModuleSymbol)module.get()).getName();
        String orgName = moduleID.orgName();
        String currentModuleName = ((Module)currentModule.get()).isDefaultModule() ? ((Module)currentModule.get()).moduleName().packageName().value() : ((Module)currentModule.get()).moduleName().moduleNamePart();
        String currentOrg = ((Module)context.currentModule().get()).packageInstance().packageOrg().value();
        return !moduleName.isEmpty() && (!orgName.equals(currentOrg) || !((String)moduleName.get()).equals(currentModuleName));
    }

    private boolean onExpressionContext(BallerinaCompletionContext context, TypeTestExpressionNode node) {
        Token isKeyword;
        int cursor = context.getCursorPositionInTree();
        return cursor < (isKeyword = node.isKeyword()).textRange().startOffset();
    }

    @Override
    protected List<LSCompletionItem> expressionCompletions(BallerinaCompletionContext context, TypeTestExpressionNode node) {
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> typesInModule = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            return this.getCompletionItemList(typesInModule, context);
        }
        return this.expressionCompletions(context);
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, TypeTestExpressionNode node) {
        return !node.isKeyword().isMissing();
    }

    @Override
    public void sort(BallerinaCompletionContext context, TypeTestExpressionNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node.expression()));
        if (typeSymbol.isEmpty()) {
            super.sort(context, node, completionItems);
        }
        completionItems.forEach(lsCItem -> {
            Optional<Object> tSymbol;
            int rank = 2;
            if (lsCItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && (tSymbol = ((SymbolCompletionItem)((Object)lsCItem)).getSymbol().filter(symbol -> CommonUtil.typesFilter().test((Symbol)symbol) || symbol.kind() == SymbolKind.TYPE).flatMap(SymbolUtil::getTypeDescriptor)).isPresent() && ((TypeSymbol)tSymbol.get()).subtypeOf((TypeSymbol)typeSymbol.get())) {
                rank = 1;
            }
            if (lsCItem.getType() == LSCompletionItem.CompletionItemType.TYPE && (tSymbol = ((TypeCompletionItem)((Object)lsCItem)).getTypeSymbol()).isPresent() && ((TypeSymbol)tSymbol.get()).subtypeOf((TypeSymbol)typeSymbol.get())) {
                rank = 1;
            }
            lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(rank) + SortingUtil.genSortTextForTypeDescContext(context, lsCItem));
        });
    }
}

