/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.NodeWithRHSInitializerProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;

public class VariableDeclarationNodeContext
extends NodeWithRHSInitializerProvider<VariableDeclarationNode> {
    public VariableDeclarationNodeContext() {
        super(VariableDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, VariableDeclarationNode node) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.initializer().isPresent() && this.onExpressionContext(context, node)) {
            completionItems.addAll(this.initializerContextCompletions(context, (Node)node.initializer().get()));
            this.sort(context, node, completionItems);
            return completionItems;
        }
        if (this.onSuggestionsAfterQualifiers(context, (Node)node)) {
            completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node, context));
            this.sort(context, node, completionItems);
            return completionItems;
        }
        if (this.onVariableNameContext(context, node)) {
            return Collections.emptyList();
        }
        return CompletionUtil.route(context, (Node)node.parent());
    }

    private boolean onExpressionContext(BallerinaCompletionContext context, VariableDeclarationNode node) {
        if (node.equalsToken().isEmpty()) {
            return false;
        }
        int textPosition = context.getCursorPositionInTree();
        TextRange equalTokenRange = ((Token)node.equalsToken().get()).textRange();
        return equalTokenRange.endOffset() <= textPosition;
    }

    private boolean onVariableNameContext(BallerinaCompletionContext context, VariableDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        TypedBindingPatternNode typedBindingPatternNode = node.typedBindingPattern();
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        Optional equalsToken = node.equalsToken();
        return cursor > typeDescriptorNode.textRange().endOffset() && (equalsToken.isEmpty() || cursor < ((Token)equalsToken.get()).textRange().startOffset());
    }
}

