/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLNamespaceDeclarationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class XMLNSDeclarationNodeContext
extends AbstractCompletionProvider<XMLNamespaceDeclarationNode> {
    public XMLNSDeclarationNodeContext() {
        super(XMLNamespaceDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, XMLNamespaceDeclarationNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestConstants(context, node)) {
            Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.CONSTANT && ((ConstantSymbol)symbol).broaderTypeDescriptor().typeKind() == TypeDescKind.STRING;
            NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
                List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate);
                completionItems.addAll(this.getCompletionItemList(moduleContent, context));
            } else {
                List<Symbol> constants = context.visibleSymbols(context.getCursorPosition()).stream().filter(predicate).toList();
                completionItems.addAll(this.getCompletionItemList(constants, context));
                completionItems.addAll(this.getModuleCompletionItems(context));
            }
        } else if (this.onSuggestAsKeyword(context, node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_AS.get()));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean onSuggestConstants(BallerinaCompletionContext context, XMLNamespaceDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token xmlnsKeyword = node.xmlnsKeyword();
        Optional asKeyword = node.asKeyword();
        ExpressionNode namespaceuri = node.namespaceuri();
        return !(xmlnsKeyword.textRange().endOffset() >= cursor || !asKeyword.isEmpty() && ((Token)asKeyword.get()).textRange().startOffset() <= cursor || !namespaceuri.isMissing() && cursor >= namespaceuri.textRange().endOffset() + 1);
    }

    private boolean onSuggestAsKeyword(BallerinaCompletionContext context, XMLNamespaceDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        ExpressionNode namespaceuri = node.namespaceuri();
        Optional asKeyword = node.asKeyword();
        return !namespaceuri.isMissing() && cursor >= namespaceuri.textRange().endOffset() + 1 && (asKeyword.isEmpty() || ((Token)asKeyword.get()).isMissing());
    }
}

