/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context.util;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.util.Snippet;

public final class QueryExpressionUtil {
    private QueryExpressionUtil() {
    }

    public static List<LSCompletionItem> getCommonKeywordCompletions(BallerinaCompletionContext context) {
        return Arrays.asList(new LSCompletionItem[]{new SnippetCompletionItem(context, Snippet.KW_WHERE.get()), new SnippetCompletionItem(context, Snippet.KW_LET.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_LET.get()), new SnippetCompletionItem(context, Snippet.KW_OUTER.get()), new SnippetCompletionItem(context, Snippet.KW_JOIN.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_JOIN.get()), new SnippetCompletionItem(context, Snippet.KW_ORDERBY.get()), new SnippetCompletionItem(context, Snippet.KW_LIMIT.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_DO.get()), new SnippetCompletionItem(context, Snippet.KW_SELECT.get()), new SnippetCompletionItem(context, Snippet.KW_FROM.get()), new SnippetCompletionItem(context, Snippet.KW_GROUPBY.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_GROUPBY.get()), new SnippetCompletionItem(context, Snippet.KW_COLLECT.get())});
    }

    public static List<FunctionSymbol> getLangLibMethods(BallerinaCompletionContext context) {
        Types types = ((SemanticModel)context.currentSemanticModel().get()).types();
        List langLibMethods = types.INT.langLibMethods();
        langLibMethods.addAll(types.DECIMAL.langLibMethods());
        langLibMethods.addAll(types.FLOAT.langLibMethods());
        langLibMethods.addAll(types.STRING.langLibMethods());
        langLibMethods.addAll(types.BOOLEAN.langLibMethods());
        langLibMethods.addAll(types.ANY.langLibMethods());
        langLibMethods.addAll(types.ANYDATA.langLibMethods());
        langLibMethods.addAll(types.BYTE.langLibMethods());
        langLibMethods.addAll(types.ERROR.langLibMethods());
        langLibMethods.addAll(types.FUNCTION.langLibMethods());
        langLibMethods.addAll(types.FUTURE.langLibMethods());
        langLibMethods.addAll(types.HANDLE.langLibMethods());
        langLibMethods.addAll(types.JSON.langLibMethods());
        langLibMethods.addAll(types.NEVER.langLibMethods());
        langLibMethods.addAll(types.NIL.langLibMethods());
        langLibMethods.addAll(types.READONLY.langLibMethods());
        langLibMethods.addAll(types.REGEX.langLibMethods());
        langLibMethods.addAll(types.STREAM.langLibMethods());
        langLibMethods.addAll(types.TYPEDESC.langLibMethods());
        langLibMethods.addAll(types.XML.langLibMethods());
        return langLibMethods.stream().distinct().toList();
    }
}

