/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context.util;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReBracedQuantifierNode;
import io.ballerina.compiler.syntax.tree.ReCapturingGroupsNode;
import io.ballerina.compiler.syntax.tree.ReFlagExpressionNode;
import io.ballerina.compiler.syntax.tree.ReFlagsOnOffNode;
import io.ballerina.compiler.syntax.tree.ReQuantifierNode;
import io.ballerina.compiler.syntax.tree.ReUnicodeGeneralCategoryNode;
import io.ballerina.compiler.syntax.tree.ReUnicodePropertyEscapeNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SnippetBlock;

public final class RegexpCompletionProvider {
    private static final List<String> WORD_SEPARATOR_ARRAY = Arrays.asList("`", "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "-", "=", "+", "[", "{", "]", "}", "\\", "|", ";", ":", "'", "\"", ",", ".", "<", ">", "/", "?");
    private static final HashSet<String> RE_FLAGS = new HashSet<String>(Arrays.asList("i", "m", "s", "x"));

    private RegexpCompletionProvider() {
    }

    public static List<LSCompletionItem> getRegexCompletions(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx) {
        RegexTemplateNodeFinder nodeFinder = new RegexTemplateNodeFinder();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (nodeAtCursor.kind() == SyntaxKind.LIST) {
            nodeAtCursor.parent().accept((NodeVisitor)nodeFinder);
        } else {
            nodeAtCursor.accept((NodeVisitor)nodeFinder);
        }
        String resolvedWord = null;
        if (nodeAtCursor.kind() == SyntaxKind.RE_QUOTE_ESCAPE && nodeAtCursor.toSourceCode().equals(SyntaxKind.BACK_SLASH_TOKEN.stringValue())) {
            RegexpCompletionProvider.addQuoteEscapeValueCompletions(ctx, completionItems);
            return completionItems;
        }
        if (RegexpCompletionProvider.isFlagExpr(nodeAtCursor, ctx)) {
            RegexpCompletionProvider.addCapturingGroupCompletions(ctx, completionItems);
            return completionItems;
        }
        if (nodeAtCursor.kind() == SyntaxKind.RE_QUOTE_ESCAPE && nodeAtCursor.toSourceCode().equals("\\p")) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("{}", "p{}", "p{${1}}", "Snippet", SnippetBlock.Kind.SNIPPET)));
            RegexpCompletionProvider.addAssertionEndCompletion(nodeAtCursor, ctx, nodeFinder, completionItems, null);
            return completionItems;
        }
        if (nodeAtCursor.kind() == SyntaxKind.RE_QUOTE_ESCAPE && nodeAtCursor.toSourceCode().equals("\\P")) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("{}", "P{}", "P{${1}}", "Snippet", SnippetBlock.Kind.SNIPPET)));
            RegexpCompletionProvider.addAssertionEndCompletion(nodeAtCursor, ctx, nodeFinder, completionItems, null);
            return completionItems;
        }
        if (RegexpCompletionProvider.isUnicodePropertyEscapeNode(nodeAtCursor, ctx)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_SCRIPT_PROPERTY_KEY.snippetBlock));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PROPERTY_KEY.snippetBlock));
            RegexpCompletionProvider.addUnicodeGeneralCategoryMajorSnippets(ctx, completionItems);
            return completionItems;
        }
        if (nodeAtCursor.kind() == SyntaxKind.RE_UNICODE_GENERAL_CATEGORY) {
            ReUnicodeGeneralCategoryNode unicodeGeneralCategoryNode = (ReUnicodeGeneralCategoryNode)nodeAtCursor;
            if (unicodeGeneralCategoryNode.categoryStart().isPresent() && unicodeGeneralCategoryNode.reUnicodeGeneralCategoryName().isMissing()) {
                RegexpCompletionProvider.addUnicodeGeneralCategoryMajorSnippets(ctx, completionItems);
            } else if (unicodeGeneralCategoryNode.reUnicodeGeneralCategoryName().textRange().endOffset() == ctx.getCursorPositionInTree()) {
                RegexpCompletionProvider.addUnicodeGeneralCategorySnippets(unicodeGeneralCategoryNode, ctx, completionItems);
            }
            return completionItems;
        }
        if (RegexpCompletionProvider.isCapturingGroupStart(nodeAtCursor, ctx)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("?", "?", "?", "Value", SnippetBlock.Kind.VALUE)));
            return completionItems;
        }
        if (RegexpCompletionProvider.isReAtom(nodeAtCursor, ctx)) {
            String snippet;
            resolvedWord = snippet = RegexpCompletionProvider.resolveWordForTheGivenCursorPosition(ctx, nodeFinder);
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("*", snippet + "*", snippet + "*", "Value", SnippetBlock.Kind.VALUE)));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("+", snippet + "+", snippet + "+", "Value", SnippetBlock.Kind.VALUE)));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("?", snippet + "?", snippet + "?", "Value", SnippetBlock.Kind.VALUE)));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("{}", snippet + "{}", snippet + "{${1}}", "Snippet", SnippetBlock.Kind.SNIPPET)));
            RegexpCompletionProvider.addAssertionEndCompletion(nodeAtCursor, ctx, nodeFinder, completionItems, resolvedWord);
            return completionItems;
        }
        if (nodeAtCursor.kind() == SyntaxKind.RE_CHARACTER_CLASS && nodeAtCursor.textRange().startOffset() + 1 == ctx.getCursorPositionInTree()) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("^", "^", "^", "Value", SnippetBlock.Kind.VALUE)));
            return completionItems;
        }
        if (RegexpCompletionProvider.isCommaPresentInReBracedQuantifierNode(nodeAtCursor, ctx)) {
            String snippet = nodeAtCursor.toSourceCode();
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock(",", snippet + ",", snippet + ",", "Value", SnippetBlock.Kind.VALUE)));
            RegexpCompletionProvider.addAssertionEndCompletion(nodeAtCursor, ctx, nodeFinder, completionItems, null);
            return completionItems;
        }
        if (RegexpCompletionProvider.isReQuantifier(nodeAtCursor)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("?", "?", "?", "Value", SnippetBlock.Kind.VALUE)));
            RegexpCompletionProvider.addAssertionEndCompletion(nodeAtCursor, ctx, nodeFinder, completionItems, null);
            return completionItems;
        }
        if (nodeAtCursor.kind() == SyntaxKind.RE_BRACED_QUANTIFIER && nodeAtCursor.textRange().endOffset() == ctx.getCursorPositionInTree()) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("?", "?", "?", "Value", SnippetBlock.Kind.VALUE)));
            RegexpCompletionProvider.addAssertionEndCompletion(nodeAtCursor, ctx, nodeFinder, completionItems, null);
            return completionItems;
        }
        if (RegexpCompletionProvider.isCursorAfterReFlag(nodeAtCursor)) {
            String snippet = RegexpCompletionProvider.resolveWordForTheGivenCursorPosition(ctx, nodeFinder);
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock(":", snippet + ":", snippet + ":", "Value", SnippetBlock.Kind.VALUE)));
            if (((ReFlagsOnOffNode)nodeAtCursor.parent().parent()).rhsReFlags().isEmpty()) {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("-", snippet + "-", snippet + "-", "Value", SnippetBlock.Kind.VALUE)));
            }
            RegexpCompletionProvider.addReFlags(nodeAtCursor, ctx, completionItems, snippet);
            return completionItems;
        }
        if (RegexpCompletionProvider.isCursorAfterReOnOffFlagMinusPosition(nodeAtCursor)) {
            String snippet = RegexpCompletionProvider.resolveWordForTheGivenCursorPosition(ctx, nodeFinder);
            RegexpCompletionProvider.addReFlags(nodeAtCursor, ctx, completionItems, snippet);
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_COLON_CHAR.get()));
            return completionItems;
        }
        if (nodeAtCursor.kind() == SyntaxKind.REGEX_TEMPLATE_EXPRESSION) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.DEF_PARANTHESIS.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.DEF_SQUARE_BRACKET.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_ASSERTION_START.get()));
            RegexpCompletionProvider.addAssertionEndCompletion(nodeAtCursor, ctx, nodeFinder, completionItems, null);
            return completionItems;
        }
        return completionItems;
    }

    private static void addCapturingGroupCompletions(BallerinaCompletionContext ctx, List<LSCompletionItem> completionItems) {
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_MULTILINE_FLAG.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_DOT_ALL_FLAG.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_IGNORE_CASE_FLAG.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_COMMENT_FLAG.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_COLON_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_MINUS_CHAR.get()));
    }

    private static void addQuoteEscapeValueCompletions(BallerinaCompletionContext ctx, List<LSCompletionItem> completionItems) {
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_DIGIT.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_NON_DIGIT.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_WHITESPACE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_NON_WHITESPACE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_ALPHA_NUMERIC.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_NON_ALPHA_NUMERIC.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_RETURN.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_NEWLINE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_TAB.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_ASSERTION_START.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_ASSERTION_END.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_BACKSLASH_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_DOT_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_QUANTIFIER_ASTERISK_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_QUANTIFIER_PLUS_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_QUANTIFIER_QUESTION_MARK_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_LEFT_BRACE_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_RIGHT_BRACE_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_LEFT_SQUARE_BRACE_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_RIGHT_SQUARE_BRACE_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_LEFT_CURLY_BRACE_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_RIGHT_CURLY_BRACE_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_PIPE_CHAR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_PROPERTY_CHAR.snippetBlock));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_NON_UNICODE_PROPERTY_CHAR.snippetBlock));
    }

    private static void addAssertionEndCompletion(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx, RegexTemplateNodeFinder nodeFinder, List<LSCompletionItem> completionItems, String resolvedWord) {
        if (nodeFinder.getTemplateExpressionNode() != null && nodeFinder.getTemplateExpressionNode().textRange().endOffset() - 1 == ctx.getCursorPositionInTree() && nodeAtCursor.kind() != SyntaxKind.RE_QUOTE_ESCAPE) {
            if (resolvedWord == null) {
                resolvedWord = RegexpCompletionProvider.resolveWordForTheGivenCursorPosition(ctx, nodeFinder);
            }
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock("$", resolvedWord + "$", resolvedWord + "$", "Value", SnippetBlock.Kind.VALUE)));
        }
    }

    private static boolean isReQuantifier(NonTerminalNode nodeAtCursor) {
        return nodeAtCursor.kind() == SyntaxKind.RE_QUANTIFIER && ((ReQuantifierNode)nodeAtCursor).nonGreedyChar().isEmpty();
    }

    private static void addReFlags(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx, List<LSCompletionItem> completionItems, String snippet) {
        String reFlagsSource = nodeAtCursor.parent().parent().toSourceCode();
        for (String flag : RE_FLAGS) {
            if (reFlagsSource.contains(flag)) continue;
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, new SnippetBlock(flag, snippet + flag, snippet + flag, "Value", SnippetBlock.Kind.VALUE)));
        }
    }

    private static String resolveWordForTheGivenCursorPosition(BallerinaCompletionContext ctx, RegexTemplateNodeFinder nodeFinder) {
        TemplateExpressionNode templateExpressionNode = nodeFinder.getTemplateExpressionNode();
        if (templateExpressionNode != null) {
            if (templateExpressionNode.startBacktick().textRange().endOffset() == templateExpressionNode.endBacktick().textRange().startOffset()) {
                return "";
            }
            int startIndex = templateExpressionNode.textRange().startOffset();
            int currentPosition = ctx.getCursorPositionInTree();
            int expressionStartIndex = templateExpressionNode.startBacktick().textRange().startOffset() - templateExpressionNode.textRange().startOffset();
            int subStrLength = currentPosition - startIndex;
            String subStr = templateExpressionNode.toSourceCode().trim().substring(expressionStartIndex + 1, subStrLength);
            int len = subStr.length() - 1;
            String currentChar = subStr.substring(len, len + 1);
            boolean isCurrentCharAWordSeparator = WORD_SEPARATOR_ARRAY.contains(currentChar);
            while (!isCurrentCharAWordSeparator && len != 0) {
                --currentPosition;
                currentChar = subStr.substring(--len, len + 1);
                isCurrentCharAWordSeparator = WORD_SEPARATOR_ARRAY.contains(currentChar);
            }
            if (isCurrentCharAWordSeparator) {
                return subStr.substring(len + 1);
            }
            return subStr.substring(len);
        }
        return "";
    }

    private static boolean isCursorAfterReFlag(NonTerminalNode nodeAtCursor) {
        return nodeAtCursor.parent().kind() == SyntaxKind.RE_FLAGS;
    }

    private static boolean isCursorAfterReOnOffFlagMinusPosition(NonTerminalNode nodeAtCursor) {
        return nodeAtCursor.kind() == SyntaxKind.RE_FLAGS_ON_OFF && ((ReFlagsOnOffNode)nodeAtCursor).minusToken().isPresent();
    }

    private static boolean isCommaPresentInReBracedQuantifierNode(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx) {
        return nodeAtCursor.parent().kind() == SyntaxKind.RE_BRACED_QUANTIFIER && ((ReBracedQuantifierNode)nodeAtCursor.parent()).commaToken().isEmpty() && ((ReBracedQuantifierNode)nodeAtCursor.parent()).leastTimesMatchedDigit().size() + 1 <= ctx.getCursorPositionInTree();
    }

    private static void addUnicodeGeneralCategoryMajorSnippets(BallerinaCompletionContext ctx, List<LSCompletionItem> completionItems) {
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_LETTER.snippetBlock));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_MARK.snippetBlock));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_NUMBER.snippetBlock));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SYMBOL.snippetBlock));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION.snippetBlock));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR.snippetBlock));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_OTHER.snippetBlock));
    }

    private static void addUnicodeGeneralCategorySnippets(ReUnicodeGeneralCategoryNode unicodeGeneralCategoryNode, BallerinaCompletionContext ctx, List<LSCompletionItem> completionItems) {
        switch (unicodeGeneralCategoryNode.reUnicodeGeneralCategoryName().toSourceCode()) {
            case "L": {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_LETTER_UPPERCASE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_LETTER_LOWERCASE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_LETTER_TITLECASE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_LETTER_MODIFIER.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_LETTER_OTHER.snippetBlock));
                break;
            }
            case "M": {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.DEF_SQUARE_BRACKET.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_MARK_NON_SPACING.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_MARK_SPACING.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_MARK_NON_ENCLOSING.snippetBlock));
                break;
            }
            case "N": {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_NUMBER_DECIMAL_DIGIT.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_NUMBER_LETTER.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_NUMBER_OTHER.snippetBlock));
                break;
            }
            case "S": {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_MATH.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_CURRENCY.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_MODIFIER.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_OTHER.snippetBlock));
                break;
            }
            case "P": {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_CONNECTOR.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_DASH.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_OPEN.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_CLOSE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_INITIAL_QUOTE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_FINAL_QUOTE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_OTHER.snippetBlock));
                break;
            }
            case "Z": {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR_SPACE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR_LINE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR_PARAGRAPH.snippetBlock));
                break;
            }
            case "C": {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_OTHER_CONTROL.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_OTHER_FORMAT.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_OTHER_PRIVATE_USE.snippetBlock));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, RegexSnippet.DEF_UNICODE_GENERAL_CATEGORY_OTHER_NOT_ASSIGNED.snippetBlock));
                break;
            }
        }
    }

    private static boolean isReAtom(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx) {
        return nodeAtCursor.kind() == SyntaxKind.RE_CHARACTER_CLASS && nodeAtCursor.textRange().endOffset() == ctx.getCursorPositionInTree() || nodeAtCursor.kind() == SyntaxKind.RE_LITERAL_CHAR_DOT_OR_ESCAPE || nodeAtCursor.kind() == SyntaxKind.RE_SIMPLE_CHAR_CLASS_ESCAPE || nodeAtCursor.kind() == SyntaxKind.RE_QUOTE_ESCAPE || nodeAtCursor.kind() == SyntaxKind.RE_CAPTURING_GROUP;
    }

    private static boolean isCapturingGroupStart(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx) {
        return nodeAtCursor.kind() == SyntaxKind.RE_CAPTURING_GROUP && ((ReCapturingGroupsNode)nodeAtCursor).openParenthesis().textRange().endOffset() == ctx.getCursorPositionInTree();
    }

    private static boolean isFlagExpr(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx) {
        return nodeAtCursor.kind() == SyntaxKind.RE_FLAG_EXPR && ((ReFlagExpressionNode)nodeAtCursor).questionMark().position() + 1 == ctx.getCursorPositionInTree();
    }

    private static boolean isUnicodePropertyEscapeNode(NonTerminalNode nodeAtCursor, BallerinaCompletionContext ctx) {
        return nodeAtCursor.kind() == SyntaxKind.RE_UNICODE_PROPERTY_ESCAPE && !((ReUnicodePropertyEscapeNode)nodeAtCursor).openBraceToken().isMissing() && !((ReUnicodePropertyEscapeNode)nodeAtCursor).closeBraceToken().isMissing() && ((ReUnicodePropertyEscapeNode)nodeAtCursor).openBraceToken().textRange().endOffset() == ctx.getCursorPositionInTree();
    }

    static class RegexTemplateNodeFinder
    extends NodeVisitor {
        private TemplateExpressionNode templateExpressionNode = null;

        RegexTemplateNodeFinder() {
        }

        public void visit(TemplateExpressionNode templateExpressionNode) {
            this.templateExpressionNode = templateExpressionNode;
        }

        public TemplateExpressionNode getTemplateExpressionNode() {
            return this.templateExpressionNode;
        }

        protected void visitSyntaxNode(Node node) {
            if (this.templateExpressionNode != null) {
                return;
            }
            node.parent().accept((NodeVisitor)this);
        }
    }

    private static enum RegexSnippet {
        DEF_DIGIT(new SnippetBlock("d", "d", "d", "Value", SnippetBlock.Kind.VALUE)),
        DEF_NON_DIGIT(new SnippetBlock("D", "D", "D", "Value", SnippetBlock.Kind.VALUE)),
        DEF_WHITESPACE(new SnippetBlock("s", "s", "s", "Value", SnippetBlock.Kind.VALUE)),
        DEF_NON_WHITESPACE(new SnippetBlock("S", "S", "S", "Value", SnippetBlock.Kind.VALUE)),
        DEF_ALPHA_NUMERIC(new SnippetBlock("w", "w", "w", "Value", SnippetBlock.Kind.VALUE)),
        DEF_NON_ALPHA_NUMERIC(new SnippetBlock("W", "W", "W", "Value", SnippetBlock.Kind.VALUE)),
        DEF_RETURN(new SnippetBlock("r", "r", "r", "Value", SnippetBlock.Kind.VALUE)),
        DEF_NEWLINE(new SnippetBlock("n", "n", "n", "Value", SnippetBlock.Kind.VALUE)),
        DEF_TAB(new SnippetBlock("t", "t", "t", "Value", SnippetBlock.Kind.VALUE)),
        DEF_MULTILINE_FLAG(new SnippetBlock("m", "m", "m", "Value", SnippetBlock.Kind.VALUE)),
        DEF_DOT_ALL_FLAG(new SnippetBlock("s", "s", "s", "Value", SnippetBlock.Kind.VALUE)),
        DEF_IGNORE_CASE_FLAG(new SnippetBlock("i", "i", "i", "Value", SnippetBlock.Kind.VALUE)),
        DEF_COMMENT_FLAG(new SnippetBlock("x", "x", "x", "Value", SnippetBlock.Kind.VALUE)),
        DEF_ASSERTION_START(new SnippetBlock("^", "^", "^", "Value", SnippetBlock.Kind.VALUE)),
        DEF_ASSERTION_END(new SnippetBlock("$", "$", "$", "Value", SnippetBlock.Kind.VALUE)),
        DEF_BACKSLASH_CHAR(new SnippetBlock("\\", "\\", "\\", "Value", SnippetBlock.Kind.VALUE)),
        DEF_DOT_CHAR(new SnippetBlock(".", ".", ".", "Value", SnippetBlock.Kind.VALUE)),
        DEF_QUANTIFIER_ASTERISK_CHAR(new SnippetBlock("*", "*", "*", "Value", SnippetBlock.Kind.VALUE)),
        DEF_QUANTIFIER_PLUS_CHAR(new SnippetBlock("+", "+", "+", "Value", SnippetBlock.Kind.VALUE)),
        DEF_QUANTIFIER_QUESTION_MARK_CHAR(new SnippetBlock("?", "?", "?", "Value", SnippetBlock.Kind.VALUE)),
        DEF_COLON_CHAR(new SnippetBlock(":", ":", ":", "Value", SnippetBlock.Kind.VALUE)),
        DEF_MINUS_CHAR(new SnippetBlock("-", "-", "-", "Value", SnippetBlock.Kind.VALUE)),
        DEF_LEFT_BRACE_CHAR(new SnippetBlock("(", "(", "(", "Value", SnippetBlock.Kind.VALUE)),
        DEF_RIGHT_BRACE_CHAR(new SnippetBlock(")", ")", ")", "Value", SnippetBlock.Kind.VALUE)),
        DEF_LEFT_SQUARE_BRACE_CHAR(new SnippetBlock("[", "[", "[", "Value", SnippetBlock.Kind.VALUE)),
        DEF_RIGHT_SQUARE_BRACE_CHAR(new SnippetBlock("]", "]", "]", "Value", SnippetBlock.Kind.VALUE)),
        DEF_LEFT_CURLY_BRACE_CHAR(new SnippetBlock("{", "{", "{", "Value", SnippetBlock.Kind.VALUE)),
        DEF_RIGHT_CURLY_BRACE_CHAR(new SnippetBlock("}", "}", "}", "Value", SnippetBlock.Kind.VALUE)),
        DEF_PIPE_CHAR(new SnippetBlock("|", "|", "|", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_PROPERTY_CHAR(new SnippetBlock("p", "p", "p", "Value", SnippetBlock.Kind.VALUE)),
        DEF_NON_UNICODE_PROPERTY_CHAR(new SnippetBlock("P", "P", "P", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_SCRIPT_PROPERTY_KEY(new SnippetBlock("sc=", "sc=", "sc=", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PROPERTY_KEY(new SnippetBlock("gc=", "gc=", "gc=", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_LETTER(new SnippetBlock("L", "L", "L", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_LETTER_UPPERCASE(new SnippetBlock("u", "Lu", "Lu", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_LETTER_LOWERCASE(new SnippetBlock("l", "Ll", "Ll", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_LETTER_TITLECASE(new SnippetBlock("t", "Lt", "Lt", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_LETTER_MODIFIER(new SnippetBlock("m", "Lm", "Lm", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_LETTER_OTHER(new SnippetBlock("o", "Lo", "Lo", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_MARK(new SnippetBlock("M", "M", "M", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_MARK_NON_SPACING(new SnippetBlock("n", "Mn", "Mn", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_MARK_SPACING(new SnippetBlock("c", "Mc", "Mc", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_MARK_NON_ENCLOSING(new SnippetBlock("e", "Me", "Me", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_NUMBER(new SnippetBlock("N", "N", "N", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_NUMBER_DECIMAL_DIGIT(new SnippetBlock("d", "Nd", "Nd", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_NUMBER_LETTER(new SnippetBlock("l", "Nl", "Nl", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_NUMBER_OTHER(new SnippetBlock("o", "No", "No", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SYMBOL(new SnippetBlock("S", "S", "S", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_MATH(new SnippetBlock("m", "Sm", "Sm", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_CURRENCY(new SnippetBlock("c", "Sc", "Sc", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_MODIFIER(new SnippetBlock("k", "Sk", "Sk", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SYMBOL_OTHER(new SnippetBlock("o", "So", "So", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION(new SnippetBlock("P", "P", "P", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_CONNECTOR(new SnippetBlock("c", "Pc", "Pc", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_DASH(new SnippetBlock("d", "Pd", "Pd", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_OPEN(new SnippetBlock("s", "Ps", "Ps", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_CLOSE(new SnippetBlock("e", "Pe", "Pe", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_INITIAL_QUOTE(new SnippetBlock("i", "Pi", "Pi", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_FINAL_QUOTE(new SnippetBlock("f", "Pf", "Pf", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_PUNCTUATION_OTHER(new SnippetBlock("o", "Po", "Po", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR(new SnippetBlock("Z", "Z", "Z", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR_SPACE(new SnippetBlock("s", "Zs", "Zs", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR_LINE(new SnippetBlock("l", "Zl", "Zl", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_SEPARATOR_PARAGRAPH(new SnippetBlock("p", "Zp", "Zp", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_OTHER(new SnippetBlock("C", "C", "C", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_OTHER_CONTROL(new SnippetBlock("c", "Cc", "Cc", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_OTHER_FORMAT(new SnippetBlock("f", "Cf", "Cf", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_OTHER_PRIVATE_USE(new SnippetBlock("o", "Co", "Co", "Value", SnippetBlock.Kind.VALUE)),
        DEF_UNICODE_GENERAL_CATEGORY_OTHER_NOT_ASSIGNED(new SnippetBlock("n", "Cn", "Cn", "Value", SnippetBlock.Kind.VALUE));

        private final SnippetBlock snippetBlock;

        private RegexSnippet(SnippetBlock snippetBlock) {
            this.snippetBlock = snippetBlock;
            this.snippetBlock.setId(this.name());
        }

        public SnippetBlock get() {
            return this.snippetBlock;
        }
    }
}

