/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context.util;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.codeaction.CodeActionModuleId;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.SnippetContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.builder.ServiceTemplateCompletionItemBuilder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;

public class ServiceTemplateGenerator {
    private static final LanguageServerContext.Key<ServiceTemplateGenerator> SERVICE_TEMPLATE_GENERATOR_KEY = new LanguageServerContext.Key();

    private ServiceTemplateGenerator(LanguageServerContext context) {
        context.put(SERVICE_TEMPLATE_GENERATOR_KEY, (Object)this);
    }

    public static ServiceTemplateGenerator getInstance(LanguageServerContext context) {
        ServiceTemplateGenerator serviceTemplateGenerator = (ServiceTemplateGenerator)context.get(SERVICE_TEMPLATE_GENERATOR_KEY);
        if (serviceTemplateGenerator == null) {
            serviceTemplateGenerator = new ServiceTemplateGenerator(context);
        }
        return serviceTemplateGenerator;
    }

    public List<LSCompletionItem> getServiceTemplates(BallerinaCompletionContext ctx) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        HashSet processedModuleList = new HashSet();
        Optional currentModule = ctx.workspace().module(ctx.filePath());
        if (currentModule.isEmpty()) {
            return completionItems;
        }
        String currentOrg = ((Module)currentModule.get()).packageInstance().descriptor().org().value();
        String currentModuleName = ((Module)currentModule.get()).descriptor().name().toString();
        String currentVersion = ((Module)currentModule.get()).packageInstance().descriptor().version().value().toString();
        CodeActionModuleId currentModuleID = CodeActionModuleId.from(currentOrg, currentModuleName, currentVersion);
        Optional project = ctx.workspace().project(ctx.filePath());
        Optional packageCompilation = ctx.workspace().waitAndGetPackageCompilation(ctx.filePath());
        if (project.isEmpty() || packageCompilation.isEmpty()) {
            return completionItems;
        }
        boolean isDefaultModule = ((Module)currentModule.get()).isDefaultModule();
        ((Project)project.get()).currentPackage().modules().forEach(module -> {
            ModuleID moduleID;
            if (module.isDefaultModule() && !isDefaultModule) {
                return;
            }
            boolean isCurrentModule = ((Project)project.get()).kind() == ProjectKind.SINGLE_FILE_PROJECT || ((Module)currentModule.get()).equals(module);
            String moduleName = module.moduleName().toString();
            String moduleHash = this.generateModuleHash(currentOrg, moduleName);
            String version = ((Module)currentModule.get()).packageInstance().descriptor().version().value().toString();
            Object object = moduleID = isCurrentModule ? currentModuleID : CodeActionModuleId.from(currentOrg, moduleName, version);
            if (processedModuleList.contains(moduleHash)) {
                return;
            }
            try {
                SemanticModel semanticModel = ((PackageCompilation)packageCompilation.get()).getSemanticModel(module.moduleId());
                semanticModel.moduleSymbols().stream().filter(ServiceTemplateGenerator.listenerPredicate()).forEach(listener -> ServiceTemplateGenerator.generateServiceSnippetMetaData(listener, moduleID).ifPresent(item -> completionItems.add(this.generateServiceSnippet((ListenerMetaData)item, ctx))));
            }
            catch (Throwable throwable) {
                LSClientLogger clientLogger = LSClientLogger.getInstance(ctx.languageServercontext());
                String msg = String.format("Operation 'txt/completion' failed for %s", moduleName);
                clientLogger.logError(LSContextOperation.TXT_COMPLETION, msg, throwable, null, new Position[]{null});
            }
        });
        List<LSPackageLoader.ModuleInfo> visibleModules = LSPackageLoader.getInstance(ctx.languageServercontext()).getAllVisiblePackages((DocumentServiceContext)ctx);
        visibleModules.forEach(moduleInfo -> {
            if (processedModuleList.contains(moduleInfo.getModuleIdentifier()) || moduleInfo.isModuleFromCurrentPackage()) {
                return;
            }
            moduleInfo.getListenerMetaData().forEach(listenerMetaData -> completionItems.add(this.generateServiceSnippet((ListenerMetaData)listenerMetaData, ctx)));
            processedModuleList.add(moduleInfo.getModuleIdentifier());
        });
        return completionItems;
    }

    private ModuleID getCurrentModuleID(CompletionContext ctx) {
        Optional currentModule = ctx.workspace().module(ctx.filePath());
        if (currentModule.isEmpty()) {
            throw new RuntimeException("Current module not found");
        }
        String currentOrg = ((Module)currentModule.get()).packageInstance().descriptor().org().value();
        String currentModuleName = ((Module)currentModule.get()).descriptor().name().toString();
        String currentVersion = ((Module)currentModule.get()).packageInstance().descriptor().version().value().toString();
        return CodeActionModuleId.from(currentOrg, currentModuleName, currentVersion);
    }

    public static Predicate<Symbol> listenerPredicate() {
        return symbol -> SymbolUtil.isListener(symbol) && symbol.kind() == SymbolKind.CLASS;
    }

    private String generateModuleHash(String orgName, String moduleName) {
        return orgName.isEmpty() ? moduleName : orgName + "/" + moduleName;
    }

    public static Optional<ListenerMetaData> generateServiceSnippetMetaData(Symbol symbol, ModuleID moduleID) {
        ObjectTypeSymbol serviceTypeSymbol;
        Optional<TypeSymbol> symbolTypeDesc = SymbolUtil.getTypeDescriptor(symbol);
        if (symbolTypeDesc.isEmpty() || !SymbolUtil.isListener(symbol) || symbol.kind() != SymbolKind.CLASS) {
            return Optional.empty();
        }
        ClassSymbol classSymbol = (ClassSymbol)CommonUtil.getRawType(symbolTypeDesc.get());
        if (classSymbol.getName().isEmpty()) {
            return Optional.empty();
        }
        MethodSymbol attachMethod = (MethodSymbol)classSymbol.methods().get("attach");
        if (attachMethod == null) {
            return Optional.empty();
        }
        Optional params = attachMethod.typeDescriptor().params();
        if (params.isEmpty() || ((List)params.get()).isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType(((ParameterSymbol)((List)params.get()).get(0)).typeDescriptor());
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            Optional<TypeSymbol> memberType = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().map(CommonUtil::getRawType).filter(member -> member.typeKind() == TypeDescKind.OBJECT).findFirst();
            if (memberType.isEmpty()) {
                return Optional.empty();
            }
            serviceTypeSymbol = (ObjectTypeSymbol)memberType.get();
        } else if (typeSymbol.typeKind() == TypeDescKind.OBJECT) {
            serviceTypeSymbol = (ObjectTypeSymbol)typeSymbol;
        } else {
            return Optional.empty();
        }
        Optional initMethod = classSymbol.initMethod();
        int snippetIndex = 2;
        String listenerInitArgs = "";
        if (initMethod.isPresent() && ((MethodSymbol)initMethod.get()).typeDescriptor().params().isPresent()) {
            ArrayList<CallSite> args = new ArrayList<CallSite>();
            List<ParameterSymbol> requiredParams = ((List)((MethodSymbol)initMethod.get()).typeDescriptor().params().get()).stream().filter(parameterSymbol -> parameterSymbol.paramKind() == ParameterKind.REQUIRED).toList();
            for (ParameterSymbol parameterSymbol2 : requiredParams) {
                args.add((CallSite)((Object)("${" + snippetIndex + ":" + DefaultValueGenerationUtil.getDefaultPlaceholderForType(parameterSymbol2.typeDescriptor()).orElse("") + "}")));
                ++snippetIndex;
            }
            listenerInitArgs = String.join((CharSequence)",", args);
        }
        String symbolName = (String)classSymbol.getName().get();
        return Optional.of(new ListenerMetaData(listenerInitArgs, new ArrayList<MethodSymbol>(serviceTypeSymbol.methods().values()), symbolName, snippetIndex, moduleID));
    }

    private LSCompletionItem generateServiceSnippet(ListenerMetaData serviceSnippet, BallerinaCompletionContext context) {
        Object filterText;
        ImportsAcceptor importsAcceptor = new ImportsAcceptor((DocumentServiceContext)context);
        String modulePrefix = ModuleUtil.getModulePrefix(importsAcceptor, this.getCurrentModuleID((CompletionContext)context), serviceSnippet.moduleID, (DocumentServiceContext)context);
        Boolean shouldImport = !importsAcceptor.getNewImports().isEmpty();
        String moduleAlias = modulePrefix.replace(":", "");
        String moduleName = ModuleUtil.escapeModuleName(serviceSnippet.moduleID.moduleName());
        Object symbolReference = !moduleAlias.isEmpty() ? modulePrefix + serviceSnippet.symbolName : serviceSnippet.symbolName;
        String listenerInitialization = "new " + (String)symbolReference + "(" + serviceSnippet.listenerInitArgs + ")";
        ArrayList<String> methodSnippets = new ArrayList<String>();
        SnippetContext snippetContext = new SnippetContext(serviceSnippet.currentSnippetIndex - 1);
        if (!serviceSnippet.unimplementedMethods.isEmpty()) {
            for (MethodSymbol methodSymbol : serviceSnippet.unimplementedMethods) {
                String functionSnippet = this.generateMethodSnippet(importsAcceptor, methodSymbol, snippetContext, context);
                methodSnippets.add(functionSnippet);
            }
        }
        String snippet = SyntaxKind.SERVICE_KEYWORD.stringValue() + " ${1} " + SyntaxKind.ON_KEYWORD.stringValue() + " " + listenerInitialization + " {" + CommonUtil.LINE_SEPARATOR + (String)(serviceSnippet.unimplementedMethods.isEmpty() ? "    ${" + snippetContext.incrementAndGetPlaceholderCount() + "}" : String.join((CharSequence)"", methodSnippets)) + CommonUtil.LINE_SEPARATOR + "}" + CommonUtil.LINE_SEPARATOR;
        String detail = "Snippet";
        String label = shouldImport != false ? "service on " + moduleName + ":" + serviceSnippet.symbolName : "service on " + (String)symbolReference;
        Object object = filterText = moduleAlias.isEmpty() ? "service" : String.join((CharSequence)"_", Arrays.asList("service", moduleName));
        if (!(shouldImport.booleanValue() || moduleAlias.equals(moduleName) || moduleAlias.isEmpty())) {
            filterText = (String)filterText + "_" + moduleAlias;
        }
        filterText = (String)filterText + "_" + serviceSnippet.symbolName;
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>(importsAcceptor.getNewImportTextEdits());
        return new StaticCompletionItem(context, ServiceTemplateCompletionItemBuilder.build(snippet, label, detail, ((String)filterText).replace(".", "_"), additionalTextEdits), StaticCompletionItem.Kind.SERVICE_TEMPLATE);
    }

    private String generateMethodSnippet(ImportsAcceptor importsAcceptor, MethodSymbol methodSymbol, SnippetContext snippetContext, BallerinaCompletionContext context) {
        Optional<String> defaultReturnValueForType;
        TypeSymbol returnTypeSymbol;
        String functionTypeDesc = FunctionGenerator.processModuleIDsInText(importsAcceptor, methodSymbol.signature(), (DocumentServiceContext)context);
        Object returnStmt = "";
        if (methodSymbol.typeDescriptor().returnTypeDescriptor().isPresent() && (returnTypeSymbol = (TypeSymbol)methodSymbol.typeDescriptor().returnTypeDescriptor().get()).typeKind() != TypeDescKind.COMPILATION_ERROR && (defaultReturnValueForType = DefaultValueGenerationUtil.getDefaultPlaceholderForType(returnTypeSymbol)).isPresent()) {
            String defaultReturnValue = defaultReturnValueForType.get();
            returnStmt = "()".equals(defaultReturnValue) ? "" : "return ${" + snippetContext.incrementAndGetPlaceholderCount() + ":" + defaultReturnValue + "};";
        }
        String paddingStr = StringUtils.repeat((String)" ", (int)4);
        StringBuilder functionSnippet = new StringBuilder();
        functionSnippet.append(CommonUtil.LINE_SEPARATOR).append(paddingStr).append(functionTypeDesc).append(" ").append("{").append(CommonUtil.LINE_SEPARATOR).append(StringUtils.repeat((String)paddingStr, (int)2)).append((String)(((String)returnStmt).isEmpty() ? "${" + snippetContext.incrementAndGetPlaceholderCount() + "}" : returnStmt)).append(CommonUtil.LINE_SEPARATOR).append(paddingStr).append("}").append(CommonUtil.LINE_SEPARATOR);
        return functionSnippet.toString();
    }

    public static class ListenerMetaData {
        private final String listenerInitArgs;
        private final List<MethodSymbol> unimplementedMethods;
        private final String symbolName;
        private final int currentSnippetIndex;
        private final ModuleID moduleID;

        ListenerMetaData(String listenerInitialization, List<MethodSymbol> unimplementedMethods, String symbolReference, int currentSnippetIndex, ModuleID moduleID) {
            this.listenerInitArgs = listenerInitialization;
            this.unimplementedMethods = unimplementedMethods;
            this.symbolName = symbolReference;
            this.currentSnippetIndex = currentSnippetIndex;
            this.moduleID = moduleID;
        }
    }
}

