/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.commons.completion.spi.BallerinaCompletionProvider;
import org.ballerinalang.langserver.completions.ProviderFactory;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.Position;

public final class CompletionUtil {
    private CompletionUtil() {
    }

    public static List<CompletionItem> getCompletionItems(BallerinaCompletionContext ctx) throws LSCompletionException {
        CompletionTriggerKind triggerKind;
        ctx.checkCancelled();
        CompletionUtil.fillTokenInfoAtCursor(ctx);
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        boolean contextSupport = Boolean.TRUE.equals(ctx.getCapabilities().getContextSupport());
        String triggerCharacter = contextSupport ? ctx.getCompletionParams().getContext().getTriggerCharacter() : "";
        CompletionTriggerKind completionTriggerKind = triggerKind = contextSupport ? ctx.getCompletionParams().getContext().getTriggerKind() : null;
        if (triggerKind == CompletionTriggerKind.TriggerCharacter && (triggerCharacter.equals(SyntaxKind.GT_TOKEN.stringValue()) && ctx.getTokenAtCursor().kind() != SyntaxKind.RIGHT_ARROW_TOKEN && ctx.getTokenAtCursor().kind() != SyntaxKind.SYNC_SEND_TOKEN || triggerCharacter.equals(SyntaxKind.BACK_SLASH_TOKEN.stringValue()) && ctx.getNodeAtCursor().kind() != SyntaxKind.RE_LITERAL_CHAR_DOT_OR_ESCAPE || triggerCharacter.equals(SyntaxKind.QUESTION_MARK_TOKEN.stringValue()) && ctx.getNodeAtCursor().kind() != SyntaxKind.RE_FLAG_EXPR) || CompletionUtil.isWithinComment(ctx)) {
            return Collections.emptyList();
        }
        List<LSCompletionItem> items = CompletionUtil.route(ctx, (Node)nodeAtCursor);
        return items.stream().map(LSCompletionItem::getCompletionItem).toList();
    }

    public static List<LSCompletionItem> route(BallerinaCompletionContext ctx, Node node) throws LSCompletionException {
        Node reference;
        ctx.checkCancelled();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node == null) {
            return completionItems;
        }
        Map<Class<?>, BallerinaCompletionProvider<Node>> providers = ProviderFactory.instance().getProviders();
        BallerinaCompletionProvider<Node> provider = null;
        for (reference = node; reference != null; reference = reference.parent()) {
            provider = providers.get(reference.getClass());
            if (provider != null && provider.onPreValidation(ctx, reference) && !ctx.getResolverChain().contains(reference)) {
                ctx.addResolver(reference);
                break;
            }
            ctx.addResolver(reference);
        }
        if (provider == null) {
            return completionItems;
        }
        return provider.getCompletions(ctx, reference);
    }

    public static void fillTokenInfoAtCursor(BallerinaCompletionContext context) {
        Optional<Token> tokenAtCursor = PositionUtil.findTokenAtPosition((DocumentServiceContext)context, context.getCursorPosition());
        Optional document = context.currentDocument();
        if (document.isEmpty() || tokenAtCursor.isEmpty()) {
            throw new RuntimeException("Could not find a valid document/token");
        }
        context.setTokenAtCursor(tokenAtCursor.get());
        TextDocument textDocument = ((Document)document.get()).textDocument();
        Position position = context.getCursorPosition();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        context.setCursorPositionInTree(txtPos);
        TextRange range = TextRange.from((int)txtPos, (int)0);
        NonTerminalNode nonTerminalNode = ((ModulePartNode)((Document)document.get()).syntaxTree().rootNode()).findNode(range);
        context.setNodeAtCursor(nonTerminalNode);
    }

    private static boolean isWithinComment(BallerinaCompletionContext ctx) {
        Iterator minutiaeIterator = Collections.emptyIterator();
        if (ctx.getCursorPositionInTree() <= ctx.getTokenAtCursor().textRange().startOffset()) {
            minutiaeIterator = ctx.getTokenAtCursor().leadingMinutiae().iterator();
        } else if (ctx.getTokenAtCursor().textRange().endOffset() <= ctx.getCursorPositionInTree()) {
            minutiaeIterator = ctx.getTokenAtCursor().trailingMinutiae().iterator();
        }
        while (minutiaeIterator.hasNext()) {
            Minutiae minutiae = (Minutiae)minutiaeIterator.next();
            if (minutiae.kind() != SyntaxKind.COMMENT_MINUTIAE || minutiae.textRange().startOffset() >= ctx.getCursorPositionInTree() || ctx.getCursorPositionInTree() > minutiae.textRange().endOffset()) continue;
            return true;
        }
        return false;
    }
}

