/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.XMLTypeSymbol;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.builder.ForeachCompletionItemBuilder;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public final class ForeachCompletionUtil {
    private static final String VAR_NAME = "item";
    private static final String VAR_NAME_RANGE_EXP = "i";
    private static final String VAR_TYPE = "var";
    private static final List<TypeDescKind> ITERABLES = Arrays.asList(TypeDescKind.STRING, TypeDescKind.ARRAY, TypeDescKind.TUPLE, TypeDescKind.MAP, TypeDescKind.RECORD, TypeDescKind.TABLE, TypeDescKind.STREAM, TypeDescKind.XML);

    private ForeachCompletionUtil() {
    }

    public static List<LSCompletionItem> getForeachCompletionItemsForIterable(BallerinaCompletionContext ctx, FieldAccessExpressionNode expr, TypeSymbol typeSymbol) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
        if (!ForeachCompletionUtil.isInBlockContext(expr) || !ITERABLES.contains(rawType.typeKind()) || expr.expression().kind() != SyntaxKind.SIMPLE_NAME_REFERENCE && expr.expression().kind() != SyntaxKind.FUNCTION_CALL && expr.expression().kind() != SyntaxKind.FIELD_ACCESS) {
            return completionItems;
        }
        if (rawType.typeKind() == TypeDescKind.STREAM && ((StreamTypeSymbol)rawType).completionValueTypeParameter().typeKind() != TypeDescKind.NIL) {
            return completionItems;
        }
        completionItems.addAll(ForeachCompletionUtil.getForEachCompletionItems(ctx, expr, typeSymbol));
        return completionItems;
    }

    private static List<LSCompletionItem> getForEachCompletionItems(BallerinaCompletionContext ctx, FieldAccessExpressionNode expr, TypeSymbol symbol) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText("");
        LineRange lineRange = expr.lineRange();
        Position start = new Position(lineRange.startLine().line(), lineRange.startLine().offset());
        Position end = new Position(lineRange.endLine().line(), lineRange.endLine().offset());
        textEdit.setRange(new Range(start, end));
        textEdits.add(textEdit);
        String symbolName = expr.expression().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE ? ((SimpleNameReferenceNode)expr.expression()).name().text() : expr.expression().toSourceCode().trim();
        completionItems.add((LSCompletionItem)new StaticCompletionItem(ctx, ForeachCompletionUtil.getIteratingCompletionItem(ctx, symbolName, symbol, textEdits), StaticCompletionItem.Kind.OTHER));
        if (CommonUtil.getRawType(symbol).typeKind() != TypeDescKind.STREAM) {
            completionItems.add((LSCompletionItem)new StaticCompletionItem(ctx, ForeachCompletionUtil.getRangeExprCompletionItem(ctx, symbolName, textEdits), StaticCompletionItem.Kind.OTHER));
        }
        return completionItems;
    }

    private static CompletionItem getIteratingCompletionItem(BallerinaCompletionContext ctx, String symbolName, TypeSymbol symbol, List<TextEdit> textEdits) {
        String detail = "foreach var item in expr";
        String label = "foreach";
        String type = ForeachCompletionUtil.getTypeOfIteratorVariable(ctx, symbol);
        StringBuilder snippet = new StringBuilder("foreach");
        snippet.append(" ").append(type).append(" ").append(NameUtil.getValidatedSymbolName((PositionedOperationContext)ctx, VAR_NAME)).append(" in ").append(symbolName).append(" ").append("{").append(CommonUtil.LINE_SEPARATOR).append("\t${1}").append(CommonUtil.LINE_SEPARATOR).append("}");
        String documentation = "foreach statement for iterable variable - " + symbolName;
        return ForeachCompletionItemBuilder.build(snippet.toString(), label, detail, documentation, textEdits);
    }

    private static CompletionItem getRangeExprCompletionItem(BallerinaCompletionContext ctx, String symbolName, List<TextEdit> textEdits) {
        String detail = "foreach int i in 0...expr";
        String label = "foreach i";
        StringBuilder snippet = new StringBuilder("foreach");
        snippet.append(" int ").append(NameUtil.getValidatedSymbolName((PositionedOperationContext)ctx, VAR_NAME_RANGE_EXP)).append(" in ").append("${1:0}").append("...").append(symbolName).append(".length() ").append("{").append(CommonUtil.LINE_SEPARATOR).append("\t${2}").append(CommonUtil.LINE_SEPARATOR).append("}");
        String documentation = "foreach i statement for iterable variable - " + symbolName;
        return ForeachCompletionItemBuilder.build(snippet.toString(), label, detail, documentation, textEdits);
    }

    public static String getTypeOfIteratorVariable(BallerinaCompletionContext ctx, TypeSymbol symbol) {
        TypeSymbol rawType = CommonUtil.getRawType(symbol);
        return switch (rawType.typeKind()) {
            case TypeDescKind.STRING -> "string:Char";
            case TypeDescKind.XML -> {
                Optional xmlTypeParam = ((XMLTypeSymbol)symbol).typeParameter();
                if (xmlTypeParam.isEmpty() || ((TypeSymbol)xmlTypeParam.get()).typeKind() == TypeDescKind.UNION && ((UnionTypeSymbol)xmlTypeParam.get()).memberTypeDescriptors().size() == 4) {
                    yield NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, rawType);
                }
                yield NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, (TypeSymbol)xmlTypeParam.get());
            }
            case TypeDescKind.ARRAY -> NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, ((ArrayTypeSymbol)rawType).memberTypeDescriptor());
            case TypeDescKind.TUPLE -> {
                ArrayList typesSet = new ArrayList(((TupleTypeSymbol)rawType).memberTypeDescriptors().stream().map(tSymbol -> NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, tSymbol)).collect(Collectors.toSet()));
                if (typesSet.size() == 1) {
                    yield (String)typesSet.get(0);
                }
                yield VAR_TYPE;
            }
            case TypeDescKind.MAP -> NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, ((MapTypeSymbol)rawType).typeParam());
            case TypeDescKind.TABLE -> NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, ((TableTypeSymbol)rawType).rowTypeParameter());
            case TypeDescKind.STREAM -> NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, ((StreamTypeSymbol)rawType).typeParameter());
            default -> VAR_TYPE;
        };
    }

    private static boolean isInBlockContext(FieldAccessExpressionNode node) {
        return node.parent() instanceof ExpressionStatementNode && (node.parent().parent() instanceof FunctionBodyNode || node.parent().parent() instanceof BlockStatementNode);
    }
}

