/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.WorkerSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.NamedWorkerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Optional;

public class ReturnTypeFinder
extends NodeTransformer<Optional<TypeSymbol>> {
    private final SemanticModel semanticModel;

    public ReturnTypeFinder(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public Optional<TypeSymbol> getTypeSymbol(Node node) {
        if (node.kind() == SyntaxKind.LIST) {
            return Optional.empty();
        }
        return (Optional)node.apply((NodeTransformer)this);
    }

    public Optional<TypeSymbol> transform(FunctionDefinitionNode functionDefinitionNode) {
        return this.semanticModel.symbol((Node)functionDefinitionNode.functionName()).flatMap(symbol -> ((FunctionSymbol)symbol).typeDescriptor().returnTypeDescriptor());
    }

    public Optional<TypeSymbol> transform(NamedWorkerDeclarationNode namedWorkerDeclarationNode) {
        Optional symbol = this.semanticModel.symbol((Node)namedWorkerDeclarationNode);
        if (symbol.isPresent()) {
            WorkerSymbol workerSymbol = (WorkerSymbol)symbol.get();
            return Optional.of(workerSymbol.returnType());
        }
        return Optional.empty();
    }

    public Optional<TypeSymbol> transform(ExplicitAnonymousFunctionExpressionNode explicitAnonymousFunctionExpressionNode) {
        Optional type = this.semanticModel.typeOf((Node)explicitAnonymousFunctionExpressionNode);
        if (type.isPresent() && ((TypeSymbol)type.get()).typeKind() == TypeDescKind.FUNCTION) {
            FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)type.get();
            return functionTypeSymbol.returnTypeDescriptor();
        }
        return Optional.empty();
    }

    protected Optional<TypeSymbol> transformSyntaxNode(Node node) {
        if (node.parent() != null) {
            return (Optional)node.parent().apply((NodeTransformer)this);
        }
        return Optional.empty();
    }
}

