/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.util;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.builder.TypeGuardCompletionItemBuilder;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public final class TypeGuardCompletionUtil {
    private static final String TYPE_GUARD_LABEL = "typeguard";

    private TypeGuardCompletionUtil() {
    }

    public static LSCompletionItem getTypeGuardDestructedItem(UnionTypeSymbol symbol, BallerinaCompletionContext ctx, FieldAccessExpressionNode expr) {
        String symbolName = expr.expression().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE ? ((SimpleNameReferenceNode)expr.expression()).name().text() : expr.expression().toSourceCode().trim();
        ArrayList members = new ArrayList(symbol.memberTypeDescriptors());
        String detail = "Destructure the variable " + symbolName + " with typeguard";
        Object snippet = "";
        snippet = (String)snippet + IntStream.range(0, members.size() - 1).mapToObj(value -> {
            TypeSymbol bType = (TypeSymbol)members.get(value);
            String placeHolder = "\t${" + (value + 1) + "}";
            return "if " + symbolName + " is " + NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, bType) + " {" + CommonUtil.LINE_SEPARATOR + placeHolder + CommonUtil.LINE_SEPARATOR + "}";
        }).collect(Collectors.joining(" else ")) + " else {" + CommonUtil.LINE_SEPARATOR + "\t${" + members.size() + "}" + CommonUtil.LINE_SEPARATOR + "}";
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText("");
        Position start = new Position(expr.lineRange().startLine().line(), expr.lineRange().startLine().offset());
        Position end = new Position(expr.lineRange().endLine().line(), expr.lineRange().endLine().offset());
        textEdit.setRange(new Range(start, end));
        textEdits.add(textEdit);
        CompletionItem completionItem = TypeGuardCompletionItemBuilder.build((String)snippet, TYPE_GUARD_LABEL, detail, textEdits);
        return new StaticCompletionItem(ctx, completionItem, StaticCompletionItem.Kind.OTHER);
    }

    public static List<LSCompletionItem> getTypeGuardDestructedItems(BallerinaCompletionContext ctx, FieldAccessExpressionNode expr, TypeSymbol typeSymbol) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (TypeGuardCompletionUtil.isInBlockContext(expr) && typeSymbol.typeKind() == TypeDescKind.UNION && (expr.expression().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE || expr.expression().kind() == SyntaxKind.FUNCTION_CALL || expr.expression().kind() == SyntaxKind.FIELD_ACCESS)) {
            completionItems.add(TypeGuardCompletionUtil.getTypeGuardDestructedItem((UnionTypeSymbol)typeSymbol, ctx, expr));
        }
        return completionItems;
    }

    public static boolean isInBlockContext(FieldAccessExpressionNode node) {
        return node.parent() instanceof ExpressionStatementNode && (node.parent().parent() instanceof FunctionBodyNode || node.parent().parent() instanceof BlockStatementNode);
    }
}

