/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.config;

import org.ballerinalang.langserver.config.CodeLensConfig;

public class LSClientConfig {
    private final String home;
    private final boolean allowExperimental;
    private final boolean debugLog;
    private final CodeLensConfig codeLens;
    private final boolean traceLog;
    private final boolean enableFileWatcher;
    private final boolean enableTelemetry;
    private final boolean enableSemanticHighlighting;

    protected LSClientConfig() {
        this.home = "";
        String balDebugLog = System.getenv("BAL_DEBUG_LOG");
        String balTraceLog = System.getenv("BAL_TRACE_LOG");
        String balExperimental = System.getenv("BAL_EXPERIMENTAL");
        String balFileWatcher = System.getenv("BAL_FILE_WATCHER");
        String balTelemetry = System.getenv("BAL_TELEMETRY");
        this.allowExperimental = Boolean.parseBoolean(balExperimental);
        this.debugLog = Boolean.parseBoolean(balDebugLog);
        this.traceLog = Boolean.parseBoolean(balTraceLog);
        this.codeLens = new CodeLensConfig();
        this.enableFileWatcher = balFileWatcher == null || Boolean.parseBoolean(balFileWatcher);
        this.enableTelemetry = balTelemetry == null || Boolean.parseBoolean(balTelemetry);
        this.enableSemanticHighlighting = true;
    }

    public static LSClientConfig getDefault() {
        return new LSClientConfig();
    }

    public String getHome() {
        return this.home;
    }

    public boolean isAllowExperimental() {
        return this.allowExperimental;
    }

    public boolean isDebugLogEnabled() {
        return this.debugLog;
    }

    public CodeLensConfig getCodeLens() {
        return this.codeLens;
    }

    public boolean isTraceLogEnabled() {
        return this.traceLog;
    }

    public boolean isEnableFileWatcher() {
        return this.enableFileWatcher;
    }

    public boolean isEnableTelemetry() {
        return this.enableTelemetry;
    }

    public boolean isEnableSemanticHighlighting() {
        return this.enableSemanticHighlighting;
    }
}

