/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.config.ClientConfigListener;
import org.ballerinalang.langserver.config.LSClientConfig;

public class LSClientConfigHolder {
    private final Gson gson = new Gson();
    private static final LanguageServerContext.Key<LSClientConfigHolder> CLIENT_CONFIG_HOLDER_KEY = new LanguageServerContext.Key();
    private final List<ClientConfigListener> listeners = new ArrayList<ClientConfigListener>();
    private LSClientConfig clientConfig = LSClientConfig.getDefault();
    private JsonElement clientConfigJson = this.gson.toJsonTree((Object)this.clientConfig).getAsJsonObject();

    private LSClientConfigHolder(LanguageServerContext serverContext) {
        serverContext.put(CLIENT_CONFIG_HOLDER_KEY, (Object)this);
    }

    public static LSClientConfigHolder getInstance(LanguageServerContext serverContext) {
        LSClientConfigHolder lsClientConfigHolder = (LSClientConfigHolder)serverContext.get(CLIENT_CONFIG_HOLDER_KEY);
        if (lsClientConfigHolder == null) {
            lsClientConfigHolder = new LSClientConfigHolder(serverContext);
        }
        return lsClientConfigHolder;
    }

    public LSClientConfig getConfig() {
        return this.clientConfig;
    }

    public <T> T getConfigAs(Class<T> type) {
        return (T)this.gson.fromJson(this.clientConfigJson, type);
    }

    public void register(ClientConfigListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(ClientConfigListener listener) {
        this.listeners.remove(listener);
    }

    public void updateConfig(JsonElement newClientConfigJson) {
        LSClientConfig newClientConfig = (LSClientConfig)this.gson.fromJson(newClientConfigJson, LSClientConfig.class);
        LSClientConfig oldClientConfig = this.clientConfig;
        JsonElement oldClientConfigJson = this.clientConfigJson;
        this.clientConfig = newClientConfig;
        this.clientConfigJson = newClientConfigJson;
        this.listeners.forEach(listener -> listener.didChangeConfig(oldClientConfig, newClientConfig));
        this.listeners.forEach(listener -> listener.didChangeJson(oldClientConfigJson, newClientConfigJson));
    }
}

