/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.DiagnosticState;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.tools.text.LinePosition;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class AbstractDocumentServiceContext
implements DocumentServiceContext {
    private final LSOperation operation;
    private final Path filePath;
    private final String fileUri;
    private final WorkspaceManager workspaceManager;
    private Map<ImportDeclarationNode, ModuleSymbol> currentDocImportsMap;
    private Module currentModule;
    private SemanticModel currentSemanticModel;
    private Document currentDocument;
    private final LanguageServerContext languageServerContext;
    private CancelChecker cancelChecker;
    private static final boolean ON_DEBUG_MODE = System.getenv("BAL_JAVA_DEBUG") != null;

    AbstractDocumentServiceContext(LSOperation operation, String fileUri, WorkspaceManager wsManager, LanguageServerContext serverContext) {
        this.operation = operation;
        this.fileUri = fileUri;
        this.workspaceManager = wsManager;
        this.languageServerContext = serverContext;
        Optional<Path> optFilePath = PathUtil.getPathFromURI(this.fileUri);
        if (optFilePath.isEmpty()) {
            throw new RuntimeException("Invalid file uri: " + this.fileUri);
        }
        this.filePath = optFilePath.get();
    }

    AbstractDocumentServiceContext(LSOperation operation, String fileUri, WorkspaceManager wsManager, LanguageServerContext serverContext, CancelChecker cancelChecker) {
        this(operation, fileUri, wsManager, serverContext);
        if (!ON_DEBUG_MODE) {
            this.cancelChecker = cancelChecker;
        }
    }

    public String fileUri() {
        return this.fileUri;
    }

    @Nonnull
    public Path filePath() {
        return this.filePath;
    }

    public LSOperation operation() {
        return this.operation;
    }

    public List<Symbol> visibleSymbols(Position position) {
        Optional semanticModel = this.cancelChecker == null ? this.workspaceManager.semanticModel(this.filePath) : this.workspaceManager.semanticModel(this.filePath, this.cancelChecker);
        Optional srcFile = this.workspaceManager.document(this.filePath);
        if (semanticModel.isEmpty() || srcFile.isEmpty()) {
            return Collections.emptyList();
        }
        this.checkCancelled();
        return ((SemanticModel)semanticModel.get()).visibleSymbols((Document)srcFile.get(), LinePosition.from((int)position.getLine(), (int)position.getCharacter()), new DiagnosticState[]{DiagnosticState.VALID, DiagnosticState.REDECLARED});
    }

    public WorkspaceManager workspace() {
        return this.workspaceManager;
    }

    public List<ImportDeclarationNode> currentDocImports() {
        Optional document = this.workspace().document(this.filePath);
        if (document.isEmpty()) {
            throw new RuntimeException("Cannot find a valid document");
        }
        return ((ModulePartNode)((Document)document.get()).syntaxTree().rootNode()).imports().stream().toList();
    }

    public Map<ImportDeclarationNode, ModuleSymbol> currentDocImportsMap() {
        if (this.currentDocImportsMap == null) {
            this.currentDocImportsMap = new LinkedHashMap<ImportDeclarationNode, ModuleSymbol>();
            Optional document = this.workspace().document(this.filePath);
            if (document.isEmpty()) {
                throw new RuntimeException("Cannot find a valid document");
            }
            Optional<SemanticModel> semanticModel = this.currentSemanticModel();
            if (semanticModel.isEmpty()) {
                throw new RuntimeException("Semantic Model Cannot be Empty");
            }
            ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
            for (ImportDeclarationNode importDeclaration : modulePartNode.imports()) {
                Optional symbol = semanticModel.get().symbol((Node)importDeclaration);
                if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.MODULE) continue;
                this.currentDocImportsMap.put(importDeclaration, (ModuleSymbol)symbol.get());
            }
        }
        return this.currentDocImportsMap;
    }

    public Optional<Document> currentDocument() {
        if (this.currentDocument == null) {
            Optional document = this.cancelChecker == null ? this.workspace().document(this.filePath()) : this.workspace().document(this.filePath(), this.cancelChecker);
            document.ifPresent(value -> {
                this.currentDocument = value;
            });
        }
        return Optional.ofNullable(this.currentDocument);
    }

    public Optional<Module> currentModule() {
        if (this.currentModule == null) {
            Optional module = this.cancelChecker == null ? this.workspaceManager.module(this.filePath) : this.workspaceManager.module(this.filePath, this.cancelChecker);
            module.ifPresent(value -> {
                this.currentModule = value;
            });
        }
        return Optional.ofNullable(this.currentModule);
    }

    public Optional<SemanticModel> currentSemanticModel() {
        if (this.currentSemanticModel == null) {
            Optional semanticModel = this.cancelChecker == null ? this.workspaceManager.semanticModel(this.filePath) : this.workspaceManager.semanticModel(this.filePath, this.cancelChecker);
            semanticModel.ifPresent(value -> {
                this.currentSemanticModel = value;
            });
        }
        return Optional.ofNullable(this.currentSemanticModel);
    }

    public Optional<SyntaxTree> currentSyntaxTree() {
        if (this.cancelChecker == null) {
            return this.workspaceManager.syntaxTree(this.filePath);
        }
        return this.workspaceManager.syntaxTree(this.filePath, this.cancelChecker);
    }

    public LanguageServerContext languageServercontext() {
        return this.languageServerContext;
    }

    public boolean isCancelled() {
        return this.cancelChecker != null && this.cancelChecker.isCanceled();
    }

    public void checkCancelled() {
        if (this.cancelChecker != null) {
            this.cancelChecker.checkCanceled();
        }
    }

    public Optional<CancelChecker> getCancelChecker() {
        return Optional.ofNullable(this.cancelChecker);
    }

    protected static abstract class AbstractContextBuilder<T extends AbstractContextBuilder<T>> {
        protected final LSOperation operation;
        protected final LanguageServerContext serverContext;
        protected String fileUri;
        protected WorkspaceManager wsManager;
        protected CancelChecker cancelChecker;

        public AbstractContextBuilder(LSOperation lsOperation, LanguageServerContext serverContext) {
            this.operation = lsOperation;
            this.serverContext = serverContext;
        }

        public T withFileUri(String fileUri) {
            this.fileUri = fileUri;
            return this.self();
        }

        public T withWorkspaceManager(WorkspaceManager workspaceManager) {
            this.wsManager = workspaceManager;
            return this.self();
        }

        public T withCancelChecker(CancelChecker cancelChecker) {
            this.cancelChecker = cancelChecker;
            return this.self();
        }

        public DocumentServiceContext build() {
            return new AbstractDocumentServiceContext(this.operation, this.fileUri, this.wsManager, this.serverContext, this.cancelChecker);
        }

        public abstract T self();
    }
}

