/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import java.util.Optional;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.commons.DocumentSymbolContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.contexts.AbstractDocumentServiceContext;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.SymbolTagSupportCapabilities;

public class DocumentSymbolContextImpl
extends AbstractDocumentServiceContext
implements DocumentSymbolContext {
    private Boolean labelSupport;
    private SymbolTagSupportCapabilities supportedTags;
    private Boolean hierarchicalDocumentSymbolSupport;
    private final LSClientCapabilities clientCapabilities;
    private final DocumentSymbolParams params;
    private final DocumentSymbolCapabilities documentSymbolClientCapabilities;
    boolean deprecatedTagSupport;

    DocumentSymbolContextImpl(LSOperation operation, String fileUri, WorkspaceManager wsManager, LanguageServerContext serverContext, DocumentSymbolParams params, LSClientCapabilities clientCapabilities) {
        super(operation, fileUri, wsManager, serverContext);
        this.clientCapabilities = clientCapabilities;
        this.documentSymbolClientCapabilities = clientCapabilities.getTextDocCapabilities().getDocumentSymbol();
        if (this.documentSymbolClientCapabilities != null) {
            this.hierarchicalDocumentSymbolSupport = this.getDocumentSymbolClientCapabilities().getHierarchicalDocumentSymbolSupport();
            this.supportedTags = this.getDocumentSymbolClientCapabilities().getTagSupport();
            this.labelSupport = this.getDocumentSymbolClientCapabilities().getLabelSupport();
        }
        this.deprecatedTagSupport = this.supportedTags != null && this.supportedTags.getValueSet().contains(SymbolTag.Deprecated);
        this.params = params;
    }

    public DocumentSymbolParams getParams() {
        return this.params;
    }

    public LSClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    public DocumentSymbolCapabilities getDocumentSymbolClientCapabilities() {
        return this.documentSymbolClientCapabilities;
    }

    public boolean getHierarchicalDocumentSymbolSupport() {
        return Boolean.TRUE.equals(this.hierarchicalDocumentSymbolSupport);
    }

    public boolean getLabelSupport() {
        return Boolean.TRUE.equals(this.labelSupport);
    }

    public Optional<SymbolTagSupportCapabilities> supportedTags() {
        return Optional.ofNullable(this.supportedTags);
    }

    public boolean deprecatedSupport() {
        return Boolean.TRUE.equals(this.deprecatedTagSupport);
    }

    protected static class DocumentSymbolContextBuilder
    extends AbstractDocumentServiceContext.AbstractContextBuilder<DocumentSymbolContextBuilder> {
        private final DocumentSymbolParams params;
        private final LSClientCapabilities clientCapabilities;

        public DocumentSymbolContextBuilder(DocumentSymbolParams params, LanguageServerContext serverContext, LSClientCapabilities clientCapabilities) {
            super(LSContextOperation.TXT_DOC_SYMBOL, serverContext);
            this.clientCapabilities = clientCapabilities;
            this.params = params;
        }

        public DocumentSymbolContext build() {
            return new DocumentSymbolContextImpl(this.operation, this.fileUri, this.wsManager, this.serverContext, this.params, this.clientCapabilities);
        }

        @Override
        public DocumentSymbolContextBuilder self() {
            return this;
        }
    }
}

