/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.contexts;

import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.RenameContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.contexts.PositionedOperationContextImpl;
import org.ballerinalang.langserver.contexts.ReferencesContextImpl;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class RenameContextImpl
extends ReferencesContextImpl
implements RenameContext {
    private final LSClientCapabilities clientCapabilities;
    private final RenameParams params;
    private final Boolean honorsChangeAnnotations;

    RenameContextImpl(LSOperation operation, String fileUri, WorkspaceManager wsManager, Position cursorPos, LanguageServerContext serverContext, RenameParams params, LSClientCapabilities clientCapabilities, CancelChecker cancelChecker) {
        super(operation, fileUri, wsManager, cursorPos, serverContext, cancelChecker);
        this.clientCapabilities = clientCapabilities;
        this.params = params;
        this.honorsChangeAnnotations = clientCapabilities.getTextDocCapabilities().getRename() != null && Boolean.TRUE.equals(clientCapabilities.getTextDocCapabilities().getRename().getHonorsChangeAnnotations());
    }

    public boolean getHonorsChangeAnnotations() {
        return Boolean.TRUE.equals(this.honorsChangeAnnotations);
    }

    public RenameParams getParams() {
        return this.params;
    }

    public LSClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    protected static class RenameContextBuilder
    extends PositionedOperationContextImpl.PositionedOperationContextBuilder<RenameContext> {
        private final RenameParams params;
        private final LSClientCapabilities clientCapabilities;

        public RenameContextBuilder(LanguageServerContext serverContext, RenameParams params, LSClientCapabilities clientCapabilities) {
            super(LSContextOperation.TXT_RENAME, serverContext);
            this.clientCapabilities = clientCapabilities;
            this.params = params;
        }

        @Override
        public RenameContext build() {
            return new RenameContextImpl(this.operation, this.fileUri, this.wsManager, this.position, this.serverContext, this.params, this.clientCapabilities, this.cancelChecker);
        }

        @Override
        public RenameContextBuilder self() {
            return this;
        }
    }
}

