/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.documentsymbol;

import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.DocumentSymbolContext;
import org.ballerinalang.langserver.documentsymbol.DocumentSymbolResolver;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class DocumentSymbolUtil {
    private DocumentSymbolUtil() {
    }

    public static List<Either<SymbolInformation, DocumentSymbol>> documentSymbols(DocumentSymbolContext context) {
        ArrayList<Either<SymbolInformation, DocumentSymbol>> symbols = new ArrayList<Either<SymbolInformation, DocumentSymbol>>();
        Optional syntaxTree = context.currentSyntaxTree();
        if (syntaxTree.isEmpty()) {
            return symbols;
        }
        Node rootNode = ((SyntaxTree)syntaxTree.get()).rootNode();
        DocumentSymbolResolver symbolResolver = new DocumentSymbolResolver(context);
        rootNode.apply((NodeTransformer)symbolResolver);
        symbolResolver.getDocumentSymbolStore().forEach(symbol -> symbols.add(Either.forRight((Object)symbol)));
        return symbols;
    }

    public static Range generateNodeRange(Node node) {
        Position startPosition = new Position(node.lineRange().startLine().line(), node.lineRange().startLine().offset());
        Position endPosition = new Position(node.lineRange().endLine().line(), node.lineRange().endLine().offset());
        return new Range(startPosition, endPosition);
    }

    public static boolean isDeprecated(MetadataNode metadata) {
        return !metadata.annotations().stream().filter(annotation -> annotation.annotReference().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && ((SimpleNameReferenceNode)annotation.annotReference()).name().text().equals("deprecated")).toList().isEmpty();
    }
}

