/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.eventsync.subscribers;

import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.eventsync.EventKind;
import org.ballerinalang.langserver.commons.eventsync.spi.EventSubscriber;
import org.ballerinalang.langserver.diagnostic.DiagnosticsHelper;

public class PublishDiagnosticSubscriber
implements EventSubscriber {
    public static final String NAME = "Publish diagnostic subscriber";

    public EventKind eventKind() {
        return EventKind.PROJECT_UPDATE;
    }

    public void onEvent(ExtendedLanguageClient client, DocumentServiceContext context, LanguageServerContext languageServerContext) {
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)context.languageServercontext().get(LSClientCapabilities.class);
        if (!lsClientCapabilities.getInitializationOptions().isEnableLightWeightMode()) {
            DiagnosticsHelper diagnosticsHelper = DiagnosticsHelper.getInstance(languageServerContext);
            diagnosticsHelper.compileAndSendDiagnostics(client, context);
        }
    }

    public String getName() {
        return NAME;
    }
}

