/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.eventsync.subscribers;

import io.ballerina.compiler.api.SemanticModel;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.command.executors.PullModuleExecutor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.eventsync.EventKind;
import org.ballerinalang.langserver.commons.eventsync.spi.EventSubscriber;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ShowMessageRequestParams;

public class ResolveModulesSubscriber
implements EventSubscriber {
    public static final String NAME = "Resolve modules subscriber";
    private static final String PULL_MODULES_ACTION = "Pull Modules";

    public EventKind eventKind() {
        return EventKind.PROJECT_UPDATE;
    }

    public void onEvent(ExtendedLanguageClient client, DocumentServiceContext context, LanguageServerContext serverContext) {
        LSOperation operation = context.operation();
        if (!operation.equals((Object)LSContextOperation.LOAD_PROJECT) && !operation.equals((Object)LSContextOperation.TXT_DID_OPEN)) {
            return;
        }
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return;
        }
        if (!CommonUtil.hasUnresolvedModules((SemanticModel)semanticModel.get())) {
            return;
        }
        ShowMessageRequestParams showMessageRequestParams = new ShowMessageRequestParams();
        showMessageRequestParams.setType(MessageType.Warning);
        showMessageRequestParams.setMessage("There are unresolved modules in your project. Some of the features may not work as expected.");
        showMessageRequestParams.setActions(List.of(new MessageActionItem(PULL_MODULES_ACTION)));
        client.showMessageRequest(showMessageRequestParams).thenAccept(action -> {
            if (action != null && PULL_MODULES_ACTION.equals(action.getTitle())) {
                PullModuleExecutor.resolveModules(context.fileUri(), client, context.workspace(), context.languageServercontext());
            }
        });
    }

    public String getName() {
        return NAME;
    }
}

