/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.connector;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConnectorNodeVisitor
extends NodeVisitor {
    private final String name;
    private final List<ClassDefinitionNode> connectors;
    private final Map<String, TypeDefinitionNode> records;
    private final Map<String, ClassDefinitionNode> objectTypes;
    private final SemanticModel semanticModel;

    public ConnectorNodeVisitor(String name, SemanticModel semanticModel) {
        this.name = name;
        this.semanticModel = semanticModel;
        this.connectors = new ArrayList<ClassDefinitionNode>();
        this.records = new HashMap<String, TypeDefinitionNode>();
        this.objectTypes = new HashMap<String, ClassDefinitionNode>();
    }

    public String getName() {
        return this.name;
    }

    public List<ClassDefinitionNode> getConnectors() {
        return this.connectors;
    }

    public Map<String, TypeDefinitionNode> getRecords() {
        return this.records;
    }

    public Map<String, ClassDefinitionNode> getObjectTypes() {
        return this.objectTypes;
    }

    public void visit(ModulePartNode modulePartNode) {
        for (int i = 0; i < modulePartNode.members().size(); ++i) {
            ((ModuleMemberDeclarationNode)modulePartNode.members().get(i)).accept((NodeVisitor)this);
        }
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        Optional symbol = this.semanticModel.symbol((Node)classDefinitionNode);
        if (symbol.isEmpty()) {
            return;
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol.get();
        boolean isClient = classSymbol.qualifiers().contains(Qualifier.CLIENT);
        if (isClient) {
            this.connectors.add(classDefinitionNode);
        } else {
            String typeName = String.format("%s:%s", ((ModuleSymbol)((Symbol)symbol.get()).getModule().get()).id().toString(), ((Symbol)symbol.get()).getName().get());
            this.objectTypes.put(typeName, classDefinitionNode);
        }
    }

    public void visit(TypeDefinitionNode typeDefinitionNode) {
        Optional typeSymbol = this.semanticModel.symbol((Node)typeDefinitionNode);
        if (typeSymbol.isPresent() && typeSymbol.get() instanceof TypeDefinitionSymbol) {
            TypeSymbol rawType = this.getRawType(((TypeDefinitionSymbol)typeSymbol.get()).typeDescriptor());
            String typeName = String.format("%s:%s", ((ModuleSymbol)((Symbol)typeSymbol.get()).getModule().get()).id().toString(), ((Symbol)typeSymbol.get()).getName().get());
            if (rawType.typeKind() == TypeDescKind.RECORD || rawType.typeKind() == TypeDescKind.UNION || rawType.typeKind() == TypeDescKind.ERROR) {
                this.records.put(typeName, typeDefinitionNode);
            }
        }
    }

    private TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        return typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE ? ((TypeReferenceTypeSymbol)typeDescriptor).typeDescriptor() : typeDescriptor;
    }
}

