/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import org.ballerinalang.diagramutil.DiagramUtil;
import org.ballerinalang.diagramutil.JSONGenerationException;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.extensions.ballerina.document.ASTModification;
import org.ballerinalang.langserver.extensions.ballerina.document.visitor.UnusedSymbolsVisitor;

public final class BallerinaTreeModifyUtil {
    private static final String DELETE = "delete";
    private static final Map<String, String> typeMapping = new HashMap<String, String>(){
        {
            this.put("DELETE", "");
            this.put("INSERT", "$STATEMENT");
        }
    };

    private BallerinaTreeModifyUtil() {
    }

    public static String resolveMapping(String type, JsonObject config) {
        if (type == null || type.isEmpty()) {
            return null;
        }
        String mapping = typeMapping.get(type.toUpperCase(Locale.getDefault()));
        if (mapping == null) {
            return null;
        }
        for (Map.Entry entry : config.entrySet()) {
            String value;
            String key = ((String)entry.getKey()).toUpperCase(Locale.getDefault());
            if (key.equals("PARAMS")) {
                JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < array.size(); ++i) {
                    sb.append(array.get(i).getAsString());
                    if (i == array.size() - 1) continue;
                    sb.append(", ");
                }
                value = sb.toString();
            } else {
                value = ((JsonElement)entry.getValue()).getAsString();
            }
            mapping = mapping.replaceAll("\\$" + key, Matcher.quoteReplacement(value));
        }
        return mapping;
    }

    public static String getImport(JsonObject config) {
        JsonElement value = config.get("TYPE");
        if (value != null) {
            return value.getAsString();
        }
        return null;
    }

    public static List<TextEdit> getUnusedImportRanges(Map<String, ImportDeclarationNode> unusedImports, TextDocument textDocument) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        unusedImports.forEach((key, value) -> {
            LinePosition startLinePos = LinePosition.from((int)value.lineRange().startLine().line(), (int)value.lineRange().startLine().offset());
            LinePosition endLinePos = LinePosition.from((int)value.lineRange().endLine().line(), (int)value.lineRange().endLine().offset());
            int startOffset = textDocument.textPositionFrom(startLinePos);
            int endOffset = textDocument.textPositionFrom(endLinePos);
            edits.add(TextEdit.from((TextRange)TextRange.from((int)startOffset, (int)(endOffset - startOffset)), (String)""));
        });
        return edits;
    }

    public static TextEdit createTextEdit(TextDocument oldTextDocument, JsonObject config, String type, int startLine, int startColumn, int endLine, int endColumn) {
        String mainStartMapping = BallerinaTreeModifyUtil.resolveMapping(type, config == null ? new JsonObject() : config);
        int theStartOffset = oldTextDocument.textPositionFrom(LinePosition.from((int)(startLine - 1), (int)(startColumn - 1)));
        int theEndOffset = oldTextDocument.textPositionFrom(LinePosition.from((int)(endLine - 1), (int)(endColumn - 1)));
        return TextEdit.from((TextRange)TextRange.from((int)theStartOffset, (int)(theEndOffset - theStartOffset)), (String)mainStartMapping);
    }

    public static JsonElement modifyTree(ASTModification[] astModifications, Path compilationPath, WorkspaceManager workspaceManager) throws Exception {
        Optional oldSyntaxTree = workspaceManager.syntaxTree(compilationPath);
        if (oldSyntaxTree.isEmpty()) {
            throw new JSONGenerationException("Modification error");
        }
        HashMap<LineRange, ASTModification> deleteRange = new HashMap<LineRange, ASTModification>();
        for (ASTModification astModification : astModifications) {
            if (!DELETE.equalsIgnoreCase(astModification.getType())) continue;
            LinePosition startLine = LinePosition.from((int)astModification.getStartLine(), (int)astModification.getStartColumn());
            LinePosition endLine = LinePosition.from((int)astModification.getEndLine(), (int)astModification.getEndColumn());
            LineRange lineRange = LineRange.from(null, (LinePosition)startLine, (LinePosition)endLine);
            deleteRange.put(lineRange, astModification);
        }
        Optional semanticModel = workspaceManager.semanticModel(compilationPath);
        Optional srcFile = workspaceManager.document(compilationPath);
        if (semanticModel.isEmpty() || srcFile.isEmpty()) {
            throw new JSONGenerationException("Modification error");
        }
        UnusedSymbolsVisitor unusedSymbolsVisitor = new UnusedSymbolsVisitor((Document)srcFile.get(), (SemanticModel)semanticModel.get(), deleteRange);
        unusedSymbolsVisitor.visit((ModulePartNode)((SyntaxTree)oldSyntaxTree.get()).rootNode());
        TextDocument oldTextDocument = ((SyntaxTree)oldSyntaxTree.get()).textDocument();
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        List<ASTModification> importModifications = Arrays.stream(astModifications).filter(ASTModification::isImport).toList();
        for (ASTModification importModification : importModifications) {
            TextEdit edit;
            if (BallerinaTreeModifyUtil.importExist(unusedSymbolsVisitor, importModification) || (edit = BallerinaTreeModifyUtil.constructEdit(unusedSymbolsVisitor, oldTextDocument, importModification)) == null) continue;
            edits.add(edit);
        }
        edits.addAll(BallerinaTreeModifyUtil.getUnusedImportRanges(unusedSymbolsVisitor.getUnusedImports(), oldTextDocument));
        for (ASTModification astModification : astModifications) {
            TextEdit edit;
            if (astModification.isImport() || (edit = BallerinaTreeModifyUtil.constructEdit(unusedSymbolsVisitor, oldTextDocument, astModification)) == null) continue;
            edits.add(edit);
        }
        TextDocumentChange textDocumentChange = TextDocumentChange.from((TextEdit[])edits.toArray(new TextEdit[0]));
        TextDocument newTextDocument = oldTextDocument.apply(textDocumentChange);
        SyntaxTree newSyntaxTree = SyntaxTree.from((TextDocument)newTextDocument);
        newSyntaxTree = Formatter.format((SyntaxTree)newSyntaxTree);
        SemanticModel newSemanticModel = BallerinaTreeModifyUtil.updateWorkspaceDocument(compilationPath, newSyntaxTree.toSourceCode(), workspaceManager);
        Optional formattedSrcFile = workspaceManager.document(compilationPath);
        if (formattedSrcFile.isEmpty()) {
            throw new JSONGenerationException("Modification error");
        }
        JsonElement syntaxTreeJson = DiagramUtil.getSyntaxTreeJSON((Document)((Document)formattedSrcFile.get()), (SemanticModel)newSemanticModel);
        JsonObject jsonTreeWithSource = new JsonObject();
        jsonTreeWithSource.add("tree", syntaxTreeJson);
        jsonTreeWithSource.addProperty("source", ((Document)formattedSrcFile.get()).syntaxTree().toSourceCode());
        return jsonTreeWithSource;
    }

    private static SemanticModel updateWorkspaceDocument(Path compilationPath, String content, WorkspaceManager workspaceManager) throws WorkspaceDocumentException {
        Optional document = workspaceManager.document(compilationPath);
        if (document.isEmpty()) {
            throw new WorkspaceDocumentException("Document does not exist in path: " + compilationPath.toString());
        }
        Document updatedDoc = ((Document)document.get()).modify().withContent(content).apply();
        PackageCompilation packageCompilation = updatedDoc.module().packageInstance().getCompilation();
        return packageCompilation.getSemanticModel(updatedDoc.module().moduleId());
    }

    private static boolean importExist(UnusedSymbolsVisitor unusedSymbolsVisitor, ASTModification astModification) {
        String importValue = BallerinaTreeModifyUtil.getImport(astModification.getConfig());
        return importValue != null && (unusedSymbolsVisitor.getUsedImports().containsKey(importValue) || unusedSymbolsVisitor.getUnusedImports().containsKey(importValue));
    }

    private static TextEdit constructEdit(UnusedSymbolsVisitor unusedSymbolsVisitor, TextDocument oldTextDocument, ASTModification astModification) {
        String editText = BallerinaTreeModifyUtil.resolveMapping(astModification.getType(), astModification.getConfig() == null ? new JsonObject() : astModification.getConfig());
        if (editText == null) {
            return null;
        }
        boolean doEdit = false;
        if (DELETE.equals(astModification.getType())) {
            if (unusedSymbolsVisitor.toBeDeletedRanges().contains(astModification)) {
                doEdit = true;
            }
        } else {
            doEdit = true;
        }
        if (doEdit) {
            TextRange range = BallerinaTreeModifyUtil.getRange(astModification, oldTextDocument);
            if (range == null) {
                return null;
            }
            return TextEdit.from((TextRange)range, (String)editText);
        }
        return null;
    }

    public static TextRange getRange(ASTModification modification, TextDocument oldTextDocument) {
        LinePosition startLinePos = LinePosition.from((int)modification.getStartLine(), (int)modification.getStartColumn());
        LinePosition endLinePos = LinePosition.from((int)modification.getEndLine(), (int)modification.getEndColumn());
        int startOffset = BallerinaTreeModifyUtil.calculateOffset(oldTextDocument, startLinePos);
        int endOffset = BallerinaTreeModifyUtil.calculateOffset(oldTextDocument, endLinePos);
        if (startOffset < 0 || endOffset < 0) {
            return null;
        }
        return TextRange.from((int)startOffset, (int)(endOffset - startOffset));
    }

    private static int calculateOffset(TextDocument document, LinePosition linePos) {
        try {
            return document.textPositionFrom(linePos);
        }
        catch (IndexOutOfBoundsException e) {
            if (linePos.line() == document.textLines().size()) {
                return document.toCharArray().length;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

