/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.document.visitor;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.extensions.ballerina.document.ASTModification;

public class UnusedSymbolsVisitor
extends NodeVisitor {
    private final Map<String, ImportDeclarationNode> unusedImports = new HashMap<String, ImportDeclarationNode>();
    private final Map<String, ImportDeclarationNode> usedImports = new HashMap<String, ImportDeclarationNode>();
    private final Map<LineRange, ASTModification> deleteRanges;
    private final Map<LineRange, ASTModification> toBeDeletedRanges = new HashMap<LineRange, ASTModification>();
    private final SemanticModel semanticModel;
    private final Document srcFile;

    public UnusedSymbolsVisitor(Document srcFile, SemanticModel semanticModel, Map<LineRange, ASTModification> deleteRanges) {
        this.semanticModel = semanticModel;
        this.deleteRanges = deleteRanges;
        this.toBeDeletedRanges.putAll(deleteRanges);
        this.srcFile = srcFile;
    }

    private void addUnusedImportNode(ImportDeclarationNode importDeclarationNode) {
        this.unusedImports.put(this.getImportModuleName(importDeclarationNode.orgName().isPresent() ? (ImportOrgNameNode)importDeclarationNode.orgName().get() : null, (SeparatedNodeList<IdentifierToken>)importDeclarationNode.moduleName()), importDeclarationNode);
    }

    private String getImportModuleName(ImportOrgNameNode importOrgNameNode, SeparatedNodeList<IdentifierToken> importModuleName) {
        StringBuilder moduleName = new StringBuilder();
        if (importOrgNameNode != null) {
            String importOrgName = importOrgNameNode.orgName().text();
            moduleName.append(importOrgName);
            moduleName.append("/");
        }
        for (int i = 0; i < importModuleName.size(); ++i) {
            IdentifierToken identifierToken = (IdentifierToken)importModuleName.get(i);
            moduleName.append(identifierToken.text());
            if (i == importModuleName.size() - 1) continue;
            moduleName.append(".");
        }
        return moduleName.toString();
    }

    private LineRange getDeleteRange(LineRange lineRange) {
        if (lineRange != null) {
            for (LineRange aPosition : this.deleteRanges.keySet()) {
                if (aPosition.startLine().line() > lineRange.startLine().line() || aPosition.startLine().offset() > lineRange.startLine().offset() || (aPosition.endLine().line() != lineRange.endLine().line() || aPosition.endLine().offset() < lineRange.endLine().offset()) && aPosition.endLine().line() <= lineRange.endLine().line()) continue;
                return aPosition;
            }
        }
        return null;
    }

    private boolean isWithinLineRange(LineRange containerRange, LineRange childRange) {
        return containerRange.startLine().line() <= childRange.startLine().line() && containerRange.endLine().line() >= childRange.endLine().line() && containerRange.startLine().offset() <= childRange.startLine().offset() && containerRange.endLine().offset() >= childRange.endLine().offset();
    }

    private void moveUnusedtoUsedImport(LineRange lineRange, ImportDeclarationNode importDeclarationNode) {
        Optional symbol = this.semanticModel.symbol((Node)importDeclarationNode);
        if (symbol.isEmpty()) {
            return;
        }
        List locations = this.semanticModel.references((Symbol)symbol.get());
        boolean availableOutSideDeleteRange = false;
        for (Location location : locations) {
            if (this.isWithinLineRange(importDeclarationNode.lineRange(), location.lineRange())) {
                if (locations.size() != 1) continue;
                availableOutSideDeleteRange = true;
                continue;
            }
            LineRange deleteRange = this.getDeleteRange(location.lineRange());
            if (deleteRange != null) continue;
            availableOutSideDeleteRange = true;
        }
        if (importDeclarationNode.prefix().isPresent() && "_".equals(((ImportPrefixNode)importDeclarationNode.prefix().get()).prefix().text())) {
            availableOutSideDeleteRange = true;
        }
        if (availableOutSideDeleteRange) {
            this.unusedImports.remove(this.getImportModuleName(importDeclarationNode.orgName().isPresent() ? (ImportOrgNameNode)importDeclarationNode.orgName().get() : null, (SeparatedNodeList<IdentifierToken>)importDeclarationNode.moduleName()));
            this.usedImports.put(this.getImportModuleName(importDeclarationNode.orgName().isPresent() ? (ImportOrgNameNode)importDeclarationNode.orgName().get() : null, (SeparatedNodeList<IdentifierToken>)importDeclarationNode.moduleName()), importDeclarationNode);
        }
    }

    private void decideVariablesToBeDeleted(LineRange lineRange) {
        LineRange deleteRange = this.getDeleteRange(lineRange);
        if (deleteRange == null) {
            return;
        }
        List locations = this.semanticModel.references(this.srcFile, lineRange.startLine());
        for (Location location : locations) {
            LineRange range;
            if (this.isWithinLineRange(deleteRange, location.lineRange()) || (range = this.getDeleteRange(location.lineRange())) != null) continue;
            this.toBeDeletedRanges.remove(deleteRange);
        }
    }

    public Collection<ASTModification> toBeDeletedRanges() {
        return this.toBeDeletedRanges.values();
    }

    public Map<String, ImportDeclarationNode> getUnusedImports() {
        return this.unusedImports;
    }

    public Map<String, ImportDeclarationNode> getUsedImports() {
        return this.usedImports;
    }

    public void visit(ModulePartNode modulePartNode) {
        if (!modulePartNode.imports().isEmpty()) {
            modulePartNode.imports().forEach(importDeclarationNode -> importDeclarationNode.accept((NodeVisitor)this));
        }
        if (!modulePartNode.members().isEmpty()) {
            modulePartNode.members().forEach(moduleMemberDeclarationNode -> moduleMemberDeclarationNode.accept((NodeVisitor)this));
        }
    }

    public void visit(ImportDeclarationNode importDeclarationNode) {
        this.addUnusedImportNode(importDeclarationNode);
        int moduleNamePosition = importDeclarationNode.moduleName().size() - 1;
        if (!importDeclarationNode.moduleName().isEmpty() && importDeclarationNode.moduleName().get(moduleNamePosition) != null) {
            Optional prefix = importDeclarationNode.prefix();
            if (prefix.isPresent()) {
                this.moveUnusedtoUsedImport(((ImportPrefixNode)prefix.get()).prefix().lineRange(), importDeclarationNode);
            } else {
                this.moveUnusedtoUsedImport(((IdentifierToken)importDeclarationNode.moduleName().get(moduleNamePosition)).lineRange(), importDeclarationNode);
            }
        }
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        if (variableDeclarationNode.typedBindingPattern() != null && variableDeclarationNode.typedBindingPattern().bindingPattern() != null && variableDeclarationNode.typedBindingPattern().bindingPattern().lineRange() != null) {
            this.decideVariablesToBeDeleted(variableDeclarationNode.typedBindingPattern().bindingPattern().lineRange());
        }
    }

    public void visit(AnnotationNode annotationNode) {
        super.visit(annotationNode);
        Optional annotationNodeSymbol = this.semanticModel.symbol((Node)annotationNode);
        if (annotationNodeSymbol.isEmpty()) {
            return;
        }
        Optional moduleSymbol = ((Symbol)annotationNodeSymbol.get()).getModule();
        if (moduleSymbol.isPresent()) {
            ModuleID moduleID = ((ModuleSymbol)moduleSymbol.get()).id();
            String importKey = String.format("%s/%s", moduleID.orgName(), moduleID.moduleName());
            if (this.unusedImports.containsKey(importKey)) {
                this.usedImports.put(importKey, this.unusedImports.get(importKey));
                this.unusedImports.remove(importKey);
            }
        }
    }
}

