/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.extensions.ballerina.example;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleCategory;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleListRequest;
import org.ballerinalang.langserver.extensions.ballerina.example.BallerinaExampleListResponse;
import org.ballerinalang.langserver.extensions.ballerina.example.ExampleContext;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="ballerinaExample")
public class BallerinaExampleService
implements ExtendedLanguageServerService {
    private static final String BBE_DEF_JSON = "index.json";
    private static final String EXAMPLES_DIR = "examples";
    private static final TypeToken<List<BallerinaExampleCategory>> EXAMPLE_CATEGORY_TYPE = new TypeToken<List<BallerinaExampleCategory>>(){};
    private LSClientLogger clientLogger;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager, LanguageServerContext serverContext) {
        this.clientLogger = LSClientLogger.getInstance(serverContext);
    }

    @JsonRequest
    public CompletableFuture<BallerinaExampleListResponse> list(BallerinaExampleListRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaExampleListResponse response = new BallerinaExampleListResponse();
            Gson gson = new Gson();
            Path bbeJSONPath = Path.of(CommonUtil.BALLERINA_HOME, new String[0]).resolve(EXAMPLES_DIR).resolve(BBE_DEF_JSON);
            try {
                InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(bbeJSONPath.toFile()), StandardCharsets.UTF_8);
                JsonReader jsonReader = new JsonReader((Reader)fileReader);
                List data = (List)gson.fromJson(jsonReader, EXAMPLE_CATEGORY_TYPE);
                response.setSamples(data);
            }
            catch (Throwable e) {
                String msg = "Operation 'ballerinaExample/list' failed!";
                this.clientLogger.logError(ExampleContext.EXAMPLE_LIST, msg, e, new TextDocumentIdentifier(bbeJSONPath.toString()), new Position[]{null});
                response.setSamples(new ArrayList<BallerinaExampleCategory>());
            }
            return response;
        });
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }
}

