/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.hover;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifiable;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.MatchedExpressionNodeResolver;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.HoverContext;
import org.ballerinalang.langserver.hover.APIDocReference;
import org.ballerinalang.langserver.hover.HoverObjectResolver;
import org.ballerinalang.langserver.hover.HoverSymbolResolver;
import org.ballerinalang.langserver.util.MarkupUtils;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.util.RepoUtils;

public final class HoverUtil {
    private HoverUtil() {
    }

    public static Hover getHover(HoverContext context) {
        Optional srcFile = context.currentDocument();
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty() || srcFile.isEmpty()) {
            return HoverUtil.getHoverObject("");
        }
        HoverUtil.fillTokenInfoAtCursor(context);
        Position cursorPosition = context.getCursorPosition();
        LinePosition linePosition = LinePosition.from((int)cursorPosition.getLine(), (int)cursorPosition.getCharacter());
        context.checkCancelled();
        Optional<Symbol> symbolAtCursor = HoverUtil.getSymbolAtCursor(context, (SemanticModel)semanticModel.get(), (Document)srcFile.get(), linePosition);
        context.checkCancelled();
        HoverObjectResolver provider = new HoverObjectResolver(context);
        Hover hoverObj = HoverUtil.getHoverObject("");
        if (symbolAtCursor.isEmpty()) {
            MatchedExpressionNodeResolver expressionResolver;
            Optional<ExpressionNode> expr;
            Range nodeRange = new Range(context.getCursorPosition(), context.getCursorPosition());
            NonTerminalNode nodeAtCursor = CommonUtil.findNode(nodeRange, ((Document)srcFile.get()).syntaxTree());
            if (nodeAtCursor != null && (expr = (expressionResolver = new MatchedExpressionNodeResolver((Node)nodeAtCursor)).findExpression((Node)nodeAtCursor)).isPresent()) {
                hoverObj = provider.getHoverObjectForExpression((Node)expr.get());
            }
        } else {
            hoverObj = provider.getHoverObjectForSymbol(symbolAtCursor.get());
        }
        if (hoverObj.getContents().isRight()) {
            MarkupContent markupContent = (MarkupContent)hoverObj.getContents().getRight();
            String content = markupContent.getValue();
            HoverSymbolResolver symbolResolver = new HoverSymbolResolver(context, (SemanticModel)semanticModel.get());
            Optional symbol = (Optional)context.getNodeAtCursor().apply((NodeTransformer)symbolResolver);
            if (symbol == null || symbol.isEmpty() || !symbolResolver.isSymbolReferable()) {
                return hoverObj;
            }
            Optional<ModuleID> moduleID = symbol.flatMap(Symbol::getModule).map(ModuleSymbol::id);
            if (moduleID.isEmpty() || ((Symbol)symbol.get()).getName().isEmpty()) {
                return hoverObj;
            }
            ModuleID modID = moduleID.get();
            String version = CommonUtil.isLangLibOrLangTest(modID) ? RepoUtils.getBallerinaVersion() : modID.version();
            String url = APIDocReference.from(modID.orgName(), modID.moduleName(), version, (String)((Symbol)symbol.get()).getName().get());
            markupContent.setValue((String)(content.isEmpty() ? "" : content + MarkupUtils.getHorizontalSeparator()) + "[View API Docs](" + url + ")");
            hoverObj.setContents(markupContent);
        }
        return hoverObj;
    }

    private static Optional<Symbol> getSymbolAtCursor(HoverContext context, SemanticModel semanticModel, Document srcFile, LinePosition linePosition) {
        NonTerminalNode cursor = context.getNodeAtCursor();
        SyntaxKind kind = cursor.kind();
        if (kind == SyntaxKind.LIST || kind == SyntaxKind.PARENTHESIZED_ARG_LIST || kind == SyntaxKind.SIMPLE_NAME_REFERENCE && cursor.parent().kind() == SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION) {
            return semanticModel.symbol((Node)cursor.parent());
        }
        return semanticModel.symbol(srcFile, linePosition);
    }

    static Hover getHoverObject() {
        return HoverUtil.getHoverObject("");
    }

    static Hover getHoverObject(String content) {
        Hover hover = new Hover();
        MarkupContent hoverMarkupContent = new MarkupContent();
        hoverMarkupContent.setKind("markdown");
        hoverMarkupContent.setValue(content);
        hover.setContents(hoverMarkupContent);
        return hover;
    }

    static Boolean withValidAccessModifiers(Symbol symbol, Package currentPackage, ModuleId currentModule, HoverContext context) {
        Optional project = context.workspace().project(context.filePath());
        Optional typeSymbolModule = symbol.getModule();
        if (project.isEmpty() || typeSymbolModule.isEmpty()) {
            return false;
        }
        boolean isResource = false;
        boolean isPrivate = false;
        boolean isPublic = false;
        boolean isRemote = false;
        if (symbol instanceof Qualifiable) {
            Qualifiable qSymbol = (Qualifiable)symbol;
            isPrivate = qSymbol.qualifiers().contains(Qualifier.PRIVATE);
            isPublic = qSymbol.qualifiers().contains(Qualifier.PUBLIC);
            isResource = qSymbol.qualifiers().contains(Qualifier.RESOURCE);
            isRemote = qSymbol.qualifiers().contains(Qualifier.REMOTE);
        }
        if (isResource || isRemote || isPublic) {
            return true;
        }
        ModuleID objModuleId = ((ModuleSymbol)typeSymbolModule.get()).id();
        return !isPrivate && objModuleId.moduleName().equals(currentModule.moduleName()) && objModuleId.orgName().equals(currentPackage.packageOrg().value());
    }

    public static Hover getDescriptionOnlyHoverObject(Symbol symbol) {
        Documentable documentable;
        if (!(symbol instanceof Documentable) || (documentable = (Documentable)symbol).documentation().isEmpty()) {
            return HoverUtil.getHoverObject("");
        }
        return HoverUtil.getDescriptionOnlyHoverObject((Documentation)documentable.documentation().get());
    }

    public static Hover getDescriptionOnlyHoverObject(Documentation documentation) {
        String description = "";
        if (documentation.description().isPresent()) {
            description = (String)documentation.description().get();
        }
        return HoverUtil.getHoverObject(description);
    }

    public static void fillTokenInfoAtCursor(HoverContext context) {
        Optional<Token> tokenAtCursor = PositionUtil.findTokenAtPosition((DocumentServiceContext)context, context.getCursorPosition());
        Optional document = context.currentDocument();
        if (document.isEmpty() || tokenAtCursor.isEmpty()) {
            throw new RuntimeException("Could not find a valid document/token");
        }
        context.setTokenAtCursor(tokenAtCursor.get());
        TextDocument textDocument = ((Document)document.get()).textDocument();
        Position position = context.getCursorPosition();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        context.setCursorPositionInTree(txtPos);
        TextRange range = TextRange.from((int)txtPos, (int)0);
        NonTerminalNode nonTerminalNode = ((ModulePartNode)((Document)document.get()).syntaxTree().rootNode()).findNode(range);
        context.setNodeAtCursor(nonTerminalNode);
    }
}

