/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.signature;

import io.ballerina.compiler.api.symbols.ParameterSymbol;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.SignatureContext;

public class Parameter {
    private final boolean isRestArg;
    private final boolean isOptional;
    private final ParameterSymbol parameterSymbol;
    private final SignatureContext signatureContext;

    public Parameter(ParameterSymbol parameterSymbol, boolean isOptional, boolean isRestArg, SignatureContext signatureContext) {
        this.parameterSymbol = parameterSymbol;
        this.isOptional = isOptional;
        this.isRestArg = isRestArg;
        this.signatureContext = signatureContext;
    }

    public Optional<String> getName() {
        return this.parameterSymbol.getName().isPresent() && this.isOptional ? Optional.of((String)this.parameterSymbol.getName().get() + "?") : this.parameterSymbol.getName();
    }

    public String getType() {
        Object type = NameUtil.getModifiedTypeName((DocumentServiceContext)this.signatureContext, this.parameterSymbol.typeDescriptor());
        if (this.isRestArg && !((String)type).isEmpty()) {
            if (((String)type).endsWith("[]")) {
                type = ((String)type).substring(0, ((String)type).length() - 2);
            }
            type = (String)type + "...";
        }
        return type;
    }

    public boolean isRestArg() {
        return this.isRestArg;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public ParameterSymbol getParameterSymbol() {
        return this.parameterSymbol;
    }

    public SignatureContext getSignatureContext() {
        return this.signatureContext;
    }
}

