/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.signature;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.NamedPathSegment;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.SignatureContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.signature.SignatureInfoModelBuilder;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.wso2.ballerinalang.compiler.util.Names;

public final class SignatureHelpUtil {
    private SignatureHelpUtil() {
    }

    public static SignatureHelp getSignatureHelp(SignatureContext context) {
        SignatureHelpUtil.fillTokenInfoAtCursor(context);
        Optional sNode = context.getNodeAtCursor();
        context.checkCancelled();
        if (sNode.isEmpty()) {
            return null;
        }
        SyntaxKind sKind = ((NonTerminalNode)sNode.get()).kind();
        NonTerminalNode evalNode = (NonTerminalNode)sNode.get();
        while (evalNode != null && sKind != SyntaxKind.FUNCTION_CALL && sKind != SyntaxKind.METHOD_CALL && sKind != SyntaxKind.REMOTE_METHOD_CALL_ACTION && sKind != SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION && sKind != SyntaxKind.IMPLICIT_NEW_EXPRESSION && sKind != SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            sKind = (evalNode = evalNode.parent()) != null ? evalNode.kind() : null;
        }
        if (evalNode == null) {
            return null;
        }
        int activeParamIndex = 0;
        switch (sKind) {
            case IMPLICIT_NEW_EXPRESSION: {
                Optional implicitArgList = ((ImplicitNewExpressionNode)evalNode).parenthesizedArgList();
                if (!implicitArgList.isPresent()) break;
                activeParamIndex = SignatureHelpUtil.getActiveParamIndex(context, ((ParenthesizedArgList)implicitArgList.get()).children());
                break;
            }
            case EXPLICIT_NEW_EXPRESSION: {
                activeParamIndex = SignatureHelpUtil.getActiveParamIndex(context, ((ExplicitNewExpressionNode)evalNode).parenthesizedArgList().children());
                break;
            }
            case CLIENT_RESOURCE_ACCESS_ACTION: {
                Optional parenthesizedArgList = ((ClientResourceAccessActionNode)evalNode).arguments();
                if (parenthesizedArgList.isEmpty()) break;
                activeParamIndex = SignatureHelpUtil.getActiveParamIndex(context, ((ParenthesizedArgList)parenthesizedArgList.get()).children());
                break;
            }
            case REMOTE_METHOD_CALL_ACTION: {
                Node child;
                int childPosition;
                SeparatedNodeList arguments = ((RemoteMethodCallActionNode)evalNode).arguments();
                int cursorPosition = context.getCursorPositionInTree();
                Iterator iterator = arguments.iterator();
                while (iterator.hasNext() && cursorPosition > (childPosition = (child = (Node)iterator.next()).textRange().endOffset())) {
                    ++activeParamIndex;
                }
                break;
            }
            default: {
                activeParamIndex = SignatureHelpUtil.getActiveParamIndex(context, evalNode.children());
            }
        }
        List<SignatureInformation> signatureInformation = SignatureHelpUtil.getSignatureInformation(context);
        ArrayList<SignatureInformation> signatures = new ArrayList<SignatureInformation>(signatureInformation);
        SignatureHelp signatureHelp = new SignatureHelp();
        signatureHelp.setActiveParameter(Integer.valueOf(activeParamIndex));
        signatureHelp.setActiveSignature(Integer.valueOf(0));
        signatureHelp.setSignatures(signatures);
        return signatureHelp;
    }

    private static int getActiveParamIndex(SignatureContext context, ChildNodeList childrenInParen) {
        int activeParamIndex = 0;
        int cursorPosition = context.getCursorPositionInTree();
        if (childrenInParen != null) {
            Node child;
            int childPosition;
            Iterator iterator = childrenInParen.iterator();
            while (iterator.hasNext() && cursorPosition >= (childPosition = (child = (Node)iterator.next()).textRange().endOffset())) {
                if (child.kind() != SyntaxKind.COMMA_TOKEN) continue;
                ++activeParamIndex;
            }
        }
        return activeParamIndex;
    }

    private static List<SignatureInformation> getSignatureInformation(SignatureContext context) {
        Optional<? extends Symbol> invokableSymbol = SignatureHelpUtil.getFunctionSymbol(context);
        if (invokableSymbol.isEmpty()) {
            return Collections.emptyList();
        }
        return new SignatureInfoModelBuilder(invokableSymbol.get(), context).build();
    }

    private static void fillTokenInfoAtCursor(SignatureContext context) {
        NonTerminalNode nonTerminalNode;
        Optional document = context.currentDocument();
        if (document.isEmpty()) {
            return;
        }
        TextDocument textDocument = ((Document)document.get()).textDocument();
        Position position = context.getCursorPosition();
        int txtPos = textDocument.textPositionFrom(LinePosition.from((int)position.getLine(), (int)position.getCharacter()));
        context.setCursorPositionInTree(txtPos);
        TextRange range = TextRange.from((int)txtPos, (int)0);
        for (nonTerminalNode = ((ModulePartNode)((Document)document.get()).syntaxTree().rootNode()).findNode(range); nonTerminalNode != null && (!SignatureHelpUtil.withinTextRange(txtPos, nonTerminalNode) || nonTerminalNode.kind() != SyntaxKind.FUNCTION_CALL && nonTerminalNode.kind() != SyntaxKind.METHOD_CALL && nonTerminalNode.kind() != SyntaxKind.REMOTE_METHOD_CALL_ACTION && nonTerminalNode.kind() != SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION && nonTerminalNode.kind() != SyntaxKind.IMPLICIT_NEW_EXPRESSION) && nonTerminalNode.kind() != SyntaxKind.EXPLICIT_NEW_EXPRESSION; nonTerminalNode = nonTerminalNode.parent()) {
        }
        context.setNodeAtCursor(nonTerminalNode);
    }

    private static boolean withinTextRange(int position, @Nonnull NonTerminalNode node) {
        TextRange rangeWithMinutiae = node.textRangeWithMinutiae();
        TextRange textRange = node.textRange();
        TextRange leadingMinutiaeRange = TextRange.from((int)rangeWithMinutiae.startOffset(), (int)(textRange.startOffset() - rangeWithMinutiae.startOffset()));
        return leadingMinutiaeRange.endOffset() <= position;
    }

    public static Optional<? extends Symbol> getFunctionSymbol(SignatureContext context) {
        if (context.getNodeAtCursor().isEmpty()) {
            return Optional.empty();
        }
        NonTerminalNode nodeAtCursor = (NonTerminalNode)context.getNodeAtCursor().get();
        if (nodeAtCursor.kind() == SyntaxKind.FUNCTION_CALL) {
            return SignatureHelpUtil.getFunctionSymbol((FunctionCallExpressionNode)nodeAtCursor, context);
        }
        return SignatureHelpUtil.getFunctionSymbol((Node)nodeAtCursor, context);
    }

    private static Optional<? extends Symbol> getFunctionSymbol(FunctionCallExpressionNode node, SignatureContext context) {
        List<Symbol> filteredContent;
        NameReferenceNode nameReferenceNode = node.functionName();
        Predicate<Symbol> symbolPredicate = symbol -> symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.VARIABLE || symbol.kind() == SymbolKind.PARAMETER;
        if (nameReferenceNode.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nameReferenceNode;
            String funcName = qNameRef.identifier().text();
            filteredContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, symbolPredicate.and(symbol -> symbol.getName().orElse("").equals(funcName)));
        } else {
            String funcName = ((SimpleNameReferenceNode)nameReferenceNode).name().text();
            List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
            filteredContent = visibleSymbols.stream().filter(symbolPredicate.and(symbol -> symbol.getName().isPresent() && ((String)symbol.getName().get()).equals(funcName))).toList();
        }
        return filteredContent.stream().findAny();
    }

    private static Optional<? extends Symbol> getFunctionSymbol(Node nodeAtCursor, SignatureContext context) {
        String methodName;
        Optional<Object> typeDesc;
        if (nodeAtCursor.kind() == SyntaxKind.METHOD_CALL) {
            MethodCallExpressionNode methodCall = (MethodCallExpressionNode)nodeAtCursor;
            typeDesc = SignatureHelpUtil.getTypeDesc(context, methodCall.expression());
            methodName = ((SimpleNameReferenceNode)methodCall.methodName()).name().text();
        } else if (nodeAtCursor.kind() == SyntaxKind.REMOTE_METHOD_CALL_ACTION) {
            RemoteMethodCallActionNode remoteMethodCall = (RemoteMethodCallActionNode)nodeAtCursor;
            typeDesc = SignatureHelpUtil.getTypeDesc(context, remoteMethodCall.expression());
            methodName = remoteMethodCall.methodName().name().text();
        } else if (nodeAtCursor.kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION || nodeAtCursor.kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            typeDesc = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf(nodeAtCursor)).flatMap(typeSymbol -> Optional.of(CommonUtil.getRawType(typeSymbol))).stream().findFirst();
            methodName = Names.USER_DEFINED_INIT_SUFFIX.getValue();
        } else {
            if (nodeAtCursor.kind() == SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION) {
                ClientResourceAccessActionNode clientResourceAccess = (ClientResourceAccessActionNode)nodeAtCursor;
                Optional<? extends TypeSymbol> typeDesc2 = SignatureHelpUtil.getTypeDesc(context, clientResourceAccess.expression());
                if (typeDesc2.isEmpty()) {
                    return Optional.empty();
                }
                return SignatureHelpUtil.getFunctionSymbolsForTypeDesc(typeDesc2.get()).stream().filter(SignatureHelpUtil.resourceMethodFilter(clientResourceAccess, context)).findAny();
            }
            return Optional.empty();
        }
        if (typeDesc.isEmpty()) {
            return Optional.empty();
        }
        return SignatureHelpUtil.getFunctionSymbolsForTypeDesc((TypeSymbol)typeDesc.get()).stream().filter(functionSymbol -> functionSymbol.getName().orElse("").equals(methodName)).findAny();
    }

    private static Optional<? extends TypeSymbol> getTypeDesc(SignatureContext ctx, ExpressionNode expr) {
        return switch (expr.kind()) {
            case SyntaxKind.SIMPLE_NAME_REFERENCE -> SignatureHelpUtil.getTypeDescForNameRef(ctx, (NameReferenceNode)((SimpleNameReferenceNode)expr));
            case SyntaxKind.FUNCTION_CALL -> SignatureHelpUtil.getTypeDescForFunctionCall(ctx, (FunctionCallExpressionNode)expr);
            case SyntaxKind.METHOD_CALL -> SignatureHelpUtil.getTypeDescForMethodCall(ctx, (MethodCallExpressionNode)expr);
            case SyntaxKind.FIELD_ACCESS -> SignatureHelpUtil.getTypeDescForFieldAccess(ctx, (FieldAccessExpressionNode)expr);
            default -> Optional.empty();
        };
    }

    private static Optional<? extends TypeSymbol> getTypeDescForFieldAccess(SignatureContext context, FieldAccessExpressionNode node) {
        String fieldName = ((SimpleNameReferenceNode)node.fieldName()).name().text();
        ExpressionNode expressionNode = node.expression();
        Optional<? extends TypeSymbol> typeDescriptor = SignatureHelpUtil.getTypeDesc(context, expressionNode);
        if (typeDescriptor.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol rawType = CommonUtil.getRawType(typeDescriptor.get());
        return switch (rawType.typeKind()) {
            case TypeDescKind.OBJECT -> {
                ObjectFieldSymbol objField = (ObjectFieldSymbol)((ObjectTypeSymbol)rawType).fieldDescriptors().get(fieldName);
                if (objField != null) {
                    yield Optional.of(objField.typeDescriptor());
                }
                yield Optional.empty();
            }
            case TypeDescKind.RECORD -> {
                RecordFieldSymbol recField = (RecordFieldSymbol)((RecordTypeSymbol)rawType).fieldDescriptors().get(fieldName);
                if (recField != null) {
                    yield Optional.of(recField.typeDescriptor());
                }
                yield Optional.empty();
            }
            default -> Optional.empty();
        };
    }

    private static Optional<? extends TypeSymbol> getTypeDescForNameRef(SignatureContext context, NameReferenceNode referenceNode) {
        if (referenceNode.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return Optional.empty();
        }
        String name = ((SimpleNameReferenceNode)referenceNode).name().text();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        Optional<Symbol> symbolRef = visibleSymbols.stream().filter(symbol -> Objects.equals(symbol.getName().orElse(null), name)).findFirst();
        if (symbolRef.isEmpty()) {
            return Optional.empty();
        }
        return SymbolUtil.getTypeDescriptor(symbolRef.get());
    }

    private static Optional<? extends TypeSymbol> getTypeDescForFunctionCall(SignatureContext context, FunctionCallExpressionNode expr) {
        String fName = ((SimpleNameReferenceNode)expr.functionName()).name().text();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        Optional<FunctionSymbol> symbolRef = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.FUNCTION && ((String)symbol.getName().get()).equals(fName)).map(symbol -> (FunctionSymbol)symbol).findFirst();
        if (symbolRef.isEmpty()) {
            return Optional.empty();
        }
        return symbolRef.get().typeDescriptor().returnTypeDescriptor();
    }

    private static Optional<? extends TypeSymbol> getTypeDescForMethodCall(SignatureContext context, MethodCallExpressionNode node) {
        Optional<FunctionSymbol> filteredMethod;
        String methodName = ((SimpleNameReferenceNode)node.methodName()).name().text();
        Optional<? extends TypeSymbol> fieldTypeDesc = SignatureHelpUtil.getTypeDesc(context, node.expression());
        if (fieldTypeDesc.isEmpty()) {
            return Optional.empty();
        }
        List visibleMethods = fieldTypeDesc.get().langLibMethods();
        if (CommonUtil.getRawType(fieldTypeDesc.get()).typeKind() == TypeDescKind.OBJECT) {
            visibleMethods.addAll(((ObjectTypeSymbol)CommonUtil.getRawType(fieldTypeDesc.get())).methods().values());
        }
        if ((filteredMethod = visibleMethods.stream().filter(methodSymbol -> Objects.equals(methodSymbol.getName().orElse(null), methodName)).findFirst()).isEmpty()) {
            return Optional.empty();
        }
        return filteredMethod.get().typeDescriptor().returnTypeDescriptor();
    }

    private static List<FunctionSymbol> getFunctionSymbolsForTypeDesc(TypeSymbol typeDescriptor) {
        ArrayList<FunctionSymbol> functionSymbols = new ArrayList<FunctionSymbol>();
        TypeSymbol rawType = CommonUtil.getRawType(typeDescriptor);
        if (rawType.typeKind() == TypeDescKind.OBJECT) {
            ObjectTypeSymbol objTypeDesc = (ObjectTypeSymbol)rawType;
            functionSymbols.addAll(objTypeDesc.methods().values());
        }
        if (rawType.kind() == SymbolKind.CLASS && ((ClassSymbol)rawType).initMethod().isPresent()) {
            functionSymbols.add((FunctionSymbol)((ClassSymbol)rawType).initMethod().get());
        }
        if (rawType.typeKind() == TypeDescKind.UNION) {
            ((UnionTypeSymbol)rawType).memberTypeDescriptors().stream().filter(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.OBJECT).findFirst().ifPresent(objectMember -> functionSymbols.addAll(SignatureHelpUtil.getFunctionSymbolsForTypeDesc(objectMember)));
        }
        functionSymbols.addAll(typeDescriptor.langLibMethods());
        return functionSymbols;
    }

    private static Predicate<FunctionSymbol> resourceMethodFilter(ClientResourceAccessActionNode resourceNode, SignatureContext context) {
        return symbol -> {
            List<Object> segments;
            if (symbol.kind() != SymbolKind.RESOURCE_METHOD) {
                return false;
            }
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)symbol;
            ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
            String resourceMethodName = resourceMethodSymbol.getName().orElse("");
            if (resourceMethodName.isEmpty()) {
                return false;
            }
            String clientResourceAccessMethodName = resourceNode.methodName().flatMap(simpleNameReferenceNode -> Optional.of(simpleNameReferenceNode.name().text())).orElse("");
            if (!(resourceMethodName.equals(clientResourceAccessMethodName) || clientResourceAccessMethodName.isEmpty() && "get".equals(resourceMethodName))) {
                return false;
            }
            List<Node> resourcePathSegments = resourceNode.resourceAccessPath().stream().filter(segmentNode -> !segmentNode.isMissing()).toList();
            if (resourcePath.kind() == ResourcePath.Kind.PATH_SEGMENT_LIST) {
                segments = ((PathSegmentList)resourcePath).list();
            } else if (resourcePath.kind() == ResourcePath.Kind.PATH_REST_PARAM) {
                PathParameterSymbol parameterSymbol = ((PathRestParam)resourcePath).parameter();
                segments = List.of(parameterSymbol);
            } else {
                segments = new ArrayList();
            }
            Optional<PathSegment> pathRestParam = segments.stream().filter(pathSegment -> pathSegment.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER).findFirst();
            if (segments.size() < resourcePathSegments.size() && pathRestParam.isEmpty()) {
                return false;
            }
            for (int i = 0; i < resourcePathSegments.size(); ++i) {
                PathSegment segment;
                Node evalNode = resourcePathSegments.get(i);
                if (i > segments.size() - 1) {
                    if (pathRestParam.isEmpty()) {
                        return false;
                    }
                    segment = pathRestParam.get();
                } else {
                    segment = (PathSegment)segments.get(i);
                }
                if (evalNode.kind() == SyntaxKind.IDENTIFIER_TOKEN && segment.pathSegmentKind() == PathSegment.Kind.NAMED_SEGMENT) {
                    String expectedPath;
                    String currentPath = ((IdentifierToken)evalNode).text().strip();
                    if (currentPath.equals(expectedPath = ((NamedPathSegment)segment).name())) continue;
                    return false;
                }
                if (segment.pathSegmentKind() == PathSegment.Kind.PATH_PARAMETER || segment.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER) {
                    TypeSymbol typeSymbol = ((PathParameterSymbol)segment).typeDescriptor();
                    if (evalNode.kind() == SyntaxKind.COMPUTED_RESOURCE_ACCESS_SEGMENT) {
                        Optional semanticModel = context.currentSemanticModel();
                        if (semanticModel.isEmpty()) {
                            return false;
                        }
                        Optional exprType = ((SemanticModel)semanticModel.get()).typeOf((Node)((ComputedResourceAccessSegmentNode)evalNode).expression());
                        if (!exprType.isEmpty() && ((TypeSymbol)exprType.get()).subtypeOf(typeSymbol)) continue;
                        return false;
                    }
                    if (evalNode.kind() == SyntaxKind.IDENTIFIER_TOKEN && typeSymbol.typeKind() == TypeDescKind.STRING) continue;
                }
                return false;
            }
            return true;
        };
    }
}

