/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.telemetry;

import java.util.StringJoiner;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LSOperation;
import org.ballerinalang.langserver.telemetry.LSTelemetryEvent;

public class LSErrorTelemetryEvent
extends LSTelemetryEvent {
    private final String message;
    private final String errorMessage;
    private final String errorStackTrace;

    private LSErrorTelemetryEvent(String component, String version, String message, String errorMessage, String errorStackTrace) {
        super("ErrorTelemetryEvent", component, version);
        this.message = message;
        this.errorMessage = errorMessage;
        this.errorStackTrace = errorStackTrace;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    public static LSErrorTelemetryEvent from(LSOperation operation, String message, Throwable error) {
        return new LSErrorTelemetryEvent(LSErrorTelemetryEvent.getComponentName(operation), CommonUtil.SDK_VERSION, message, LSErrorTelemetryEvent.getErrorMessage(error), LSErrorTelemetryEvent.getStackTrace(error));
    }

    private static String getErrorMessage(Throwable error) {
        String claz = error.getClass().getName();
        String message = error.getMessage();
        return message != null ? claz + ": " + message : claz;
    }

    private static String getStackTrace(Throwable error) {
        Throwable cause;
        StringJoiner errorStackTrace = new StringJoiner("\n");
        errorStackTrace.add("Error: " + LSErrorTelemetryEvent.getErrorMessage(error));
        for (StackTraceElement elm : error.getStackTrace()) {
            errorStackTrace.add("\tat " + elm.toString());
            if (elm.getClassName().startsWith("org.ballerinalang.langserver")) break;
        }
        if ((cause = error.getCause()) != null) {
            errorStackTrace.add("Caused By: ").add(LSErrorTelemetryEvent.getStackTrace(cause));
        }
        return errorStackTrace.toString();
    }
}

