/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.contexts.ContextBuilder;
import org.ballerinalang.langserver.extensions.ballerina.document.BallerinaProjectParams;
import org.ballerinalang.langserver.extensions.ballerina.document.SyntaxTreeNodeRequest;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageComponentsRequest;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageConfigSchemaRequest;
import org.ballerinalang.langserver.extensions.ballerina.packages.PackageMetadataRequest;
import org.ballerinalang.langserver.extensions.ballerina.runner.MainFunctionParamsRequest;
import org.ballerinalang.langserver.extensions.ballerina.runner.ProjectDiagnosticsRequest;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeActionResolveSupportCapabilities;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FoldingRangeCapabilities;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticTokensCapabilities;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformationCapabilities;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.SymbolTagSupportCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseMessage;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;

public final class TestUtil {
    private static final String HOVER = "textDocument/hover";
    private static final String CODELENS = "textDocument/codeLens";
    private static final String COMPLETION = "textDocument/completion";
    private static final String SIGNATURE_HELP = "textDocument/signatureHelp";
    private static final String DEFINITION = "textDocument/definition";
    private static final String REFERENCES = "textDocument/references";
    private static final String PREPARE_RENAME = "textDocument/prepareRename";
    private static final String RENAME = "textDocument/rename";
    private static final String EXECUTE_COMMAND = "workspace/executeCommand";
    private static final String CODE_ACTION = "textDocument/codeAction";
    private static final String CODE_ACTION_RESOLVE = "codeAction/resolve";
    private static final String INLAY_HINT = "textDocument/inlayHint";
    private static final String FORMATTING = "textDocument/formatting";
    private static final String RANGE_FORMATTING = "textDocument/rangeFormatting";
    private static final String IMPLEMENTATION = "textDocument/implementation";
    private static final String DOCUMENT_SYMBOL = "textDocument/documentSymbol";
    private static final String FOLDING_RANGE = "textDocument/foldingRange";
    private static final String WORKSPACE_SYMBOL_COMMAND = "workspace/symbol";
    private static final String PACKAGE_METADATA = "ballerinaPackage/metadata";
    private static final String PACKAGE_COMPONENTS = "ballerinaPackage/components";
    private static final String PACKAGE_CONFIG_SCHEMA = "ballerinaPackage/configSchema";
    private static final String DOCUMENT_SYNTAX_TREE_NODE = "ballerinaDocument/syntaxTreeNode";
    private static final String DOCUMENT_EXEC_POSITIONS = "ballerinaDocument/executorPositions";
    private static final String SEMANTIC_TOKENS_FULL = "textDocument/semanticTokens/full";
    private static final String RUNNER_DIAGNOSTICS = "ballerinaRunner/diagnostics";
    private static final String RUNNER_MAIN_FUNC_PARAMS = "ballerinaRunner/mainFunctionParams";
    private static final Gson GSON = new Gson();

    private TestUtil() {
    }

    public static String getHoverResponse(String filePath, Position position, Endpoint serviceEndpoint) {
        CompletableFuture result = serviceEndpoint.request(HOVER, (Object)TestUtil.getHoverParams(filePath, position));
        return TestUtil.getResponseString(result);
    }

    public static String getCodeLensesResponse(String filePath, Endpoint serviceEndpoint) {
        TextDocumentIdentifier identifier = TestUtil.getTextDocumentIdentifier(filePath);
        CodeLensParams codeLensParams = new CodeLensParams(identifier);
        CompletableFuture result = serviceEndpoint.request(CODELENS, (Object)codeLensParams);
        return TestUtil.getResponseString(result);
    }

    public static String getCompletionResponse(String filePath, Position position, Endpoint endpoint, String triggerChar) {
        CompletableFuture result = endpoint.request(COMPLETION, (Object)TestUtil.getCompletionParams(filePath, position, triggerChar));
        return TestUtil.getResponseString(result);
    }

    public static String getCompletionResponse(URI fileURI, Position position, Endpoint endpoint, String triggerChar) {
        CompletableFuture result = endpoint.request(COMPLETION, (Object)TestUtil.getCompletionParams(fileURI, position, triggerChar));
        return TestUtil.getResponseString(result);
    }

    public static String getSignatureHelpResponse(String filePath, Position position, Endpoint serviceEndpoint) {
        CompletableFuture result = serviceEndpoint.request(SIGNATURE_HELP, (Object)TestUtil.getSignatureParams(filePath, position));
        return TestUtil.getResponseString(result);
    }

    public static String getDefinitionResponse(String fileUri, Position position, Endpoint serviceEndpoint) {
        CompletableFuture result = serviceEndpoint.request(DEFINITION, (Object)TestUtil.getDefinitionParams(fileUri, position));
        return TestUtil.getResponseString(result);
    }

    public static String getReferencesResponse(String fileUri, Position position, Endpoint serviceEndpoint) {
        ReferenceParams referenceParams = new ReferenceParams();
        ReferenceContext referenceContext = new ReferenceContext();
        referenceContext.setIncludeDeclaration(true);
        referenceParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        referenceParams.setTextDocument(TestUtil.getTextDocumentIdentifier(URI.create(fileUri)));
        referenceParams.setContext(referenceContext);
        CompletableFuture result = serviceEndpoint.request(REFERENCES, (Object)referenceParams);
        return TestUtil.getResponseString(result);
    }

    public static String getPrepareRenameResponse(String filePath, Position position, Endpoint serviceEndpoint) {
        PrepareRenameParams renameParams = new PrepareRenameParams();
        renameParams.setTextDocument(TestUtil.getTextDocumentIdentifier(filePath));
        renameParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        CompletableFuture result = serviceEndpoint.request(PREPARE_RENAME, (Object)renameParams);
        return TestUtil.getResponseString(result);
    }

    public static String getRenameResponse(String filePath, Position position, String newName, Endpoint serviceEndpoint) {
        RenameParams renameParams = new RenameParams();
        renameParams.setTextDocument(TestUtil.getTextDocumentIdentifier(filePath));
        renameParams.setNewName(newName);
        renameParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        CompletableFuture result = serviceEndpoint.request(RENAME, (Object)renameParams);
        return TestUtil.getResponseString(result);
    }

    public static String getCodeActionResponse(Endpoint serviceEndpoint, String filePath, Range range, CodeActionContext context) {
        TextDocumentIdentifier identifier = TestUtil.getTextDocumentIdentifier(filePath);
        return TestUtil.getCodeActionResponse(serviceEndpoint, identifier, range, context);
    }

    public static String getCodeActionResponse(Endpoint serviceEndpoint, TextDocumentIdentifier textDocument, Range range, CodeActionContext context) {
        CodeActionParams codeActionParams = new CodeActionParams(textDocument, range, context);
        CompletableFuture result = serviceEndpoint.request(CODE_ACTION, (Object)codeActionParams);
        return TestUtil.getResponseString(result);
    }

    public static String getCodeActionResolveResponse(Endpoint serviceEndpoint, Object codeAction) {
        CompletableFuture result = serviceEndpoint.request(CODE_ACTION_RESOLVE, codeAction);
        return TestUtil.getResponseString(result);
    }

    public static String getInlayHintsResponse(Endpoint serviceEndpoint, String filePath, Range range) {
        TextDocumentIdentifier identifier = TestUtil.getTextDocumentIdentifier(filePath);
        InlayHintParams inlayHintsParams = new InlayHintParams(identifier, range);
        CompletableFuture result = serviceEndpoint.request(INLAY_HINT, (Object)inlayHintsParams);
        return TestUtil.getResponseString(result);
    }

    public static String getExecuteCommandResponse(ExecuteCommandParams params, Endpoint serviceEndpoint) {
        CompletableFuture result = serviceEndpoint.request(EXECUTE_COMMAND, (Object)params);
        return TestUtil.getResponseString(result);
    }

    public static String getDocumentSymbolResponse(Endpoint serviceEndpoint, String filePath) {
        DocumentSymbolParams params = new DocumentSymbolParams(TestUtil.getTextDocumentIdentifier(filePath));
        CompletableFuture result = serviceEndpoint.request(DOCUMENT_SYMBOL, (Object)params);
        return TestUtil.getResponseString(result);
    }

    public static String getFormattingResponse(DocumentFormattingParams params, Endpoint serviceEndpoint) {
        CompletableFuture result = serviceEndpoint.request(FORMATTING, (Object)params);
        return TestUtil.getResponseString(result);
    }

    public static String getRangeFormatResponse(DocumentRangeFormattingParams params, Endpoint serviceEndpoint) {
        CompletableFuture result = serviceEndpoint.request(RANGE_FORMATTING, (Object)params);
        return TestUtil.getResponseString(result);
    }

    public static String getGotoImplementationResponse(Endpoint serviceEndpoint, String filePath, Position position) {
        TextDocumentPositionParams positionParams = TestUtil.getTextDocumentPositionParams(filePath, position);
        CompletableFuture completableFuture = serviceEndpoint.request(IMPLEMENTATION, (Object)positionParams);
        return TestUtil.getResponseString(completableFuture);
    }

    public static String getFoldingRangeResponse(Endpoint serviceEndpoint, String filePath) {
        FoldingRangeRequestParams foldingRangeParams = new FoldingRangeRequestParams(TestUtil.getTextDocumentIdentifier(filePath));
        return TestUtil.getResponseString(serviceEndpoint.request(FOLDING_RANGE, (Object)foldingRangeParams));
    }

    public static String getPackageMetadataResponse(Endpoint serviceEndpoint, String filePath) {
        PackageMetadataRequest packageMetadataRequest = new PackageMetadataRequest();
        packageMetadataRequest.setDocumentIdentifier(TestUtil.getTextDocumentIdentifier(filePath));
        return TestUtil.getResponseString(serviceEndpoint.request(PACKAGE_METADATA, (Object)packageMetadataRequest));
    }

    public static String getPackageComponentsResponse(Endpoint serviceEndpoint, Iterator<String> filePaths) {
        PackageComponentsRequest packageComponentsRequest = new PackageComponentsRequest();
        ArrayList documentIdentifiers = new ArrayList();
        filePaths.forEachRemaining(filePath -> documentIdentifiers.add(TestUtil.getTextDocumentIdentifier(filePath)));
        packageComponentsRequest.setDocumentIdentifiers(documentIdentifiers.toArray(new TextDocumentIdentifier[0]));
        return TestUtil.getResponseString(serviceEndpoint.request(PACKAGE_COMPONENTS, (Object)packageComponentsRequest));
    }

    public static String getRunnerDiagnosticsResponse(Endpoint serviceEndpoint, String projectDir) {
        ProjectDiagnosticsRequest projectDiagnosticsRequest = new ProjectDiagnosticsRequest();
        projectDiagnosticsRequest.setDocumentIdentifier(TestUtil.getTextDocumentIdentifier(projectDir));
        return TestUtil.getResponseString(serviceEndpoint.request(RUNNER_DIAGNOSTICS, (Object)projectDiagnosticsRequest));
    }

    public static String getRunnerMainFuncParamsResponse(Endpoint serviceEndpoint, String projectDir) {
        MainFunctionParamsRequest mainFunctionParamsRequest = new MainFunctionParamsRequest();
        mainFunctionParamsRequest.setDocumentIdentifier(TestUtil.getTextDocumentIdentifier(projectDir));
        return TestUtil.getResponseString(serviceEndpoint.request(RUNNER_MAIN_FUNC_PARAMS, (Object)mainFunctionParamsRequest));
    }

    public static String getPackageConfigSchemaResponse(Endpoint serviceEndpoint, String projectPath) {
        PackageConfigSchemaRequest packageConfigSchemaRequest = new PackageConfigSchemaRequest();
        packageConfigSchemaRequest.setDocumentIdentifier(TestUtil.getTextDocumentIdentifier(projectPath));
        return TestUtil.getResponseString(serviceEndpoint.request(PACKAGE_CONFIG_SCHEMA, (Object)packageConfigSchemaRequest));
    }

    public static String getSyntaxTreeNodeResponse(Endpoint serviceEndpoint, String filePath, Range range) {
        SyntaxTreeNodeRequest request = new SyntaxTreeNodeRequest();
        request.setDocumentIdentifiers(TestUtil.getTextDocumentIdentifier(filePath));
        request.setRange(range);
        return TestUtil.getResponseString(serviceEndpoint.request(DOCUMENT_SYNTAX_TREE_NODE, (Object)request));
    }

    public static String getExecutorPositionsResponse(Endpoint serviceEndpoint, String filePath) {
        BallerinaProjectParams executorPositionsRequest = new BallerinaProjectParams();
        executorPositionsRequest.setDocumentIdentifier(TestUtil.getTextDocumentIdentifier(filePath));
        return TestUtil.getResponseString(serviceEndpoint.request(DOCUMENT_EXEC_POSITIONS, (Object)executorPositionsRequest));
    }

    public static String getSemanticTokensResponse(Endpoint serviceEndpoint, String filePath) {
        SemanticTokensParams semanticTokensParams = new SemanticTokensParams(TestUtil.getTextDocumentIdentifier(filePath));
        return TestUtil.getResponseString(serviceEndpoint.request(SEMANTIC_TOKENS_FULL, (Object)semanticTokensParams));
    }

    public static void openDocument(Endpoint serviceEndpoint, Path filePath) throws IOException {
        byte[] encodedContent = Files.readAllBytes(filePath);
        TestUtil.openDocument(serviceEndpoint, filePath.toUri().toString(), new String(encodedContent));
    }

    public static void openDocument(Endpoint serviceEndpoint, String fileUri, String content) {
        DidOpenTextDocumentParams documentParams = new DidOpenTextDocumentParams();
        TextDocumentItem textDocumentItem = new TextDocumentItem();
        textDocumentItem.setUri(fileUri);
        textDocumentItem.setText(content);
        documentParams.setTextDocument(textDocumentItem);
        serviceEndpoint.notify("textDocument/didOpen", (Object)documentParams);
    }

    public static void didChangeDocument(Endpoint serviceEndpoint, Path filePath, String content) {
        TestUtil.didChangeDocument(serviceEndpoint, filePath.toUri(), content);
    }

    public static void didChangeDocument(Endpoint serviceEndpoint, URI fileUri, String content) {
        VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier();
        identifier.setUri(fileUri.toString());
        DidChangeTextDocumentParams didChangeTextDocumentParams = new DidChangeTextDocumentParams();
        didChangeTextDocumentParams.setTextDocument(identifier);
        didChangeTextDocumentParams.setContentChanges(List.of(new TextDocumentContentChangeEvent(content)));
        serviceEndpoint.notify("textDocument/didChange", (Object)didChangeTextDocumentParams);
    }

    public static void closeDocument(Endpoint serviceEndpoint, Path filePath) {
        TestUtil.closeDocument(serviceEndpoint, filePath.toUri().toString());
    }

    public static void closeDocument(Endpoint serviceEndpoint, String fileUri) {
        TextDocumentIdentifier documentIdentifier = new TextDocumentIdentifier();
        documentIdentifier.setUri(fileUri);
        serviceEndpoint.notify("textDocument/didClose", (Object)new DidCloseTextDocumentParams(documentIdentifier));
    }

    public static Endpoint initializeLanguageSever() {
        return TestUtil.initializeLanguageSever(new BallerinaLanguageServer());
    }

    public static Endpoint initializeLanguageSever(BallerinaLanguageServer languageServer) {
        return TestUtil.initializeLanguageSever(languageServer, OutputStream.nullOutputStream());
    }

    public static Endpoint initializeLanguageSever(BallerinaLanguageServer languageServer, OutputStream out) {
        return TestUtil.newLanguageServer().withLanguageServer(languageServer).withInputStream(new ByteArrayInputStream(new byte[1024])).withOutputStream(out).build();
    }

    public static void shutdownLanguageServer(Endpoint serviceEndpoint) {
        serviceEndpoint.notify("shutdown", null);
    }

    public static boolean isArgumentsSubArray(JsonArray checkAgainst, JsonArray evalArray) {
        for (JsonElement jsonElement : evalArray) {
            if (checkAgainst.contains(jsonElement)) continue;
            return false;
        }
        return true;
    }

    public static void didChangeWatchedFiles(Endpoint serviceEndpoint, DidChangeWatchedFilesParams params) {
        serviceEndpoint.notify("workspace/didChangeWatchedFiles", (Object)params);
    }

    public static String getWorkspaceSymbolResponse(Endpoint serviceEndpoint, String query) {
        WorkspaceSymbolParams parms = new WorkspaceSymbolParams(query);
        CompletableFuture result = serviceEndpoint.request(WORKSPACE_SYMBOL_COMMAND, (Object)parms);
        return TestUtil.getResponseString(result);
    }

    @Deprecated
    public static TextDocumentIdentifier getTextDocumentIdentifier(String filePath) {
        TextDocumentIdentifier identifier = new TextDocumentIdentifier();
        identifier.setUri(Path.of(filePath, new String[0]).toUri().toString());
        return identifier;
    }

    public static TextDocumentIdentifier getTextDocumentIdentifier(URI fileUri) {
        TextDocumentIdentifier identifier = new TextDocumentIdentifier();
        identifier.setUri(fileUri.toString());
        return identifier;
    }

    public static TextDocumentPositionParams getTextDocumentPositionParams(String filePath, Position position) {
        TextDocumentPositionParams positionParams = new TextDocumentPositionParams();
        positionParams.setTextDocument(TestUtil.getTextDocumentIdentifier(filePath));
        positionParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        return positionParams;
    }

    private static HoverParams getHoverParams(String filePath, Position position) {
        HoverParams hoverParams = new HoverParams();
        hoverParams.setTextDocument(TestUtil.getTextDocumentIdentifier(filePath));
        hoverParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        return hoverParams;
    }

    private static DefinitionParams getDefinitionParams(String fileUri, Position position) {
        DefinitionParams definitionParams = new DefinitionParams();
        definitionParams.setTextDocument(TestUtil.getTextDocumentIdentifier(URI.create(fileUri)));
        definitionParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        return definitionParams;
    }

    private static SignatureHelpParams getSignatureParams(String filePath, Position position) {
        SignatureHelpParams signatureHelpParams = new SignatureHelpParams();
        signatureHelpParams.setTextDocument(TestUtil.getTextDocumentIdentifier(filePath));
        signatureHelpParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        return signatureHelpParams;
    }

    private static CompletionParams getCompletionParams(String filePath, Position position, String triggerChar) {
        CompletionParams completionParams = new CompletionParams();
        completionParams.setTextDocument(TestUtil.getTextDocumentIdentifier(filePath));
        completionParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        CompletionContext context = new CompletionContext();
        if (triggerChar != null && !triggerChar.isEmpty()) {
            context.setTriggerCharacter(triggerChar);
            context.setTriggerKind(CompletionTriggerKind.TriggerCharacter);
        } else {
            context.setTriggerKind(CompletionTriggerKind.Invoked);
        }
        completionParams.setContext(context);
        return completionParams;
    }

    private static CompletionParams getCompletionParams(URI fileURI, Position position, String triggerChar) {
        CompletionParams completionParams = new CompletionParams();
        completionParams.setTextDocument(TestUtil.getTextDocumentIdentifier(fileURI));
        completionParams.setPosition(new Position(position.getLine(), position.getCharacter()));
        CompletionContext context = new CompletionContext();
        if (triggerChar != null && !triggerChar.isEmpty()) {
            context.setTriggerCharacter(triggerChar);
            context.setTriggerKind(CompletionTriggerKind.TriggerCharacter);
        } else {
            context.setTriggerKind(CompletionTriggerKind.Invoked);
        }
        completionParams.setContext(context);
        return completionParams;
    }

    public static String getResponseString(CompletableFuture<?> completableFuture) {
        ResponseMessage jsonrpcResponse = new ResponseMessage();
        try {
            jsonrpcResponse.setId("324");
            jsonrpcResponse.setResult(completableFuture.get());
        }
        catch (InterruptedException e) {
            ResponseError responseError = new ResponseError();
            responseError.setCode(-32002);
            responseError.setMessage("Attempted to retrieve the result of a task/sthat was aborted by throwing an exception");
            jsonrpcResponse.setError(responseError);
        }
        catch (ExecutionException e) {
            ResponseError responseError = new ResponseError();
            responseError.setCode(-32001);
            responseError.setMessage("Current thread was interrupted");
            jsonrpcResponse.setError(responseError);
        }
        return GSON.toJson((Object)jsonrpcResponse).replace("\r\n", "\n").replace("\\r\\n", "\\n");
    }

    public static List<Diagnostic> compileAndGetDiagnostics(Path sourcePath, WorkspaceManager workspaceManager, LanguageServerContext serverContext) throws IOException, WorkspaceDocumentException {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        DocumentServiceContext context = ContextBuilder.buildDocumentServiceContext(sourcePath.toUri().toString(), workspaceManager, LSContextOperation.TXT_DID_OPEN, serverContext);
        DidOpenTextDocumentParams params = new DidOpenTextDocumentParams();
        TextDocumentItem textDocument = new TextDocumentItem();
        textDocument.setUri(sourcePath.toUri().toString());
        textDocument.setText(new String(Files.readAllBytes(sourcePath)));
        params.setTextDocument(textDocument);
        context.workspace().didOpen(sourcePath, params);
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return diagnostics;
        }
        DiagnosticResult diagnosticResult = ((Project)project.get()).currentPackage().getCompilation().diagnosticResult();
        diagnostics.addAll(diagnosticResult.diagnostics());
        return diagnostics;
    }

    public static Optional<Package> compileAndGetPackage(Path sourcePath, WorkspaceManager workspaceManager, LanguageServerContext serverContext) throws IOException, WorkspaceDocumentException {
        DocumentServiceContext context = ContextBuilder.buildDocumentServiceContext(sourcePath.toUri().toString(), workspaceManager, LSContextOperation.TXT_DID_OPEN, serverContext);
        DidOpenTextDocumentParams params = new DidOpenTextDocumentParams();
        TextDocumentItem textDocument = new TextDocumentItem();
        textDocument.setUri(sourcePath.toUri().toString());
        textDocument.setText(new String(Files.readAllBytes(sourcePath)));
        params.setTextDocument(textDocument);
        context.workspace().didOpen(sourcePath, params);
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((Project)project.get()).currentPackage());
    }

    public static LanguageServerBuilder newLanguageServer() {
        return new LanguageServerBuilder();
    }

    public static class LanguageServerBuilder {
        private BallerinaLanguageServer languageServer;
        private InputStream inputStream;
        private OutputStream outputStream;
        private InitializeParams initializeParams;
        private final Map<String, Object> initOptions = new HashMap<String, Object>();
        private ExtendedLanguageClient client;

        public LanguageServerBuilder withLanguageServer(BallerinaLanguageServer languageServer) {
            this.languageServer = languageServer;
            return this;
        }

        public LanguageServerBuilder withInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public LanguageServerBuilder withOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public LanguageServerBuilder withInitOption(String key, Object value) {
            this.initOptions.put(key, value);
            return this;
        }

        public LanguageServerBuilder withClient(ExtendedLanguageClient client) {
            this.client = client;
            return this;
        }

        public Endpoint build() {
            if (this.languageServer == null) {
                this.languageServer = new BallerinaLanguageServer();
            }
            if (this.inputStream == null) {
                this.inputStream = new ByteArrayInputStream(new byte[1024]);
            }
            if (this.outputStream == null) {
                this.outputStream = OutputStream.nullOutputStream();
            }
            if (this.client == null) {
                Launcher launcher = Launcher.createLauncher((Object)this.languageServer, ExtendedLanguageClient.class, (InputStream)this.inputStream, (OutputStream)this.outputStream);
                this.client = (ExtendedLanguageClient)launcher.getRemoteProxy();
            }
            this.languageServer.connect(this.client);
            if (this.initializeParams == null) {
                this.initializeParams = new InitializeParams();
                ClientCapabilities capabilities = new ClientCapabilities();
                TextDocumentClientCapabilities textDocumentClientCapabilities = new TextDocumentClientCapabilities();
                CompletionCapabilities completionCapabilities = new CompletionCapabilities();
                SignatureHelpCapabilities signatureHelpCapabilities = new SignatureHelpCapabilities();
                SignatureInformationCapabilities sigInfoCapabilities = new SignatureInformationCapabilities(Arrays.asList("markdown", "plaintext"));
                signatureHelpCapabilities.setSignatureInformation(sigInfoCapabilities);
                completionCapabilities.setCompletionItem(new CompletionItemCapabilities(Boolean.valueOf(true)));
                completionCapabilities.setContextSupport(Boolean.valueOf(true));
                textDocumentClientCapabilities.setCompletion(completionCapabilities);
                textDocumentClientCapabilities.setSignatureHelp(signatureHelpCapabilities);
                CodeActionResolveSupportCapabilities resolveSupportCapabilities = new CodeActionResolveSupportCapabilities(List.of("edit"));
                CodeActionCapabilities codeActionCapabilities = new CodeActionCapabilities();
                codeActionCapabilities.setResolveSupport(resolveSupportCapabilities);
                textDocumentClientCapabilities.setCodeAction(codeActionCapabilities);
                FoldingRangeCapabilities foldingRangeCapabilities = new FoldingRangeCapabilities();
                foldingRangeCapabilities.setLineFoldingOnly(Boolean.valueOf(true));
                textDocumentClientCapabilities.setFoldingRange(foldingRangeCapabilities);
                RenameCapabilities renameCapabilities = new RenameCapabilities();
                renameCapabilities.setPrepareSupport(Boolean.valueOf(true));
                renameCapabilities.setHonorsChangeAnnotations(Boolean.valueOf(true));
                textDocumentClientCapabilities.setRename(renameCapabilities);
                textDocumentClientCapabilities.setSemanticTokens(new SemanticTokensCapabilities(Boolean.valueOf(true)));
                DocumentSymbolCapabilities documentSymbolCapabilities = new DocumentSymbolCapabilities();
                documentSymbolCapabilities.setHierarchicalDocumentSymbolSupport(Boolean.valueOf(true));
                documentSymbolCapabilities.setTagSupport(new SymbolTagSupportCapabilities(Arrays.asList(SymbolTag.Deprecated)));
                textDocumentClientCapabilities.setDocumentSymbol(documentSymbolCapabilities);
                capabilities.setTextDocument(textDocumentClientCapabilities);
                WorkspaceClientCapabilities workspaceCapabilities = new WorkspaceClientCapabilities();
                workspaceCapabilities.setExecuteCommand(new ExecuteCommandCapabilities(Boolean.valueOf(true)));
                capabilities.setWorkspace(workspaceCapabilities);
                this.initializeParams.setCapabilities(capabilities);
            }
            HashMap<String, Object> initializationOptions = new HashMap<String, Object>();
            initializationOptions.put("enableSemanticHighlighting", true);
            initializationOptions.put("enableInlayHints", true);
            initializationOptions.put("supportBalaScheme", true);
            if (!this.initOptions.isEmpty()) {
                initializationOptions.putAll(this.initOptions);
            } else {
                initializationOptions.put("enableIndexPackages", false);
            }
            this.initializeParams.setInitializationOptions((Object)GSON.toJsonTree(initializationOptions));
            Endpoint endpoint = ServiceEndpoints.toEndpoint((Object)this.languageServer);
            endpoint.request("initialize", (Object)this.initializeParams);
            endpoint.request("initialized", (Object)new InitializedParams());
            return endpoint;
        }
    }
}

