/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.workspace;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.BalToolToml;
import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.CloudToml;
import io.ballerina.projects.CompilerPluginToml;
import io.ballerina.projects.DependenciesToml;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectPaths;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.eventsync.EventKind;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.RunContext;
import org.ballerinalang.langserver.commons.workspace.RunResult;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.config.LSClientConfigHolder;
import org.ballerinalang.langserver.contexts.ContextBuilder;
import org.ballerinalang.langserver.eventsync.EventSyncPubSubHolder;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class BallerinaWorkspaceManager
implements WorkspaceManager {
    private static final String JAVA_COMMAND = "java.command";
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String HEAP_DUMP_FLAG = "-XX:+HeapDumpOnOutOfMemoryError";
    private static final String HEAP_DUMP_PATH_FLAG = "-XX:HeapDumpPath=";
    private static final String DEBUG_ARGS = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:";
    private final Map<Path, Path> pathToSourceRootCache;
    protected final Map<Path, ProjectContext> sourceRootToProject;
    private final Map<Path, Lock> projectLockMap;
    protected final LSClientLogger clientLogger;
    private final LanguageServerContext serverContext;
    private final Set<Path> openedDocuments = new HashSet<Path>();

    public BallerinaWorkspaceManager(LanguageServerContext serverContext) {
        this.serverContext = serverContext;
        this.clientLogger = LSClientLogger.getInstance(serverContext);
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(1000L).build();
        this.pathToSourceRootCache = cache.asMap();
        this.sourceRootToProject = new SourceRootToProjectMap<Path, ProjectContext>(this.pathToSourceRootCache);
        this.projectLockMap = new ConcurrentHashMap<Path, Lock>();
        WeakReference<Map<Path, ProjectContext>> weekMap = new WeakReference<Map<Path, ProjectContext>>(this.sourceRootToProject);
        Runtime.getRuntime().addShutdownHook(Thread.ofVirtual().unstarted(() -> {
            Map map = (Map)weekMap.get();
            if (map == null) {
                return;
            }
            for (ProjectContext projectContext : map.values()) {
                projectContext.process().ifPresent(Process::destroy);
            }
        }));
    }

    public Optional<String> relativePath(Path path) {
        Optional<Document> document = this.document(path);
        return document.map(Document::name);
    }

    public Optional<String> relativePath(Path path, @Nonnull CancelChecker cancelChecker) {
        Optional<Document> document = this.document(path, cancelChecker);
        return document.map(Document::name);
    }

    public Path projectRoot(Path filePath) {
        return this.pathToSourceRootCache.computeIfAbsent(filePath, this::computeProjectRoot);
    }

    public Path projectRoot(Path filePath, @Nonnull CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        return this.projectRoot(filePath);
    }

    public Optional<Project> project(Path filePath) {
        return this.projectContext(this.projectRoot(filePath)).map(ProjectContext::project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project loadProject(Path filePath) throws ProjectException, WorkspaceDocumentException, EventSyncException {
        Optional<Project> optionalProject = this.project(filePath);
        if (optionalProject.isPresent()) {
            return optionalProject.get();
        }
        Lock projectLock = this.projectLockMap.computeIfAbsent(this.projectRoot(filePath), k -> new ReentrantLock());
        projectLock.lock();
        try {
            optionalProject = this.project(filePath);
            if (optionalProject.isPresent()) {
                Project project = optionalProject.get();
                return project;
            }
            Project project = this.createOrGetProjectPair(filePath, LSContextOperation.LOAD_PROJECT.getName()).project();
            DocumentServiceContext context = ContextBuilder.buildDocumentServiceContext(filePath.toUri().toString(), this, LSContextOperation.LOAD_PROJECT, this.serverContext);
            EventSyncPubSubHolder.getInstance(this.serverContext).getPublisher(EventKind.PROJECT_UPDATE).publish((ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class), this.serverContext, context);
            Project project2 = project;
            return project2;
        }
        finally {
            projectLock.unlock();
        }
    }

    public Optional<Module> module(Path filePath) {
        Optional<Project> project = this.project(filePath);
        if (project.isEmpty()) {
            return Optional.empty();
        }
        Optional<Document> document = this.document(filePath, project.get(), null);
        if (document.isEmpty()) {
            if (filePath.equals(this.projectRoot(filePath))) {
                return Optional.of(project.get().currentPackage().getDefaultModule());
            }
            return Optional.empty();
        }
        return Optional.of(document.get().module());
    }

    public Optional<Module> module(Path filePath, @Nonnull CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        Optional<Project> project = this.project(filePath);
        if (project.isEmpty()) {
            return Optional.empty();
        }
        Optional<Document> document = this.document(filePath, project.get(), cancelChecker);
        if (document.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(document.get().module());
    }

    public Optional<Document> document(Path filePath) {
        Optional<Project> project = this.project(filePath);
        return project.isPresent() ? this.document(filePath, project.get(), null) : Optional.empty();
    }

    public Optional<Document> document(Path filePath, @Nonnull CancelChecker cancelChecker) {
        Optional<Project> project = this.project(filePath);
        return project.isPresent() ? this.document(filePath, project.get(), cancelChecker) : Optional.empty();
    }

    public Optional<SyntaxTree> syntaxTree(Path filePath) {
        Optional<Document> document = this.document(filePath);
        if (document.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(document.get().syntaxTree());
    }

    public Optional<SyntaxTree> syntaxTree(Path filePath, @Nonnull CancelChecker cancelChecker) {
        Optional<Document> document = this.document(filePath, cancelChecker);
        if (document.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(document.get().syntaxTree());
    }

    public Optional<SemanticModel> semanticModel(Path filePath) {
        Optional<Module> module = this.module(filePath);
        Optional<PackageCompilation> packageCompilation = this.waitAndGetPackageCompilation(filePath);
        Optional<ProjectContext> projectPair = this.projectContext(this.projectRoot(filePath));
        if (module.isEmpty() || packageCompilation.isEmpty() || projectPair.isEmpty() || projectPair.get().compilationCrashed()) {
            return Optional.empty();
        }
        return Optional.of(packageCompilation.get().getSemanticModel(module.get().moduleId()));
    }

    public Optional<SemanticModel> semanticModel(Path filePath, @Nonnull CancelChecker cancelChecker) {
        Optional<Module> module = this.module(filePath);
        Optional<PackageCompilation> packageCompilation = this.waitAndGetPackageCompilation(filePath, cancelChecker);
        Optional<ProjectContext> projectPair = this.projectContext(this.projectRoot(filePath));
        if (module.isEmpty() || packageCompilation.isEmpty() || projectPair.isEmpty() || projectPair.get().compilationCrashed()) {
            return Optional.empty();
        }
        return Optional.of(packageCompilation.get().getSemanticModel(module.get().moduleId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<PackageCompilation> waitAndGetPackageCompilation(Path filePath, boolean isSourceChange) {
        Optional<ProjectContext> projectPair = this.projectContext(this.projectRoot(filePath));
        if (projectPair.isEmpty() || projectPair.get().compilationCrashed() && !isSourceChange) {
            return Optional.empty();
        }
        Lock lock = projectPair.get().lockAndGet();
        try {
            PackageCompilation compilation = projectPair.get().project().currentPackage().getCompilation();
            if (projectPair.get().compilationCrashed()) {
                projectPair.get().setCompilationCrashed(false);
            }
            if (compilation.diagnosticResult().diagnostics().stream().anyMatch(diagnostic -> Arrays.asList(DiagnosticErrorCode.BAD_SAD_FROM_COMPILER.diagnosticId(), DiagnosticErrorCode.CYCLIC_MODULE_IMPORTS_DETECTED.diagnosticId()).contains(diagnostic.diagnosticInfo().code()))) {
                projectPair.get().setCompilationCrashed(true);
                projectPair.get().project().clearCaches();
            }
            Optional<PackageCompilation> optional = Optional.of(compilation);
            return optional;
        }
        finally {
            lock.unlock();
        }
    }

    public Optional<PackageCompilation> waitAndGetPackageCompilation(Path filePath) {
        return this.waitAndGetPackageCompilation(filePath, false);
    }

    public Optional<PackageCompilation> waitAndGetPackageCompilation(Path filePath, @Nonnull CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        return this.waitAndGetPackageCompilation(filePath);
    }

    public void didOpen(Path filePath, DidOpenTextDocumentParams params) throws WorkspaceDocumentException {
        this.openedDocuments.add(filePath);
        ProjectContext projectContext = this.createOrGetProjectPair(filePath, LSContextOperation.TXT_DID_OPEN.getName(), true);
        Project project = projectContext.project();
        if (filePath.equals(project.sourceRoot().resolve("Ballerina.toml"))) {
            this.updateBallerinaToml(params.getTextDocument().getText(), projectContext, true);
        } else if (filePath.equals(project.sourceRoot().resolve("Dependencies.toml"))) {
            this.updateDependenciesToml(params.getTextDocument().getText(), projectContext, true);
        } else if (filePath.equals(project.sourceRoot().resolve("Cloud.toml"))) {
            this.updateCloudToml(params.getTextDocument().getText(), projectContext, true);
        } else if (filePath.equals(project.sourceRoot().resolve("CompilerPlugin.toml"))) {
            this.updateCompilerPluginToml(params.getTextDocument().getText(), projectContext, true);
        } else if (filePath.equals(project.sourceRoot().resolve("BalTool.toml"))) {
            this.updateBalToolToml(params.getTextDocument().getText(), projectContext, true);
        } else if (ProjectPaths.isBalFile((Path)filePath) && project.kind() != ProjectKind.BALA_PROJECT) {
            this.createBalDocument(filePath, params.getTextDocument().getText(), projectContext);
        }
    }

    public void didChange(Path filePath, DidChangeTextDocumentParams params) throws WorkspaceDocumentException {
        ProjectContext projectContext = this.createOrGetProjectPair(filePath, LSContextOperation.TXT_DID_CHANGE.getName(), true);
        Project project = projectContext.project();
        if (filePath.equals(project.sourceRoot().resolve("Ballerina.toml"))) {
            this.updateBallerinaToml(((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), projectContext, false);
        } else if (filePath.equals(project.sourceRoot().resolve("Dependencies.toml"))) {
            this.updateDependenciesToml(((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), projectContext, false);
        } else if (filePath.equals(project.sourceRoot().resolve("Cloud.toml"))) {
            this.updateCloudToml(((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), projectContext, false);
        } else if (filePath.equals(project.sourceRoot().resolve("CompilerPlugin.toml"))) {
            this.updateCompilerPluginToml(((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), projectContext, false);
        } else if (filePath.equals(project.sourceRoot().resolve("BalTool.toml"))) {
            this.updateBalToolToml(((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), projectContext, false);
        } else if (ProjectPaths.isBalFile((Path)filePath) && project.kind() != ProjectKind.BALA_PROJECT) {
            this.updateBalDocument(filePath, ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), projectContext);
        }
    }

    public void didChangeWatched(Path filePath, FileEvent fileEvent) throws WorkspaceDocumentException {
        if (!LSClientConfigHolder.getInstance(this.serverContext).getConfig().isEnableFileWatcher()) {
            return;
        }
        Optional<ProjectContext> optProject = this.getProjectOfWatchedFileChange(filePath, fileEvent);
        if (optProject.isEmpty()) {
            this.clientLogger.logTrace(String.format("Operation '%s' No matching project found, {fileUri: '%s' event: '%s'} ignored", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri(), fileEvent.getType().name()));
            return;
        }
        ProjectContext projectContext = optProject.get();
        Project project = projectContext.project();
        String fileName = filePath.getFileName().toString();
        boolean isBallerinaSourceChange = fileName.endsWith(".bal");
        boolean isBallerinaTomlChange = filePath.endsWith("Ballerina.toml");
        boolean isDependenciesTomlChange = filePath.endsWith("Dependencies.toml");
        boolean isCloudTomlChange = filePath.endsWith("Cloud.toml");
        boolean isCompilerPluginTomlChange = filePath.endsWith("CompilerPlugin.toml");
        boolean isBalToolTomlChange = filePath.endsWith("BalTool.toml");
        if (fileEvent.getType() == FileChangeType.Created && (isBallerinaSourceChange || isBallerinaTomlChange || isCloudTomlChange || isCompilerPluginTomlChange || isBalToolTomlChange) && this.hasDocumentOrToml(filePath, project)) {
            this.clientLogger.logTrace(String.format("Operation '%s' File already exits, {fileUri: '%s' event: '%s'} ignored", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri(), fileEvent.getType().name()));
            return;
        }
        if (isBallerinaSourceChange) {
            this.handleWatchedBalSourceChange(filePath, fileEvent, projectContext);
        } else if (isBallerinaTomlChange) {
            this.handleWatchedBallerinaTomlChange(filePath, fileEvent, projectContext);
        } else if (isCloudTomlChange) {
            this.handleWatchedCloudTomlChange(filePath, fileEvent, projectContext);
        } else if (isDependenciesTomlChange) {
            this.handleWatchedDependenciesTomlChange(filePath, fileEvent, projectContext);
        } else if (isCompilerPluginTomlChange) {
            this.handleWatchedCompilerPluginTomlChange(filePath, fileEvent, projectContext);
        } else if (isBalToolTomlChange) {
            this.handleWatchedBalToolTomlChange(filePath, fileEvent, projectContext);
        } else {
            this.handleWatchedModuleChange(filePath, fileEvent, projectContext);
        }
    }

    public List<Path> didChangeWatched(DidChangeWatchedFilesParams params) throws WorkspaceDocumentException {
        if (!LSClientConfigHolder.getInstance(this.serverContext).getConfig().isEnableFileWatcher()) {
            return Collections.emptyList();
        }
        List changes = params.getChanges();
        if (changes.size() == 1) {
            FileEvent fileEvent = (FileEvent)changes.get(0);
            String uri = fileEvent.getUri();
            Optional<Path> pathFromURI = PathUtil.getPathFromURI(uri);
            if (pathFromURI.isEmpty()) {
                return Collections.emptyList();
            }
            Path filePath = pathFromURI.get();
            if (!this.openedDocuments.contains(filePath) || fileEvent.getType() == FileChangeType.Deleted) {
                this.didChangeWatched(filePath, fileEvent);
                Optional<ProjectContext> optProject = this.getProjectOfWatchedFileChange(filePath, fileEvent);
                if (optProject.isPresent()) {
                    ProjectContext projectContext = optProject.get();
                    Project project = projectContext.project();
                    return List.of(project.sourceRoot());
                }
            }
            return Collections.emptyList();
        }
        HashSet<Path> reloadableProjects = new HashSet<Path>();
        for (FileEvent fileEvent : changes) {
            String uri = fileEvent.getUri();
            Optional<Path> pathFromURI = PathUtil.getPathFromURI(uri);
            if (pathFromURI.isEmpty()) {
                return Collections.emptyList();
            }
            Path filePath = pathFromURI.get();
            try {
                reloadableProjects.add(ProjectPaths.packageRoot((Path)filePath));
            }
            catch (ProjectException projectException) {}
        }
        reloadableProjects.forEach(path -> {
            Optional<ProjectContext> projectPair = this.projectContext((Path)path);
            if (projectPair.isEmpty()) {
                return;
            }
            Lock lock = projectPair.get().lockAndGet();
            try {
                Optional<ProjectContext> projectContext = this.createProjectContext((Path)path, LSContextOperation.WS_WF_CHANGED.getName());
                if (projectContext.isEmpty()) {
                    throw new WorkspaceDocumentException("Cannot find the project of uri: " + path.toString());
                }
                projectPair.get().setProject(projectContext.get().project());
            }
            catch (Throwable e) {
                String message = "Failed to reload project: [" + projectPair.get().project().sourceRoot().toString() + "]";
                this.clientLogger.logError(LSContextOperation.WS_WF_CHANGED, message, e, null, new Position[]{null});
            }
            finally {
                lock.unlock();
            }
        });
        return new ArrayList<Path>(reloadableProjects);
    }

    public String uriScheme() {
        return "file";
    }

    public RunResult run(RunContext executionContext) throws IOException {
        Path projectRoot = this.projectRoot(executionContext.balSourcePath());
        Optional<ProjectContext> projectContext = this.validateProjectContext(projectRoot);
        if (projectContext.isEmpty()) {
            return new RunResult(null, Collections.emptyList());
        }
        if (!this.stopProject(projectContext.get())) {
            this.logError("Run command execution aborted because couldn't stop the previous run");
            return new RunResult(null, Collections.emptyList());
        }
        Project project = projectContext.get().project();
        Optional<PackageCompilation> packageCompilation = this.waitAndGetPackageCompilation(project.sourceRoot(), true);
        if (packageCompilation.isEmpty()) {
            this.logError("Run command execution aborted because package compilation failed");
            return new RunResult(null, Collections.emptyList());
        }
        JBallerinaBackend jBallerinaBackend = BallerinaWorkspaceManager.execBackend(projectContext.get(), packageCompilation.get());
        LinkedList diagnostics = new LinkedList();
        diagnostics.addAll(jBallerinaBackend.diagnosticResult().diagnostics(false));
        diagnostics.addAll(project.currentPackage().getBuildToolResolution().getDiagnosticList());
        if (diagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity() == DiagnosticSeverity.ERROR)) {
            return new RunResult(null, diagnostics);
        }
        Optional<Process> process = this.executeProject(projectContext.get(), executionContext);
        return process.map(value -> new RunResult(value, diagnostics)).orElseGet(() -> new RunResult(null, diagnostics));
    }

    private Optional<ProjectContext> validateProjectContext(Path projectRoot) {
        Optional<ProjectContext> projectContextOpt = this.projectContext(projectRoot);
        if (projectContextOpt.isEmpty()) {
            this.logError("Run command execution aborted because project is not loaded");
            return Optional.empty();
        }
        return projectContextOpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Process> executeProject(ProjectContext projectContext, RunContext context) throws IOException {
        Project project = projectContext.project();
        Package pkg = project.currentPackage();
        Module executableModule = pkg.getDefaultModule();
        JBallerinaBackend jBallerinaBackend = BallerinaWorkspaceManager.execBackend(projectContext, pkg.getCompilation());
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        List<String> commands = this.prepareExecutionCommands(context, executableModule, jarResolver);
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.environment().putAll(context.env());
        Lock lock = projectContext.lockAndGet();
        try {
            Optional<Process> existing = projectContext.process();
            if (existing.isPresent()) {
                this.logError("Run command execution aborted because another run is in progress");
                Optional<Process> optional = Optional.empty();
                return optional;
            }
            Process ps = pb.start();
            projectContext.setProcess(ps);
            Optional<Process> optional = Optional.of(ps);
            return optional;
        }
        finally {
            lock.unlock();
        }
    }

    private List<String> prepareExecutionCommands(RunContext context, Module module, JarResolver jarResolver) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(System.getProperty(JAVA_COMMAND));
        commands.add(HEAP_DUMP_FLAG);
        commands.add(HEAP_DUMP_PATH_FLAG + USER_DIR);
        if (context.debugPort() > 0) {
            commands.add(DEBUG_ARGS + context.debugPort());
        }
        commands.add("-cp");
        commands.add(this.getAllClassPaths(jarResolver));
        String initClassName = JarResolver.getQualifiedClassName((String)module.packageInstance().packageOrg().toString(), (String)module.packageInstance().packageName().toString(), (String)module.packageInstance().packageVersion().toString(), (String)"$_init");
        commands.add(initClassName);
        commands.addAll(context.programArgs());
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JBallerinaBackend execBackend(ProjectContext projectContext, PackageCompilation packageCompilation) {
        Lock lock = projectContext.lockAndGet();
        try {
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JvmTarget)JvmTarget.JAVA_21, (boolean)false);
            Package pkg = projectContext.project.currentPackage();
            for (Module module : pkg.modules()) {
                for (DocumentId id : module.documentIds()) {
                    module.document(id).modify().apply();
                }
            }
            JBallerinaBackend jBallerinaBackend2 = jBallerinaBackend;
            return jBallerinaBackend2;
        }
        finally {
            lock.unlock();
        }
    }

    private void logError(String message) {
        UserErrorException e = new UserErrorException(message);
        this.clientLogger.logError(LSContextOperation.WS_EXEC_CMD, message, e, null, new Position[]{null});
    }

    public boolean stop(Path filePath) {
        Optional<ProjectContext> projectPairOpt = this.projectContext(this.projectRoot(filePath).toAbsolutePath());
        if (projectPairOpt.isEmpty()) {
            this.clientLogger.logWarning("Failed to stop process: Project not found");
            return false;
        }
        ProjectContext projectContext = projectPairOpt.get();
        return this.stopProject(projectContext);
    }

    public CompletableFuture<Map<Path, Project>> workspaceProjects() {
        ExtendedLanguageClient extendedLanguageClient = (ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class);
        CompletableFuture future = extendedLanguageClient.workspaceFolders();
        return future.thenApply(workspaceFolders -> {
            HashMap filteredProjects = new HashMap();
            workspaceFolders.forEach(workspaceFolder -> {
                Path workspaceFolderPath = Path.of(URI.create(workspaceFolder.getUri()));
                this.sourceRootToProject.entrySet().stream().filter(pathProjectContextEntry -> ((Path)pathProjectContextEntry.getKey()).toAbsolutePath().startsWith(workspaceFolderPath)).forEach(pathProjectContextEntry -> filteredProjects.put((Path)pathProjectContextEntry.getKey(), ((ProjectContext)pathProjectContextEntry.getValue()).project()));
            });
            return filteredProjects;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopProject(ProjectContext projectContext) {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional<Process> existing = projectContext.process();
            if (existing.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean killed = this.killProcess(existing.get());
            if (killed) {
                projectContext.removeProcess();
            }
            boolean bl = killed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean killProcess(Process process) {
        process.destroy();
        try {
            process.waitFor(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            this.clientLogger.logWarning("Waiting for process to stop was interrupted");
            Thread.currentThread().interrupt();
        }
        if (process.isAlive()) {
            process.destroyForcibly();
        }
        return !process.isAlive();
    }

    private String getAllClassPaths(JarResolver jarResolver) {
        StringJoiner cp = new StringJoiner(File.pathSeparator);
        for (JarLibrary lib : jarResolver.getJarFilePathsRequiredForExecution()) {
            cp.add(lib.path().toString());
        }
        return cp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshProject(Path filePath) throws WorkspaceDocumentException {
        Optional<ProjectContext> projectPairOpt = this.projectContext(this.projectRoot(filePath));
        if (projectPairOpt.isEmpty()) {
            throw new WorkspaceDocumentException("Project not found for filePath: " + String.valueOf(filePath));
        }
        Lock lock = projectPairOpt.get().lockAndGet();
        try {
            projectPairOpt.get().project().clearCaches();
        }
        finally {
            lock.unlock();
        }
    }

    private Optional<ProjectContext> projectOfWatchedFileChange(Path filePath, FileEvent fileEvent, boolean isBallerinaSourceChange, boolean isBallerinaTomlChange, boolean isDependenciesTomlChange, boolean isCloudTomlChange, boolean isCompilerPluginTomlChange, boolean isBalToolTomlChange, boolean isModuleChange) {
        if (isBallerinaSourceChange) {
            if (fileEvent.getType() == FileChangeType.Created) {
                return this.projectContext(this.projectRoot(filePath));
            }
            Optional<ProjectContext> optProject = this.projectContext(filePath);
            if (optProject.isPresent()) {
                return optProject;
            }
            Path parent = filePath.getParent();
            if ("tests".equals(parent.getFileName().toString())) {
                parent = parent.getParent();
            }
            if ("modules".equals(parent.getParent().getFileName().toString()) || "generated".equals(parent.getParent().getFileName().toString())) {
                parent = parent.getParent().getParent();
            }
            if ("generated".equals(parent.getFileName().toString())) {
                parent = parent.getParent();
            }
            return this.projectContext(parent);
        }
        if (isBallerinaTomlChange) {
            if (fileEvent.getType() == FileChangeType.Created) {
                Optional<ProjectContext> optProject = this.sourceRootToProject.entrySet().stream().filter(entry -> ((ProjectContext)entry.getValue()).project().kind() == ProjectKind.SINGLE_FILE_PROJECT && ((Path)entry.getKey()).getParent().equals(filePath.getParent())).findFirst().map(Map.Entry::getValue);
                if (optProject.isEmpty()) {
                    optProject = this.createProjectContext(filePath, LSContextOperation.WS_WF_CHANGED.getName());
                    this.sourceRootToProject.put(optProject.get().project().sourceRoot(), optProject.get());
                }
                return optProject;
            }
            return this.projectContext(filePath.getParent());
        }
        if (isCloudTomlChange || isCompilerPluginTomlChange || isBalToolTomlChange || isDependenciesTomlChange) {
            return this.projectContext(filePath.getParent());
        }
        if (isModuleChange) {
            Path projectRoot = "modules".equals(filePath.getFileName().toString()) || "generated".equals(filePath.getFileName().toString()) ? filePath.getParent() : filePath.getParent().getParent();
            return this.projectContext(projectRoot);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatchedBalSourceChange(Path filePath, FileEvent fileEvent, ProjectContext projectContext) {
        switch (fileEvent.getType()) {
            case Created: {
                this.reloadProject(projectContext, filePath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Changed: {
                if (this.openedDocuments.contains(filePath)) break;
                this.reloadProject(projectContext, filePath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Deleted: {
                Project project = projectContext.project();
                if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                    Path projectRoot = project.sourceRoot();
                    this.sourceRootToProject.remove(projectRoot);
                    this.clientLogger.logTrace(String.format("Operation '%s' {project: '%s' kind: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), projectRoot.toUri().toString(), project.kind().name().toLowerCase(Locale.getDefault())));
                    break;
                }
                Optional<Document> document = this.document(filePath, project, null);
                if (document.isPresent()) {
                    Lock lock = projectContext.lockAndGet();
                    try {
                        Project updatedProj = document.get().module().modify().removeDocument(document.get().documentId()).apply().project();
                        projectContext.setProject(updatedProj);
                        this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                        break;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                Path ballerinaTomlPath = project.sourceRoot().resolve("Ballerina.toml");
                this.reloadProject(projectContext, ballerinaTomlPath, LSContextOperation.WS_WF_CHANGED.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatchedBallerinaTomlChange(Path filePath, FileEvent fileEvent, ProjectContext projectContext) throws WorkspaceDocumentException {
        Project project = projectContext.project();
        switch (fileEvent.getType()) {
            case Created: {
                try {
                    this.updateBallerinaToml(Files.readString(filePath), projectContext, true);
                    break;
                }
                catch (IOException e) {
                    throw new WorkspaceDocumentException("Could not handle Ballerina.toml creation!", (Throwable)e);
                }
            }
            case Changed: {
                if (this.openedDocuments.contains(filePath)) break;
                this.reloadProject(projectContext, filePath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Deleted: {
                if (project.kind() == ProjectKind.BUILD_PROJECT) {
                    Lock lock = projectContext.lockAndGet();
                    try {
                        Path projectRoot = project.sourceRoot();
                        this.sourceRootToProject.remove(projectRoot);
                        this.clientLogger.logTrace(String.format("Operation '%s' {project: '%s', kind: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), project.sourceRoot().toUri().toString(), projectContext.project().kind().name().toLowerCase(Locale.getDefault())));
                        break;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new WorkspaceDocumentException("Invalid operation, cannot delete Ballerina.toml!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatchedDependenciesTomlChange(Path filePath, FileEvent fileEvent, ProjectContext projectContext) throws WorkspaceDocumentException {
        switch (fileEvent.getType()) {
            case Created: {
                try {
                    this.updateDependenciesToml(Files.readString(filePath), projectContext, true);
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} created", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    break;
                }
                catch (IOException e) {
                    throw new WorkspaceDocumentException("Could not handle Dependencies.toml creation!", (Throwable)e);
                }
            }
            case Changed: {
                if (this.openedDocuments.contains(filePath)) break;
                this.reloadProject(projectContext, filePath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Deleted: {
                Lock lock = projectContext.lockAndGet();
                try {
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    Path ballerinaTomlFile = filePath.getParent().resolve("Ballerina.toml");
                    this.createProjectContext(ballerinaTomlFile, LSContextOperation.WS_WF_CHANGED.getName()).ifPresent(newProjectContext -> projectContext.setProject(newProjectContext.project()));
                    break;
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatchedCloudTomlChange(Path filePath, FileEvent fileEvent, ProjectContext projectContext) throws WorkspaceDocumentException {
        switch (fileEvent.getType()) {
            case Created: {
                try {
                    this.updateCloudToml(Files.readString(filePath), projectContext, true);
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} created", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    break;
                }
                catch (IOException e) {
                    throw new WorkspaceDocumentException("Could not handle Cloud.toml creation!", (Throwable)e);
                }
            }
            case Changed: {
                if (this.openedDocuments.contains(filePath)) break;
                this.reloadProject(projectContext, filePath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Deleted: {
                Lock lock = projectContext.lockAndGet();
                try {
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    Path ballerinaTomlFile = filePath.getParent().resolve("Ballerina.toml");
                    this.createProjectContext(ballerinaTomlFile, LSContextOperation.WS_WF_CHANGED.getName()).ifPresent(newProject -> projectContext.setProject(newProject.project));
                    break;
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatchedCompilerPluginTomlChange(Path filePath, FileEvent fileEvent, ProjectContext projectContext) throws WorkspaceDocumentException {
        switch (fileEvent.getType()) {
            case Created: {
                try {
                    this.updateCompilerPluginToml(Files.readString(filePath), projectContext, true);
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} created", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    break;
                }
                catch (IOException e) {
                    throw new WorkspaceDocumentException("Could not handle Compiler-plugin.toml creation!", (Throwable)e);
                }
            }
            case Changed: {
                if (this.openedDocuments.contains(filePath)) break;
                this.reloadProject(projectContext, filePath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Deleted: {
                Lock lock = projectContext.lockAndGet();
                try {
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    Path ballerinaTomlFile = filePath.getParent().resolve("Ballerina.toml");
                    this.createProjectContext(ballerinaTomlFile, LSContextOperation.WS_WF_CHANGED.getName()).ifPresent(newProject -> projectContext.setProject(newProject.project()));
                    break;
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWatchedBalToolTomlChange(Path filePath, FileEvent fileEvent, ProjectContext projectContext) throws WorkspaceDocumentException {
        switch (fileEvent.getType()) {
            case Created: {
                try {
                    this.updateBalToolToml(Files.readString(filePath), projectContext, true);
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} created", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    break;
                }
                catch (IOException e) {
                    throw new WorkspaceDocumentException("Could not handle BalTool.toml creation!", (Throwable)e);
                }
            }
            case Changed: {
                if (this.openedDocuments.contains(filePath)) break;
                this.reloadProject(projectContext, filePath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Deleted: {
                Lock lock = projectContext.lockAndGet();
                try {
                    this.clientLogger.logTrace(String.format("Operation '%s' {fileUri: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), fileEvent.getUri()));
                    Path ballerinaTomlFile = filePath.getParent().resolve("Ballerina.toml");
                    this.createProjectContext(ballerinaTomlFile, LSContextOperation.WS_WF_CHANGED.getName()).ifPresent(newProject -> projectContext.setProject(newProject.project()));
                    break;
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private void handleWatchedModuleChange(Path filePath, FileEvent fileEvent, ProjectContext projectContext) {
        String fileName = filePath.getFileName().toString();
        switch (fileEvent.getType()) {
            case Created: {
                this.clientLogger.logTrace(String.format("Operation '%s' {module: '%s', uri: '%s'} created", LSContextOperation.WS_WF_CHANGED.getName(), fileName, filePath.toUri().toString()));
                Path ballerinaTomlPath = filePath.getParent().getParent().resolve("Ballerina.toml");
                this.reloadProject(projectContext, ballerinaTomlPath, LSContextOperation.WS_WF_CHANGED.getName());
                break;
            }
            case Deleted: {
                if ("modules".equals(filePath.getFileName().toString())) {
                    Path tomlPath = filePath.getParent().resolve("Ballerina.toml");
                    this.clientLogger.logTrace(String.format("Operation '%s' {uri: '%s'} removed all modules", LSContextOperation.WS_WF_CHANGED.getName(), filePath.toUri().toString()));
                    this.reloadProject(projectContext, tomlPath, LSContextOperation.WS_WF_CHANGED.getName());
                    break;
                }
                Path tomlPath = filePath.getParent().getParent().resolve("Ballerina.toml");
                this.clientLogger.logTrace(String.format("Operation '%s' {module: '%s', uri: '%s'} removed", LSContextOperation.WS_WF_CHANGED.getName(), fileName, filePath.toUri().toString()));
                this.reloadProject(projectContext, tomlPath, LSContextOperation.WS_WF_CHANGED.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBallerinaToml(String content, ProjectContext projectContext, boolean createIfNotExists) throws WorkspaceDocumentException {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional ballerinaToml = projectContext.project().currentPackage().ballerinaToml();
            if (ballerinaToml.isEmpty()) {
                if (createIfNotExists) {
                    if (projectContext.project().kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                        this.sourceRootToProject.remove(projectContext.project().sourceRoot());
                        Path ballerinaTomlFilePath = projectContext.project().sourceRoot().getParent().resolve("Ballerina.toml");
                        Optional<ProjectContext> newProjectContext = this.createProjectContext(ballerinaTomlFilePath, LSContextOperation.WS_WF_CHANGED.getName());
                        if (newProjectContext.isEmpty()) {
                            throw new WorkspaceDocumentException("Invalid operation, cannot create Ballerina.toml!");
                        }
                        projectContext = newProjectContext.get();
                        this.sourceRootToProject.put(projectContext.project().sourceRoot(), projectContext);
                        return;
                    }
                    throw new WorkspaceDocumentException("Invalid operation, cannot create Ballerina.toml!");
                }
                throw new WorkspaceDocumentException("Ballerina.toml does not exists!");
            }
            BallerinaToml updatedToml = ((BallerinaToml)ballerinaToml.get()).modify().withContent(content).apply();
            projectContext.setProject(updatedToml.packageInstance().project());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDependenciesToml(String content, ProjectContext projectContext, boolean createIfNotExists) throws WorkspaceDocumentException {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional dependenciesToml = projectContext.project().currentPackage().dependenciesToml();
            if (dependenciesToml.isEmpty()) {
                if (createIfNotExists) {
                    DocumentConfig documentConfig = DocumentConfig.from((DocumentId)DocumentId.create((String)"Dependencies.toml", null), (String)content, (String)"Dependencies.toml");
                    Package pkg = projectContext.project().currentPackage().modify().addDependenciesToml(documentConfig).apply();
                    projectContext.setProject(pkg.project());
                    return;
                }
                throw new WorkspaceDocumentException("Dependencies.toml does not exist!");
            }
            DependenciesToml updatedToml = ((DependenciesToml)dependenciesToml.get()).modify().withContent(content).apply();
            projectContext.setProject(updatedToml.packageInstance().project());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCloudToml(String content, ProjectContext projectContext, boolean createIfNotExists) throws WorkspaceDocumentException {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional cloudToml = projectContext.project().currentPackage().cloudToml();
            if (cloudToml.isEmpty()) {
                if (createIfNotExists) {
                    DocumentConfig documentConfig = DocumentConfig.from((DocumentId)DocumentId.create((String)"Cloud.toml", null), (String)content, (String)"Cloud.toml");
                    Package pkg = projectContext.project().currentPackage().modify().addCloudToml(documentConfig).apply();
                    projectContext.setProject(pkg.project());
                    return;
                }
                throw new WorkspaceDocumentException("Cloud.toml does not exists!");
            }
            CloudToml updatedToml = ((CloudToml)cloudToml.get()).modify().withContent(content).apply();
            projectContext.setProject(updatedToml.packageInstance().project());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompilerPluginToml(String content, ProjectContext projectContext, boolean createIfNotExists) throws WorkspaceDocumentException {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional compilerPluginToml = projectContext.project().currentPackage().compilerPluginToml();
            if (compilerPluginToml.isEmpty()) {
                if (createIfNotExists) {
                    DocumentConfig documentConfig = DocumentConfig.from((DocumentId)DocumentId.create((String)"CompilerPlugin.toml", null), (String)content, (String)"CompilerPlugin.toml");
                    Package pkg = projectContext.project().currentPackage().modify().addCompilerPluginToml(documentConfig).apply();
                    projectContext.setProject(pkg.project());
                    return;
                }
                throw new WorkspaceDocumentException("CompilerPlugin.toml does not exists!");
            }
            CompilerPluginToml updatedToml = ((CompilerPluginToml)compilerPluginToml.get()).modify().withContent(content).apply();
            projectContext.setProject(updatedToml.packageInstance().project());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBalToolToml(String content, ProjectContext projectContext, boolean createIfNotExists) throws WorkspaceDocumentException {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional balToolToml = projectContext.project().currentPackage().balToolToml();
            if (balToolToml.isEmpty()) {
                if (createIfNotExists) {
                    DocumentConfig documentConfig = DocumentConfig.from((DocumentId)DocumentId.create((String)"BalTool.toml", null), (String)content, (String)"BalTool.toml");
                    Package pkg = projectContext.project().currentPackage().modify().addBalToolToml(documentConfig).apply();
                    projectContext.setProject(pkg.project());
                    return;
                }
                throw new WorkspaceDocumentException("BalTool.toml does not exists!");
            }
            BalToolToml updatedToml = ((BalToolToml)balToolToml.get()).modify().withContent(content).apply();
            projectContext.setProject(updatedToml.packageInstance().project());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBalDocument(Path filePath, String content, ProjectContext projectContext) throws WorkspaceDocumentException {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional<Document> document = this.document(filePath, projectContext.project(), null);
            if (document.isEmpty()) {
                throw new WorkspaceDocumentException("Document does not exist in path: " + filePath.toString());
            }
            document.get().modify().withContent(content).apply();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBalDocument(Path filePath, String content, ProjectContext projectContext) throws WorkspaceDocumentException {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional<ProjectContext> newProjectContext = this.createProjectContext(filePath, LSContextOperation.TXT_DID_OPEN.getName());
            if (newProjectContext.isEmpty()) {
                throw new WorkspaceDocumentException("Could not find the project for file path: " + filePath.toString());
            }
            Optional<Document> document = this.document(filePath, newProjectContext.get().project(), null);
            if (document.isEmpty()) {
                projectContext.setProjectCrashed(true);
                throw new WorkspaceDocumentException("Could not create a new document for file path: " + filePath.toString());
            }
            Document updatedDoc = document.get().modify().withContent(content).apply();
            projectContext.setProject(updatedDoc.module().project());
        }
        finally {
            lock.unlock();
        }
    }

    public void didClose(Path filePath, DidCloseTextDocumentParams params) {
        this.openedDocuments.remove(filePath);
        Optional<Project> project = this.project(filePath);
        if (project.isEmpty()) {
            return;
        }
        if (project.get().kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            Path projectRoot = project.get().sourceRoot();
            this.sourceRootToProject.remove(projectRoot);
            this.clientLogger.logTrace("Operation '" + LSContextOperation.TXT_DID_CLOSE.getName() + "' {project: '" + projectRoot.toUri().toString() + "' kind: '" + project.get().kind().name().toLowerCase(Locale.getDefault()) + "'} removed");
        }
    }

    private Path computeProjectRoot(Path path) {
        return (Path)this.computeProjectKindAndProjectRoot(path).getRight();
    }

    private Pair<ProjectKind, Path> computeProjectKindAndProjectRoot(Path path) {
        if (ProjectPaths.isStandaloneBalFile((Path)path)) {
            return new ImmutablePair((Object)ProjectKind.SINGLE_FILE_PROJECT, (Object)path);
        }
        Path tomlPath = ProjectPaths.packageRoot((Path)path).resolve("Ballerina.toml");
        if (Files.exists(tomlPath, new LinkOption[0])) {
            return new ImmutablePair((Object)ProjectKind.BUILD_PROJECT, (Object)ProjectPaths.packageRoot((Path)path));
        }
        return new ImmutablePair((Object)ProjectKind.BALA_PROJECT, (Object)ProjectPaths.packageRoot((Path)path));
    }

    private Optional<ProjectContext> projectContext(Path projectRoot) {
        return Optional.ofNullable(this.sourceRootToProject.get(projectRoot));
    }

    private Optional<ProjectContext> createProjectContext(Path filePath, String operationName) {
        Project project = this.createProject(filePath, operationName);
        if (project == null) {
            return Optional.empty();
        }
        return Optional.of(ProjectContext.from(project));
    }

    private Project createProject(Path filePath, String operationName) {
        Pair<ProjectKind, Path> projectKindAndProjectRootPair = this.computeProjectKindAndProjectRoot(filePath);
        ProjectKind projectKind = (ProjectKind)projectKindAndProjectRootPair.getLeft();
        Path projectRoot = (Path)projectKindAndProjectRootPair.getRight();
        try {
            Object project;
            BuildOptions options = BuildOptions.builder().setOffline(Boolean.valueOf(CommonUtil.COMPILE_OFFLINE)).setSticky(Boolean.valueOf(true)).build();
            if (projectKind == ProjectKind.BUILD_PROJECT) {
                project = BuildProject.load((Path)projectRoot, (BuildOptions)options);
                if (project.buildOptions().optimizeDependencyCompilation()) {
                    BuildOptions newOptions = BuildOptions.builder().setOffline(Boolean.valueOf(CommonUtil.COMPILE_OFFLINE)).setSticky(Boolean.valueOf(false)).build();
                    project = BuildProject.load((Path)projectRoot, (BuildOptions)newOptions);
                }
            } else {
                project = projectKind == ProjectKind.SINGLE_FILE_PROJECT ? SingleFileProject.load((Path)projectRoot, (BuildOptions)options) : ProjectLoader.loadProject((Path)projectRoot, (BuildOptions)options);
            }
            this.clientLogger.logTrace("Operation '" + operationName + "' {project: '" + projectRoot.toUri().toString() + "' kind: '" + project.kind().name().toLowerCase(Locale.getDefault()) + "'} created");
            return project;
        }
        catch (ProjectException e) {
            this.projectContext(projectRoot).ifPresent(projectContext -> projectContext.setProjectCrashed(true));
            this.clientLogger.notifyUser("Project load failed: " + e.getMessage(), e);
            this.clientLogger.logError(LSContextOperation.CREATE_PROJECT, "Operation '" + operationName + "' {project: '" + projectRoot.toUri().toString() + "' kind: '" + projectKind.name().toLowerCase(Locale.getDefault()) + "'} failed", e, new TextDocumentIdentifier(filePath.toUri().toString()), new Position[0]);
            return null;
        }
    }

    private Optional<Document> document(Path filePath, Project project, @Nullable CancelChecker cancelChecker) {
        if (cancelChecker != null) {
            cancelChecker.isCanceled();
        }
        try {
            DocumentId documentId = project.documentId(filePath);
            Module module = project.currentPackage().module(documentId.moduleId());
            return Optional.of(module.document(documentId));
        }
        catch (ProjectException e) {
            return Optional.empty();
        }
    }

    private boolean hasDocumentOrToml(Path filePath, Project project) {
        String fileName;
        return switch (fileName = Optional.of(filePath.getFileName()).get().toString()) {
            case "Ballerina.toml" -> project.currentPackage().ballerinaToml().isPresent();
            case "Cloud.toml" -> project.currentPackage().cloudToml().isPresent();
            case "CompilerPlugin.toml" -> project.currentPackage().compilerPluginToml().isPresent();
            case "BalTool.toml" -> project.currentPackage().balToolToml().isPresent();
            case "Dependencies.toml" -> project.currentPackage().dependenciesToml().isPresent();
            default -> fileName.endsWith(".bal") ? this.document(filePath, project, null).isPresent() : false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadProject(ProjectContext projectContext, Path filePath, String operationName) {
        Lock lock = projectContext.lockAndGet();
        try {
            Optional<ProjectContext> newProjectContext = this.createProjectContext(filePath, operationName);
            if (newProjectContext.isEmpty()) {
                return;
            }
            projectContext.setProject(newProjectContext.get().project());
        }
        finally {
            lock.unlock();
        }
    }

    private ProjectContext createOrGetProjectPair(Path filePath, String operationName) throws WorkspaceDocumentException {
        return this.createOrGetProjectPair(filePath, operationName, false);
    }

    private ProjectContext createOrGetProjectPair(Path filePath, String operationName, boolean isSourceChange) throws WorkspaceDocumentException {
        Path projectRoot = this.projectRoot(filePath);
        ProjectContext projectContext = this.sourceRootToProject.get(projectRoot);
        if (!(projectContext == null || projectContext.isProjectCrashed() && isSourceChange)) {
            return projectContext;
        }
        Optional<ProjectContext> newProjectContext = this.createProjectContext(projectRoot, operationName);
        if (newProjectContext.isEmpty()) {
            throw new WorkspaceDocumentException("Cannot find the project of uri: " + filePath.toString());
        }
        if (projectContext == null) {
            projectContext = newProjectContext.get();
            this.sourceRootToProject.put(projectRoot, projectContext);
            return projectContext;
        }
        projectContext.setProject(newProjectContext.get().project());
        projectContext.setProjectCrashed(false);
        return projectContext;
    }

    private Optional<Path> findProjectRoot(Path filePath) {
        if (filePath != null) {
            if ((filePath = filePath.toAbsolutePath().normalize()).toFile().isDirectory() && (this.hasBallerinaToml(filePath) || this.hasPackageJson(filePath))) {
                return Optional.of(filePath);
            }
            return this.findProjectRoot(filePath.getParent());
        }
        return Optional.empty();
    }

    private Optional<ProjectContext> getProjectOfWatchedFileChange(Path filePath, FileEvent fileEvent) {
        String fileName = filePath.getFileName().toString();
        boolean isBallerinaSourceChange = fileName.endsWith(".bal");
        boolean isBallerinaTomlChange = filePath.endsWith("Ballerina.toml");
        boolean isDependenciesTomlChange = filePath.endsWith("Dependencies.toml");
        boolean isCloudTomlChange = filePath.endsWith("Cloud.toml");
        boolean isCompilerPluginTomlChange = filePath.endsWith("CompilerPlugin.toml");
        boolean isBalToolTomlChange = filePath.endsWith("BalTool.toml");
        boolean isModuleChange = filePath.toFile().isDirectory() && filePath.getParent().endsWith("modules") || filePath.getParent().endsWith("generated") || fileEvent.getType() == FileChangeType.Deleted && !isBallerinaSourceChange && !isBallerinaTomlChange && !isCloudTomlChange && !isDependenciesTomlChange && !isCompilerPluginTomlChange && !isBalToolTomlChange;
        return this.projectOfWatchedFileChange(filePath, fileEvent, isBallerinaSourceChange, isBallerinaTomlChange, isDependenciesTomlChange, isCloudTomlChange, isCompilerPluginTomlChange, isBalToolTomlChange, isModuleChange);
    }

    private boolean hasBallerinaToml(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        return absFilePath.resolve("Ballerina.toml").toFile().exists();
    }

    private boolean hasPackageJson(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        return absFilePath.resolve("package.json").toFile().exists();
    }

    private static boolean isError(Diagnostic diagnostic) {
        return diagnostic.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR);
    }

    private static class SourceRootToProjectMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 19900410L;
        private final transient Map<Path, Path> cache;

        public SourceRootToProjectMap(Map<Path, Path> pathToSourceRootCache) {
            this.cache = pathToSourceRootCache;
        }

        @Override
        public V put(K key, V value) {
            V old = super.put(key, value);
            this.cache.clear();
            return old;
        }

        @Override
        public V remove(Object key) {
            Object result = super.remove(key);
            this.cache.clear();
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            this.cache.clear();
        }
    }

    public static class ProjectContext {
        private final Lock lock;
        private Project project;
        private boolean compilationCrashed;
        private Process process;
        private boolean projectCrashed;

        private ProjectContext(Project project, Lock lock) {
            this.project = project;
            this.lock = lock;
            this.compilationCrashed = false;
        }

        public static ProjectContext from(Project project) {
            return new ProjectContext(project, new ReentrantLock(true));
        }

        public static ProjectContext from(Project project, Lock lock) {
            return new ProjectContext(project, lock);
        }

        public Lock locker() {
            return this.lock;
        }

        public Lock lockAndGet() {
            this.lock.lock();
            return this.lock;
        }

        public Project project() {
            return this.project;
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public boolean compilationCrashed() {
            return this.compilationCrashed;
        }

        public void setCompilationCrashed(boolean compilationCrashed) {
            this.compilationCrashed = compilationCrashed;
        }

        public void setProjectCrashed(boolean projectCrashed) {
            this.projectCrashed = projectCrashed;
        }

        public boolean isProjectCrashed() {
            return this.projectCrashed;
        }

        public Optional<Process> process() {
            return Optional.ofNullable(this.process);
        }

        public void setProcess(Process process) {
            this.process = process;
        }

        public void removeProcess() {
            this.process = null;
        }
    }
}

