/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpResource;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.ValueCreatorUtils;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.Locale;
import java.util.Objects;

public class HttpCallableUnitCallback {
    private static final String ILLEGAL_FUNCTION_INVOKED = "illegal return: response has already been sent";
    private final BObject caller;
    private final Runtime runtime;
    private final String returnMediaType;
    private final BMap cacheConfig;
    private final HttpCarbonMessage requestMessage;
    private final BMap links;
    private final boolean isLastService;

    HttpCallableUnitCallback(HttpCarbonMessage requestMessage, Runtime runtime, HttpResource resource, boolean isLastService) {
        this.requestMessage = requestMessage;
        this.runtime = runtime;
        this.returnMediaType = resource.getReturnMediaType();
        this.cacheConfig = resource.getResponseCacheConfig();
        this.links = resource.getLinks();
        String resourceAccessor = resource.getBalResource().getAccessor().toUpperCase(Locale.getDefault());
        this.caller = this.getCaller(requestMessage, resourceAccessor);
        this.isLastService = isLastService;
    }

    HttpCallableUnitCallback(HttpCarbonMessage requestMessage, Runtime runtime) {
        this.requestMessage = requestMessage;
        this.runtime = runtime;
        this.returnMediaType = null;
        this.cacheConfig = null;
        this.links = null;
        this.caller = this.getCaller(requestMessage, null);
        this.isLastService = false;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    private BObject getCaller(HttpCarbonMessage requestMessage, String resourceAccessor) {
        BObject caller = requestMessage.getProperty("Caller") == null ? ValueCreatorUtils.createCallerObject(requestMessage, resourceAccessor) : (BObject)requestMessage.getProperty("Caller");
        caller.addNativeData("transport_message", (Object)requestMessage);
        requestMessage.setProperty("Caller", caller);
        return caller;
    }

    public void handleResult(Object result) {
        if (this.alreadyResponded(result)) {
            this.stopObserverContext();
            return;
        }
        if (result instanceof BError) {
            this.invokeErrorInterceptors((BError)result, false);
            return;
        }
        if (this.isLastService) {
            this.cleanupRequestMessage();
        }
        this.returnResponse(result);
    }

    private void returnResponse(Object result) {
        Object[] paramFeed = new Object[]{result, Objects.nonNull(this.returnMediaType) ? StringUtils.fromString((String)this.returnMediaType) : null, this.cacheConfig, Objects.nonNull(this.links) && !this.links.isEmpty() ? this.links : null};
        this.invokeBalMethod(paramFeed, "returnResponse");
    }

    private void returnErrorResponse(BError error) {
        Thread.startVirtualThread(() -> {
            Object[] paramFeed = new Object[]{error, this.returnMediaType != null ? StringUtils.fromString((String)this.returnMediaType) : null};
            this.invokeBalMethod(paramFeed, "returnErrorResponse");
        });
    }

    public void invokeBalMethod(Object[] paramFeed, String methodName) {
        try {
            StrandMetadata metaData = new StrandMetadata(true, null);
            this.runtime.callMethod(this.caller, methodName, metaData, paramFeed);
            this.stopObserverContext();
        }
        catch (BError error) {
            this.sendFailureResponse(error);
        }
    }

    public void stopObserverContext() {
        ObserverContext observerContext;
        if (ObserveUtils.isObservabilityEnabled() && (observerContext = (ObserverContext)this.requestMessage.getProperty("observabilityContext")) != null && observerContext.isManuallyClosed()) {
            ObserveUtils.stopObservationWithContext((ObserverContext)observerContext);
        }
    }

    public void handlePanic(BError error) {
        if (error.getType().getName().equals(HttpErrorType.INTERNAL_LISTENER_AUTHN_ERROR.getErrorName()) || error.getType().getName().equals(HttpErrorType.INTERNAL_LISTENER_AUTHZ_ERROR.getErrorName())) {
            this.invokeErrorInterceptors(error, true);
            return;
        }
        this.cleanupRequestMessage();
        this.sendFailureResponse(error);
        System.exit(1);
    }

    public void invokeErrorInterceptors(BError error, boolean isInternalError) {
        if (isInternalError) {
            this.requestMessage.setProperty("INTERNAL_ERROR", true);
        } else {
            this.requestMessage.removeProperty("INTERNAL_ERROR");
        }
        this.requestMessage.setProperty("INTERCEPTOR_SERVICE_ERROR", (Object)error);
        this.returnErrorResponse(error);
    }

    public void sendFailureResponse(BError error) {
        this.stopObserverContext();
        HttpUtil.handleFailure(this.requestMessage, error);
    }

    public void cleanupRequestMessage() {
        this.requestMessage.waitAndReleaseAllEntities();
    }

    private boolean alreadyResponded(Object result) {
        try {
            HttpUtil.methodInvocationCheck(this.requestMessage, 0, ILLEGAL_FUNCTION_INVOKED);
        }
        catch (BError bError) {
            if (result != null) {
                bError.printStackTrace();
                System.err.println("warning: [ballerina/http] " + bError.getMessage());
            }
            return true;
        }
        return false;
    }
}

