/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.client.actions.AbstractHTTPAction;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;

public class Forward
extends AbstractHTTPAction {
    public static Object forward(Environment env, BObject httpClient, BString path, BObject requestObj) {
        String url = (String)httpClient.getNativeData("url");
        HttpCarbonMessage outboundRequestMsg = Forward.createOutboundRequestMsg(url, path.getValue(), requestObj);
        HttpClientConnector clientConnector = (HttpClientConnector)httpClient.getNativeData("Client");
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            DataContext dataContext = new DataContext(env, balFuture, clientConnector, requestObj, outboundRequestMsg);
            Forward.executeNonBlockingAction(dataContext, false);
            return ExternUtils.getResult(balFuture);
        });
    }

    protected static HttpCarbonMessage createOutboundRequestMsg(String serviceUri, String path, BObject requestObj) {
        if (requestObj.getNativeData("Request") == null && !HttpUtil.isEntityDataSourceAvailable(requestObj)) {
            throw HttpUtil.createHttpError("invalid inbound request parameter", HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        HttpCarbonMessage outboundRequestMsg = HttpUtil.getCarbonMsg(requestObj, HttpUtil.createHttpCarbonMessage(true));
        if (HttpUtil.isEntityDataSourceAvailable(requestObj)) {
            HttpUtil.enrichOutboundMessage(outboundRequestMsg, requestObj);
            Forward.prepareOutboundRequest(serviceUri, path, outboundRequestMsg, HttpUtil.checkRequestBodySizeHeadersAvailability(outboundRequestMsg) == false, Forward.isHostHeaderSet(requestObj));
            outboundRequestMsg.setHttpMethod(requestObj.get(HttpConstants.HTTP_REQUEST_METHOD).toString());
        } else {
            Forward.prepareOutboundRequest(serviceUri, path, outboundRequestMsg, HttpUtil.checkRequestBodySizeHeadersAvailability(outboundRequestMsg) == false, Forward.isHostHeaderSet(requestObj));
            String httpVerb = outboundRequestMsg.getHttpMethod();
            outboundRequestMsg.setHttpMethod(httpVerb.trim().toUpperCase(Locale.getDefault()));
        }
        return outboundRequestMsg;
    }

    private Forward() {
    }
}

