/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.caching;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.client.caching.CacheControlDirective;
import io.ballerina.stdlib.http.api.client.caching.CacheControlParser;
import java.math.BigDecimal;
import java.util.Map;
import java.util.StringJoiner;

public class ResponseCacheControlObj {
    private BObject responseCacheControl;

    public ResponseCacheControlObj(Module bPackage, String objectTypeName) {
        this.responseCacheControl = ValueCreator.createObjectValue((Module)bPackage, (String)objectTypeName, (Object[])new Object[0]);
        this.init();
    }

    public ResponseCacheControlObj(BObject responseCacheControl) {
        this.responseCacheControl = responseCacheControl;
    }

    public BObject getObj() {
        return this.responseCacheControl;
    }

    public void setObj(BObject responseCacheControl) {
        this.responseCacheControl = responseCacheControl;
    }

    public void init() {
        this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_NO_TRANSFORM_FIELD, (Object)true);
        this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_MAX_AGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(-1L)));
        this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_S_MAXAGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(-1L)));
    }

    public void populateStruct(String cacheControlHeaderVal) {
        Map<CacheControlDirective, String> controlDirectives = CacheControlParser.parse(cacheControlHeaderVal);
        controlDirectives.forEach((directive, value) -> {
            switch (directive) {
                case MUST_REVALIDATE: {
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_MUST_REVALIDATE_FIELD, (Object)true);
                    break;
                }
                case NO_CACHE: {
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_NO_CACHE_FIELD, (Object)true);
                    if (value == null) break;
                    value = value.replace("\"", "");
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_NO_CACHE_FIELDS_FIELD, (Object)StringUtils.fromStringArray((String[])value.split(",")));
                    break;
                }
                case NO_STORE: {
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_NO_STORE_FIELD, (Object)true);
                    break;
                }
                case NO_TRANSFORM: {
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_NO_TRANSFORM_FIELD, (Object)true);
                    break;
                }
                case PRIVATE: {
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_IS_PRIVATE_FIELD, (Object)true);
                    if (value == null) break;
                    value = value.replace("\"", "");
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_PRIVATE_FIELDS_FIELD, (Object)StringUtils.fromStringArray((String[])value.split(",")));
                    break;
                }
                case PUBLIC: {
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_IS_PRIVATE_FIELD, (Object)false);
                    break;
                }
                case PROXY_REVALIDATE: {
                    this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_PROXY_REVALIDATE_FIELD, (Object)true);
                    break;
                }
                case MAX_AGE: {
                    try {
                        this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_MAX_AGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Long.parseLong(value))));
                    }
                    catch (NumberFormatException e) {
                        this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_MAX_AGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(0L)));
                    }
                    break;
                }
                case S_MAXAGE: {
                    try {
                        this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_S_MAXAGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Long.parseLong(value))));
                    }
                    catch (NumberFormatException e) {
                        this.responseCacheControl.set(HttpConstants.RES_CACHE_CONTROL_S_MAXAGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(0L)));
                    }
                    break;
                }
            }
        });
    }

    public String buildCacheControlDirectives() {
        StringJoiner directivesBuilder = new StringJoiner(",");
        if (this.getBooleanValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_MUST_REVALIDATE_FIELD)) {
            directivesBuilder.add("must-revalidate");
        }
        if (this.getBooleanValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_NO_CACHE_FIELD)) {
            directivesBuilder.add("no-cache" + this.appendFields((BArray)this.responseCacheControl.get(HttpConstants.RES_CACHE_CONTROL_NO_CACHE_FIELDS_FIELD)));
        }
        if (this.getBooleanValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_NO_STORE_FIELD)) {
            directivesBuilder.add("no-store");
        }
        if (this.getBooleanValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_NO_TRANSFORM_FIELD)) {
            directivesBuilder.add("no-transform");
        }
        if (this.getBooleanValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_IS_PRIVATE_FIELD)) {
            directivesBuilder.add("private" + this.appendFields((BArray)this.responseCacheControl.get(HttpConstants.RES_CACHE_CONTROL_PRIVATE_FIELDS_FIELD)));
        } else {
            directivesBuilder.add("public");
        }
        if (this.getBooleanValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_PROXY_REVALIDATE_FIELD)) {
            directivesBuilder.add("proxy-revalidate");
        }
        if (this.getIntValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_MAX_AGE_FIELD) >= 0L) {
            directivesBuilder.add("max-age=" + String.valueOf(this.responseCacheControl.get(HttpConstants.RES_CACHE_CONTROL_MAX_AGE_FIELD)));
        }
        if (this.getIntValue(this.responseCacheControl, HttpConstants.RES_CACHE_CONTROL_S_MAXAGE_FIELD) >= 0L) {
            directivesBuilder.add("s-maxage=" + String.valueOf(this.responseCacheControl.get(HttpConstants.RES_CACHE_CONTROL_S_MAXAGE_FIELD)));
        }
        return directivesBuilder.toString();
    }

    private String appendFields(BArray values) {
        if (values.size() > 0) {
            StringJoiner joiner = new StringJoiner(",");
            for (int i = 0; i < values.size(); ++i) {
                joiner.add(values.getString((long)i));
            }
            return "=\"" + joiner.toString() + "\"";
        }
        return "";
    }

    private boolean getBooleanValue(BObject responseCacheControl, BString fieldName) {
        return (Boolean)responseCacheControl.get(fieldName);
    }

    private long getIntValue(BObject responseCacheControl, BString fieldName) {
        try {
            String value = responseCacheControl.get(fieldName).toString();
            return Long.parseLong(value.split("\\.")[0]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

