/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.uri.URIUtil;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.MimeConstants;
import java.util.Objects;

public class ExternRequest {
    private static final MapType mapType = TypeCreator.createMapType((Type)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING));

    public static BObject createNewEntity(BObject requestObj) {
        return HttpUtil.createNewEntity(requestObj);
    }

    public static void setEntity(BObject requestObj, BObject entityObj) {
        HttpUtil.setEntity(requestObj, entityObj, true, true);
    }

    public static void setEntityAndUpdateContentTypeHeader(BObject requestObj, BObject entityObj) {
        HttpUtil.setEntity(requestObj, entityObj, true, false);
    }

    public static BMap<BString, Object> getQueryParams(BObject requestObj) {
        try {
            Object queryParams = requestObj.getNativeData("queryParamMap");
            if (queryParams != null) {
                return (BMap)queryParams;
            }
            HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)requestObj.getNativeData("transport_message");
            BMap params = ValueCreator.createMapValue((MapType)mapType);
            Object rawQueryString = httpCarbonMessage.getProperty("RAW_QUERY_STR");
            if (rawQueryString != null) {
                URIUtil.populateQueryParamMap((String)rawQueryString, (BMap<BString, Object>)params);
            }
            requestObj.addNativeData("queryParamMap", (Object)params);
            return params;
        }
        catch (Exception e) {
            throw HttpUtil.createHttpError("error while retrieving query param from message: " + e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
    }

    public static BMap<BString, Object> getMatrixParams(BObject requestObj, BString path) {
        HttpCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(requestObj, null);
        return URIUtil.getMatrixParamsMap(path.getValue(), httpCarbonMessage);
    }

    public static Object getEntity(BObject requestObj) {
        return HttpUtil.getEntity(requestObj, true, true, true);
    }

    public static BObject getEntityWithoutBodyAndHeaders(BObject requestObj) {
        return HttpUtil.getEntity(requestObj, true, false, false);
    }

    public static BObject getEntityWithBodyAndWithoutHeaders(BObject requestObj) {
        return HttpUtil.getEntity(requestObj, true, true, false);
    }

    public static boolean checkEntityBodyAvailability(BObject requestObj) {
        BObject entityObj = (BObject)requestObj.get(MimeConstants.REQUEST_ENTITY_FIELD);
        return ExternRequest.lengthHeaderCheck(requestObj) || EntityBodyHandler.checkEntityBodyAvailability((BObject)entityObj);
    }

    public static boolean hasMsgDataSource(BObject requestObj) {
        BObject entityObj = (BObject)requestObj.get(MimeConstants.REQUEST_ENTITY_FIELD);
        return Objects.nonNull(EntityBodyHandler.getMessageDataSource((BObject)entityObj));
    }

    private static boolean lengthHeaderCheck(BObject requestObj) {
        Object outboundMsg = requestObj.getNativeData("transport_message");
        if (outboundMsg == null) {
            return false;
        }
        return HttpUtil.checkRequestBodySizeHeadersAvailability((HttpCarbonMessage)outboundMsg);
    }

    private ExternRequest() {
    }
}

