/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import org.ballerinalang.langlib.value.EnsureType;

public final class ExternRequestContext {
    private ExternRequestContext() {
    }

    public static Object getWithType(BObject requestCtx, BString key, BTypedesc targetType) {
        BMap members = requestCtx.getMapValue(HttpConstants.REQUEST_CTX_MEMBERS);
        try {
            Object value = members.getOrThrow((Object)key);
            Object convertedType = EnsureType.ensureType((Object)value, (BTypedesc)targetType);
            if (convertedType instanceof BError) {
                return HttpUtil.createHttpError("type conversion failed for value of key: " + key.getValue(), HttpErrorType.GENERIC_LISTENER_ERROR, (BError)((Object)convertedType));
            }
            return convertedType;
        }
        catch (Exception exp) {
            return HttpUtil.createHttpError("no member found for key: " + key.getValue(), HttpErrorType.GENERIC_LISTENER_ERROR, exp instanceof BError ? (BError)((Object)exp) : null);
        }
    }

    public static Object next(BObject requestCtx) {
        BArray interceptors = ExternRequestContext.getInterceptors(requestCtx);
        if (interceptors != null) {
            if (!ExternRequestContext.isInterceptorService(requestCtx)) {
                return HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_INTERCEPTOR_RETURN_ERROR, "no next service to be returned");
            }
            requestCtx.addNativeData("REQUEST_CONTEXT_NEXT", (Object)true);
            return ExternRequestContext.getNextInterceptor(requestCtx, interceptors);
        }
        String message = "request context object does not contain the configured interceptors";
        return HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_INTERCEPTOR_RETURN_ERROR, message);
    }

    private static Object getNextInterceptor(BObject requestCtx, BArray interceptors) {
        String requiredInterceptorType = (String)requestCtx.getNativeData("INTERCEPTOR_SERVICE_TYPE");
        Object interceptorToReturn = requestCtx.getNativeData("TARGET_SERVICE");
        int interceptorIndex = ExternRequestContext.getInterceptorIndex(requestCtx, requiredInterceptorType);
        while (0 <= interceptorIndex && interceptorIndex < interceptors.size()) {
            Object interceptor = interceptors.get((long)interceptorIndex);
            String interceptorType = HttpUtil.getInterceptorServiceType((BObject)interceptor);
            if (interceptorType.equals(requiredInterceptorType)) {
                interceptorToReturn = interceptor;
                break;
            }
            if (requiredInterceptorType.equals("RequestInterceptor")) {
                ++interceptorIndex;
                continue;
            }
            --interceptorIndex;
        }
        if (interceptorIndex > interceptors.size()) {
            return HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_INTERCEPTOR_RETURN_ERROR, "no next service to be returned");
        }
        if (interceptorIndex < 0) {
            requestCtx.addNativeData("RESPONSE_INTERCEPTOR_INDEX", (Object)-1);
            return null;
        }
        ExternRequestContext.updateInterceptorIndex(requestCtx, requiredInterceptorType, interceptorIndex);
        return interceptorToReturn;
    }

    private static int getInterceptorIndex(BObject requestCtx, String nextInterceptorType) {
        int interceptorIndex = nextInterceptorType.equals("RequestInterceptor") ? (Integer)requestCtx.getNativeData("REQUEST_INTERCEPTOR_INDEX") + 1 : (Integer)requestCtx.getNativeData("RESPONSE_INTERCEPTOR_INDEX") - 1;
        return interceptorIndex;
    }

    private static void updateInterceptorIndex(BObject requestCtx, String nextInterceptorType, int interceptorId) {
        if (nextInterceptorType.equals("RequestInterceptor")) {
            requestCtx.addNativeData("REQUEST_INTERCEPTOR_INDEX", (Object)interceptorId);
        } else {
            requestCtx.addNativeData("RESPONSE_INTERCEPTOR_INDEX", (Object)interceptorId);
        }
    }

    private static boolean isInterceptorService(BObject requestCtx) {
        return requestCtx.getNativeData("INTERCEPTOR_SERVICE") != null && (Boolean)requestCtx.getNativeData("INTERCEPTOR_SERVICE") != false;
    }

    private static BArray getInterceptors(BObject requestCtx) {
        return requestCtx.getNativeData("INTERCEPTORS") == null ? null : (BArray)requestCtx.getNativeData("INTERCEPTORS");
    }
}

