/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.ValueCreatorUtils;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.api.nativeimpl.StatusCodeBindingException;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ExternResponseProcessor {
    private static final String NO_HEADER_VALUE_ERROR_MSG = "no header value found for '%s'";
    private static final String HEADER_BINDING_FAILED_ERROR_MSG = "header binding failed for parameter: '%s'";
    private static final String HEADER_BINDING_FAILED = "header binding failed";
    private static final String UNSUPPORTED_HEADERS_TYPE = "unsupported headers type: %s";
    private static final String UNSUPPORTED_STATUS_CODE = "unsupported status code: %d";
    private static final String INCOMPATIBLE_TYPE_FOUND_FOR_RESPONSE = "incompatible type: %s found for the response with status code: %d";
    private static final String MEDIA_TYPE_BINDING_FAILED = "media-type binding failed";
    private static final String APPLICATION_RES_ERROR_CREATION_FAILED = "http:ApplicationResponseError creation failed";
    private static final String STATUS_CODE_RES_CREATION_FAILED = "http:StatusCodeResponse creation failed";
    private static final String GET_STATUS_CODE_RESPONSE_BINDING_ERROR = "getStatusCodeResponseBindingError";
    private static final String GET_STATUS_CODE_RESPONSE_DATA_BINDING_ERROR = "getStatusCodeResponseDataBindingError";
    private static final String BUILD_STATUS_CODE_RESPONSE = "buildStatusCodeResponse";
    private static final Map<String, String> STATUS_CODE_OBJS = new HashMap<String, String>();
    private static final String DEFAULT_STATUS = "DefaultStatus";
    private static final String DEFAULT = "default";
    private static final String HEADER = "HEADER";
    private static final String MEDIA_TYPE = "MEDIA_TYPE";
    private static final String GENERIC = "GENERIC";

    private ExternResponseProcessor() {
    }

    public static Object processResponse(Environment env, BObject response, BTypedesc targetType, boolean requireValidation, boolean requireLaxDataBinding) {
        return ExternResponseProcessor.getResponseWithType(response, targetType.getDescribingType(), requireValidation, requireLaxDataBinding, env);
    }

    public static Object buildStatusCodeResponse(BTypedesc statusCodeResponseTypeDesc, BObject status, BMap headers, Object body, Object mediaType) {
        Type type = statusCodeResponseTypeDesc.getDescribingType();
        if (type instanceof RecordType) {
            RecordType statusCodeRecordType = (RecordType)type;
            BMap statusCodeRecord = ValueCreator.createRecordValue((RecordType)statusCodeRecordType);
            statusCodeRecord.put((Object)StringUtils.fromString((String)"status"), (Object)status);
            statusCodeRecord.put((Object)StringUtils.fromString((String)"headers"), (Object)headers);
            if (statusCodeRecordType.getFields().containsKey("mediaType")) {
                statusCodeRecord.put((Object)StringUtils.fromString((String)"mediaType"), mediaType);
            }
            if (statusCodeRecordType.getFields().containsKey("body")) {
                statusCodeRecord.put((Object)StringUtils.fromString((String)"body"), body);
            }
            return statusCodeRecord;
        }
        return HttpUtil.createHttpError(STATUS_CODE_RES_CREATION_FAILED, HttpErrorType.CLIENT_ERROR);
    }

    private static Object getResponseWithType(BObject response, Type targetType, boolean requireValidation, boolean requireLaxDataBinding, Environment env) {
        Type type;
        long responseStatusCode = ExternResponseProcessor.getStatusCode(response);
        Optional<Type> statusCodeResponseType = ExternResponseProcessor.getSpecificStatusCodeResponseType(targetType, Long.toString(responseStatusCode));
        if (statusCodeResponseType.isEmpty()) {
            statusCodeResponseType = ExternResponseProcessor.getDefaultStatusCodeResponseType(targetType);
        }
        if (statusCodeResponseType.isPresent() && (type = TypeUtils.getImpliedType((Type)statusCodeResponseType.get())) instanceof RecordType) {
            RecordType statusCodeRecordType = (RecordType)type;
            try {
                return ExternResponseProcessor.generateStatusCodeResponseType(response, requireValidation, requireLaxDataBinding, env, statusCodeRecordType, responseStatusCode);
            }
            catch (StatusCodeBindingException exp) {
                return ExternResponseProcessor.getStatusCodeResponseDataBindingError(env, response, exp.getMessage(), exp.getBError(), ExternResponseProcessor.isDefaultStatusCodeResponseType(statusCodeRecordType), exp.getErrorType());
            }
        }
        String reasonPhrase = String.format(INCOMPATIBLE_TYPE_FOUND_FOR_RESPONSE, targetType.getName(), responseStatusCode);
        return ExternResponseProcessor.getStatusCodeResponseBindingError(env, response, reasonPhrase);
    }

    private static long getStatusCode(BObject response) {
        return response.getIntValue(StringUtils.fromString((String)"statusCode"));
    }

    private static Object generateStatusCodeResponseType(BObject response, boolean requireValidation, boolean requireLaxDataBinding, Environment env, RecordType statusCodeRecordType, long responseStatusCode) throws StatusCodeBindingException {
        String statusCodeObjName = STATUS_CODE_OBJS.get(Long.toString(responseStatusCode));
        if (Objects.isNull(statusCodeObjName)) {
            if (ExternResponseProcessor.isDefaultStatusCodeResponseType(statusCodeRecordType)) {
                statusCodeObjName = DEFAULT_STATUS;
            } else {
                throw new StatusCodeBindingException(GENERIC, String.format(UNSUPPORTED_STATUS_CODE, responseStatusCode));
            }
        }
        Object status = statusCodeObjName.equals(DEFAULT_STATUS) ? ValueCreatorUtils.createDefaultStatusCodeObject(responseStatusCode) : ValueCreatorUtils.createStatusCodeObject(statusCodeObjName);
        Object headers = ExternResponseProcessor.getHeaders(response, requireValidation, statusCodeRecordType);
        if (headers instanceof BError) {
            return headers;
        }
        Object mediaType = null;
        if (statusCodeRecordType.getFields().containsKey("mediaType")) {
            mediaType = ExternResponseProcessor.getMediaType(response, requireValidation, statusCodeRecordType);
        }
        Type payloadType = null;
        if (statusCodeRecordType.getFields().containsKey("body")) {
            payloadType = ((Field)statusCodeRecordType.getFields().get("body")).getFieldType();
        }
        try {
            return env.getRuntime().callMethod(response, BUILD_STATUS_CODE_RESPONSE, null, new Object[]{Objects.isNull(payloadType) ? null : ValueCreator.createTypedescValue((Type)payloadType), ValueCreator.createTypedescValue((Type)statusCodeRecordType), requireValidation, requireLaxDataBinding, status, headers, mediaType, ExternResponseProcessor.isDefaultStatusCodeResponseType(statusCodeRecordType)});
        }
        catch (BError error) {
            return HttpUtil.createHttpError(STATUS_CODE_RES_CREATION_FAILED, HttpErrorType.STATUS_CODE_RESPONSE_BINDING_ERROR, error);
        }
        catch (Throwable throwable) {
            return HttpUtil.createHttpError(STATUS_CODE_RES_CREATION_FAILED, HttpErrorType.STATUS_CODE_RESPONSE_BINDING_ERROR, ErrorCreator.createError((Throwable)throwable));
        }
    }

    private static Object getHeaders(BObject response, boolean requireValidation, RecordType statusCodeRecordType) {
        Type headersType = ((Field)statusCodeRecordType.getFields().get("headers")).getFieldType();
        return ExternResponseProcessor.getHeadersMap(response, headersType, requireValidation);
    }

    private static Object getMediaType(BObject response, boolean requireValidation, RecordType statusCodeRecordType) throws StatusCodeBindingException {
        Type mediaTypeType = ((Field)statusCodeRecordType.getFields().get("mediaType")).getFieldType();
        return ExternResponseProcessor.getMediaType(response, mediaTypeType, requireValidation);
    }

    private static Object getMediaType(BObject response, Type mediaTypeType, boolean requireValidation) throws StatusCodeBindingException {
        String contentType = ExternResponseProcessor.getContentType(response);
        if (Objects.isNull(contentType)) {
            return null;
        }
        try {
            Object convertedValue = ValueUtils.convert((Object)StringUtils.fromString((String)contentType), (Type)mediaTypeType);
            return ExternResponseProcessor.validateConstraints(requireValidation, convertedValue, mediaTypeType, HttpErrorType.MEDIA_TYPE_VALIDATION_CLIENT_ERROR, MEDIA_TYPE_BINDING_FAILED, MEDIA_TYPE);
        }
        catch (BError conversionError) {
            throw new StatusCodeBindingException(MEDIA_TYPE, MEDIA_TYPE_BINDING_FAILED, conversionError);
        }
    }

    private static String getContentType(BObject response) {
        HttpHeaders httpHeaders = (HttpHeaders)response.getNativeData("http_headers");
        return httpHeaders.get("Content-Type");
    }

    private static Object getHeadersMap(BObject response, Type headersType, boolean requireValidation) throws StatusCodeBindingException {
        Object headerMap;
        HttpHeaders httpHeaders = (HttpHeaders)response.getNativeData("http_headers");
        Type headersImpliedType = TypeUtils.getImpliedType((Type)headersType);
        if (headersImpliedType.getTag() == 53) {
            headersImpliedType = TypeUtils.getReferredType((Type)headersImpliedType);
        }
        if (headersImpliedType.getTag() == 27) {
            headerMap = ExternResponseProcessor.createHeaderMap(httpHeaders, TypeUtils.getImpliedType((Type)((MapType)headersImpliedType).getConstrainedType()));
        } else if (headersImpliedType.getTag() == 24) {
            headerMap = ExternResponseProcessor.createHeaderRecord(httpHeaders, (RecordType)headersImpliedType);
        } else {
            throw new StatusCodeBindingException(HEADER, String.format(UNSUPPORTED_HEADERS_TYPE, headersImpliedType.getName()));
        }
        if (headerMap instanceof BError) {
            BError error = (BError)((Object)headerMap);
            throw new StatusCodeBindingException(HEADER, HEADER_BINDING_FAILED, error);
        }
        try {
            Object convertedHeaderMap = ValueUtils.convert((Object)headerMap, (Type)headersType);
            return ExternResponseProcessor.validateConstraints(requireValidation, convertedHeaderMap, headersType, HttpErrorType.HEADER_VALIDATION_CLIENT_ERROR, HEADER_BINDING_FAILED, HEADER);
        }
        catch (BError conversionError) {
            throw new StatusCodeBindingException(HEADER, HEADER_BINDING_FAILED, conversionError);
        }
    }

    private static Optional<Type> getSpecificStatusCodeResponseType(Type targetType, String statusCode) {
        if (ExternResponseProcessor.isStatusCodeResponseType(targetType)) {
            String statusCodeFromType = ExternResponseProcessor.getStatusCode(targetType);
            if (statusCodeFromType.equals(statusCode)) {
                return Optional.of(targetType);
            }
        } else {
            if (targetType instanceof UnionType) {
                UnionType unionType = (UnionType)targetType;
                return unionType.getMemberTypes().stream().map(member -> ExternResponseProcessor.getSpecificStatusCodeResponseType(member, statusCode)).filter(Optional::isPresent).flatMap(Optional::stream).findFirst();
            }
            if (targetType instanceof ReferenceType && !targetType.equals((Object)TypeUtils.getImpliedType((Type)targetType))) {
                return ExternResponseProcessor.getSpecificStatusCodeResponseType(TypeUtils.getImpliedType((Type)targetType), statusCode);
            }
        }
        return Optional.empty();
    }

    private static Optional<Type> getDefaultStatusCodeResponseType(Type targetType) {
        return ExternResponseProcessor.getSpecificStatusCodeResponseType(targetType, DEFAULT);
    }

    private static boolean isStatusCodeResponseType(Type targetType) {
        RecordType recordType;
        ReferenceType referenceType;
        Type type;
        return targetType instanceof ReferenceType && (type = TypeUtils.getImpliedType((Type)(referenceType = (ReferenceType)targetType))) instanceof RecordType && (recordType = (RecordType)type).getFields().containsKey("status") && ((Field)recordType.getFields().get("status")).getFieldType() instanceof ObjectType;
    }

    private static String getStatusCode(Type targetType) {
        ObjectType statusCodeType = (ObjectType)((Field)((RecordType)TypeUtils.getImpliedType((Type)targetType)).getFields().get("status")).getFieldType();
        if (statusCodeType.getName().equals(DEFAULT_STATUS)) {
            return DEFAULT;
        }
        return ((Field)statusCodeType.getFields().get("code")).getFieldType().getEmptyValue().toString();
    }

    private static boolean isDefaultStatusCodeResponseType(RecordType statusCodeRecordType) {
        return ExternResponseProcessor.getStatusCode((Type)statusCodeRecordType).equals(DEFAULT);
    }

    private static Object createHeaderMap(HttpHeaders headers, Type elementType) throws StatusCodeBindingException {
        BMap headerMap = ValueCreator.createMapValue();
        Set headerNames = headers.names();
        for (String headerName : headerNames) {
            List<String> headerValues = ExternResponseProcessor.getHeader(headers, headerName);
            try {
                Object convertedValue = ExternResponseProcessor.convertHeaderValues(headerValues, elementType);
                headerMap.put((Object)StringUtils.fromString((String)headerName), convertedValue);
            }
            catch (BError ex) {
                throw new StatusCodeBindingException(HEADER, HEADER_BINDING_FAILED, ex);
            }
        }
        return headerMap;
    }

    private static Object createHeaderRecord(HttpHeaders httpHeaders, RecordType headersType) {
        Map headers = headersType.getFields();
        BMap headerMap = ValueCreator.createMapValue();
        for (Map.Entry header : headers.entrySet()) {
            Field headerField = (Field)header.getValue();
            Type headerFieldType = TypeUtils.getImpliedType((Type)headerField.getFieldType());
            BString headerFieldName = StringUtils.fromString((String)((String)header.getKey()));
            String headerName = ExternUtils.getName(headerFieldName, (Type)headersType, "Header").getValue();
            List<String> headerValues = ExternResponseProcessor.getHeader(httpHeaders, headerName);
            if (headerValues.isEmpty()) {
                if (ExternResponseProcessor.isOptionalHeaderField(headerField)) continue;
                BError cause = HttpUtil.createHttpError(String.format(NO_HEADER_VALUE_ERROR_MSG, headerName), HttpErrorType.HEADER_NOT_FOUND_CLIENT_ERROR);
                throw new StatusCodeBindingException(HEADER, HEADER_BINDING_FAILED, cause);
            }
            try {
                Object convertedValue = ExternResponseProcessor.convertHeaderValues(headerValues, headerFieldType);
                headerMap.put((Object)headerFieldName, convertedValue);
            }
            catch (BError ex) {
                throw new StatusCodeBindingException(HEADER, String.format(HEADER_BINDING_FAILED_ERROR_MSG, headerName), ex);
            }
        }
        return headerMap;
    }

    private static BArray parseHeaderValue(List<String> header) {
        Object[] parsedValues;
        try {
            parsedValues = header.stream().map(JsonUtils::parse).toList().toArray();
        }
        catch (Exception e) {
            parsedValues = header.stream().map(StringUtils::fromString).toList().toArray();
        }
        return ValueCreator.createArrayValue((Object[])parsedValues, (ArrayType)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_JSON));
    }

    private static HeaderTypeInfo getHeaderTypeInfo(Type headerType, HeaderTypeInfo headerTypeInfo, boolean fromArray) {
        switch (headerType.getTag()) {
            case 5: {
                if (fromArray) {
                    headerTypeInfo.hasStringArray = true;
                } else {
                    headerTypeInfo.hasString = true;
                }
                return headerTypeInfo;
            }
            case 32: {
                headerTypeInfo.hasArray = true;
                Type elementType = ((ArrayType)headerType).getElementType();
                return ExternResponseProcessor.getHeaderTypeInfo(elementType, headerTypeInfo, true);
            }
            case 33: {
                List memberTypes = ((UnionType)headerType).getMemberTypes();
                for (Type memberType : memberTypes) {
                    headerTypeInfo = ExternResponseProcessor.getHeaderTypeInfo(memberType, headerTypeInfo, false);
                }
                return headerTypeInfo;
            }
            case 53: {
                return ExternResponseProcessor.getHeaderTypeInfo(TypeUtils.getImpliedType((Type)headerType), headerTypeInfo, false);
            }
        }
        return headerTypeInfo;
    }

    private static Object convertHeaderValues(List<String> headerValues, Type headerType) {
        HeaderTypeInfo headerTypeInfo = ExternResponseProcessor.getHeaderTypeInfo(headerType, new HeaderTypeInfo(), false);
        if (headerTypeInfo.hasString) {
            return StringUtils.fromString((String)headerValues.get(0));
        }
        if (headerTypeInfo.hasStringArray) {
            return StringUtils.fromStringArray((String[])headerValues.toArray(new String[0]));
        }
        BArray parsedValues = ExternResponseProcessor.parseHeaderValue(headerValues);
        if (headerTypeInfo.hasArray) {
            try {
                return ValueUtils.convert((Object)parsedValues, (Type)headerType);
            }
            catch (BError e) {
                return ValueUtils.convert((Object)parsedValues.get(0L), (Type)headerType);
            }
        }
        return ValueUtils.convert((Object)parsedValues.get(0L), (Type)headerType);
    }

    private static boolean isOptionalHeaderField(Field headerField) {
        return SymbolFlags.isFlagOn((long)headerField.getFlags(), (long)4096L);
    }

    private static List<String> getHeader(HttpHeaders httpHeaders, String headerName) {
        return httpHeaders.getAllAsString((CharSequence)headerName);
    }

    private static Object validateConstraints(boolean requireValidation, Object convertedValue, Type type, HttpErrorType errorType, String errorMsg, String paramType) throws StatusCodeBindingException {
        Object result;
        if (requireValidation && (result = Constraints.validate((Object)convertedValue, (BTypedesc)ValueCreator.createTypedescValue((Type)type))) instanceof BError) {
            BError bError = (BError)((Object)result);
            String message = errorMsg + ": " + HttpUtil.getPrintableErrorMsg(bError);
            BError cause = HttpUtil.createHttpError(message, errorType, bError);
            throw new StatusCodeBindingException(paramType, message, cause);
        }
        return convertedValue;
    }

    private static Object getStatusCodeResponseBindingError(Environment env, BObject response, String reasonPhrase) {
        try {
            return env.getRuntime().callMethod(response, GET_STATUS_CODE_RESPONSE_BINDING_ERROR, null, new Object[]{StringUtils.fromString((String)reasonPhrase)});
        }
        catch (BError error) {
            return HttpUtil.createHttpError(APPLICATION_RES_ERROR_CREATION_FAILED, HttpErrorType.STATUS_CODE_RESPONSE_BINDING_ERROR, error);
        }
        catch (Throwable throwable) {
            return HttpUtil.createHttpError(APPLICATION_RES_ERROR_CREATION_FAILED, HttpErrorType.STATUS_CODE_RESPONSE_BINDING_ERROR, ErrorCreator.createError((Throwable)throwable));
        }
    }

    private static Object getStatusCodeResponseDataBindingError(Environment env, BObject response, String reasonPhrase, BError cause, boolean isDefaultStatusCodeResponse, String errorType) {
        try {
            return env.getRuntime().callMethod(response, GET_STATUS_CODE_RESPONSE_DATA_BINDING_ERROR, null, new Object[]{StringUtils.fromString((String)reasonPhrase), isDefaultStatusCodeResponse, StringUtils.fromString((String)errorType), cause});
        }
        catch (BError error) {
            return HttpUtil.createHttpError(APPLICATION_RES_ERROR_CREATION_FAILED, HttpErrorType.STATUS_CODE_RESPONSE_BINDING_ERROR, error);
        }
        catch (Throwable throwable) {
            return HttpUtil.createHttpError(APPLICATION_RES_ERROR_CREATION_FAILED, HttpErrorType.STATUS_CODE_RESPONSE_BINDING_ERROR, ErrorCreator.createError((Throwable)throwable));
        }
    }

    static {
        STATUS_CODE_OBJS.put("100", "StatusContinue");
        STATUS_CODE_OBJS.put("101", "StatusSwitchingProtocols");
        STATUS_CODE_OBJS.put("102", "StatusProcessing");
        STATUS_CODE_OBJS.put("103", "StatusEarlyHints");
        STATUS_CODE_OBJS.put("200", "StatusOK");
        STATUS_CODE_OBJS.put("201", "StatusCreated");
        STATUS_CODE_OBJS.put("202", "StatusAccepted");
        STATUS_CODE_OBJS.put("203", "StatusNonAuthoritativeInformation");
        STATUS_CODE_OBJS.put("204", "StatusNoContent");
        STATUS_CODE_OBJS.put("205", "StatusResetContent");
        STATUS_CODE_OBJS.put("206", "StatusPartialContent");
        STATUS_CODE_OBJS.put("207", "StatusMultiStatus");
        STATUS_CODE_OBJS.put("208", "StatusAlreadyReported");
        STATUS_CODE_OBJS.put("226", "StatusIMUsed");
        STATUS_CODE_OBJS.put("300", "StatusMultipleChoices");
        STATUS_CODE_OBJS.put("301", "StatusMovedPermanently");
        STATUS_CODE_OBJS.put("302", "StatusFound");
        STATUS_CODE_OBJS.put("303", "StatusSeeOther");
        STATUS_CODE_OBJS.put("304", "StatusNotModified");
        STATUS_CODE_OBJS.put("305", "StatusUseProxy");
        STATUS_CODE_OBJS.put("307", "StatusTemporaryRedirect");
        STATUS_CODE_OBJS.put("308", "StatusPermanentRedirect");
        STATUS_CODE_OBJS.put("400", "StatusBadRequest");
        STATUS_CODE_OBJS.put("401", "StatusUnauthorized");
        STATUS_CODE_OBJS.put("402", "StatusPaymentRequired");
        STATUS_CODE_OBJS.put("403", "StatusForbidden");
        STATUS_CODE_OBJS.put("404", "StatusNotFound");
        STATUS_CODE_OBJS.put("405", "StatusMethodNotAllowed");
        STATUS_CODE_OBJS.put("406", "StatusNotAcceptable");
        STATUS_CODE_OBJS.put("407", "StatusProxyAuthenticationRequired");
        STATUS_CODE_OBJS.put("408", "StatusRequestTimeout");
        STATUS_CODE_OBJS.put("409", "StatusConflict");
        STATUS_CODE_OBJS.put("410", "StatusGone");
        STATUS_CODE_OBJS.put("411", "StatusLengthRequired");
        STATUS_CODE_OBJS.put("412", "StatusPreconditionFailed");
        STATUS_CODE_OBJS.put("413", "StatusPayloadTooLarge");
        STATUS_CODE_OBJS.put("414", "StatusUriTooLong");
        STATUS_CODE_OBJS.put("415", "StatusUnsupportedMediaType");
        STATUS_CODE_OBJS.put("416", "StatusRangeNotSatisfiable");
        STATUS_CODE_OBJS.put("417", "StatusExpectationFailed");
        STATUS_CODE_OBJS.put("421", "StatusMisdirectedRequest");
        STATUS_CODE_OBJS.put("422", "StatusUnprocessableEntity");
        STATUS_CODE_OBJS.put("423", "StatusLocked");
        STATUS_CODE_OBJS.put("424", "StatusFailedDependency");
        STATUS_CODE_OBJS.put("425", "StatusTooEarly");
        STATUS_CODE_OBJS.put("426", "StatusUpgradeRequired");
        STATUS_CODE_OBJS.put("428", "StatusPreconditionRequired");
        STATUS_CODE_OBJS.put("429", "StatusTooManyRequests");
        STATUS_CODE_OBJS.put("431", "StatusRequestHeaderFieldsTooLarge");
        STATUS_CODE_OBJS.put("451", "StatusUnavailableDueToLegalReasons");
        STATUS_CODE_OBJS.put("500", "StatusInternalServerError");
        STATUS_CODE_OBJS.put("501", "StatusNotImplemented");
        STATUS_CODE_OBJS.put("502", "StatusBadGateway");
        STATUS_CODE_OBJS.put("503", "StatusServiceUnavailable");
        STATUS_CODE_OBJS.put("504", "StatusGatewayTimeout");
        STATUS_CODE_OBJS.put("505", "StatusHttpVersionNotSupported");
        STATUS_CODE_OBJS.put("506", "StatusVariantAlsoNegotiates");
        STATUS_CODE_OBJS.put("507", "StatusInsufficientStorage");
        STATUS_CODE_OBJS.put("508", "StatusLoopDetected");
        STATUS_CODE_OBJS.put("510", "StatusNotExtended");
        STATUS_CODE_OBJS.put("511", "StatusNetworkAuthenticationRequired");
    }

    static class HeaderTypeInfo {
        private boolean hasString = false;
        private boolean hasStringArray = false;
        private boolean hasArray = false;

        HeaderTypeInfo() {
        }
    }
}

