/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExternUtils {
    public static final String FIELD = "$field$.%s";

    private ExternUtils() {
    }

    public static BString getReasonFromStatusCode(Long statusCode) {
        String reasonPhrase;
        if (statusCode.intValue() == 451) {
            reasonPhrase = "Unavailable For Legal Reasons";
        } else if (statusCode.intValue() == 508) {
            reasonPhrase = "Loop Detected";
        } else {
            reasonPhrase = HttpResponseStatus.valueOf((int)statusCode.intValue()).reasonPhrase();
            if (reasonPhrase.contains("Unknown Status")) {
                reasonPhrase = HttpResponseStatus.valueOf((int)500).reasonPhrase();
            }
        }
        return StringUtils.fromString((String)reasonPhrase);
    }

    public static BString getHeaderName(BString originalName, BTypedesc headerTypeDesc) {
        return ExternUtils.getName(originalName, headerTypeDesc.getDescribingType(), "Header");
    }

    public static BString getQueryName(BString originalName, BTypedesc queryTypeDesc) {
        return ExternUtils.getName(originalName, queryTypeDesc.getDescribingType(), "Query");
    }

    public static BString getName(BString originalName, Type headerType, String annotationName) {
        if ((headerType = TypeUtils.getReferredType((Type)headerType)).getTag() != 24) {
            return originalName;
        }
        BMap annotations = ((RecordType)headerType).getAnnotations();
        if (Objects.isNull(annotations) || annotations.isEmpty()) {
            return originalName;
        }
        Object fieldAnnotations = annotations.get((Object)StringUtils.fromString((String)String.format(FIELD, originalName)));
        if (!(fieldAnnotations instanceof BMap)) {
            return originalName;
        }
        BMap fieldAnnotMap = (BMap)fieldAnnotations;
        return ExternUtils.extractHttpAnnotation(fieldAnnotMap, annotationName).flatMap(ExternUtils::extractFieldName).orElse(originalName);
    }

    private static Optional<BMap> extractHttpAnnotation(BMap fieldAnnotMap, String annotationName) {
        for (Object annotRef : fieldAnnotMap.getKeys()) {
            String refRegex = ModuleUtils.getHttpPackageIdentifier() + ":" + annotationName;
            Pattern pattern = Pattern.compile(refRegex);
            Matcher matcher = pattern.matcher(annotRef.toString());
            if (!matcher.find()) continue;
            return Optional.of((BMap)fieldAnnotMap.get(annotRef));
        }
        return Optional.empty();
    }

    private static Optional<BString> extractFieldName(BMap value) {
        Object overrideValue = value.get((Object)HttpConstants.ANN_FIELD_NAME);
        if (!(overrideValue instanceof BString)) {
            return Optional.empty();
        }
        BString overrideName = (BString)overrideValue;
        return Optional.of(overrideName);
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (BError error) {
            throw error;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }
}

