/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl.pipelining;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.Objects;

public class PipelinedResponse
implements Comparable<PipelinedResponse> {
    private final HttpCarbonMessage inboundRequestMsg;
    private final HttpCarbonMessage outboundResponseMsg;
    private DataContext dataContext;
    private BObject outboundResponseObj;
    private final long sequenceId;

    public PipelinedResponse(HttpCarbonMessage inboundRequestMsg, HttpCarbonMessage outboundResponseMsg, DataContext dataContext, BObject outboundResponseObj) {
        this.inboundRequestMsg = inboundRequestMsg;
        this.outboundResponseMsg = outboundResponseMsg;
        this.dataContext = dataContext;
        this.outboundResponseObj = outboundResponseObj;
        this.sequenceId = inboundRequestMsg.getSequenceId();
    }

    PipelinedResponse(HttpCarbonMessage inboundRequestMsg, HttpCarbonMessage outboundResponseMsg) {
        this.inboundRequestMsg = inboundRequestMsg;
        this.outboundResponseMsg = outboundResponseMsg;
        this.sequenceId = inboundRequestMsg.getSequenceId();
    }

    long getSequenceId() {
        return this.sequenceId;
    }

    HttpCarbonMessage getOutboundResponseMsg() {
        return this.outboundResponseMsg;
    }

    HttpCarbonMessage getInboundRequestMsg() {
        return this.inboundRequestMsg;
    }

    DataContext getDataContext() {
        return this.dataContext;
    }

    BObject getOutboundResponseObj() {
        return this.outboundResponseObj;
    }

    @Override
    public int compareTo(PipelinedResponse other) {
        return Long.compare(this.sequenceId, other.getSequenceId());
    }

    public boolean equals(Object obj) {
        if (obj instanceof PipelinedResponse) {
            return this.compareTo((PipelinedResponse)obj) == 0;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.sequenceId);
    }
}

