/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.builder;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.builder.AbstractPayloadBuilder;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import java.io.IOException;
import java.util.List;

public class BinaryPayloadBuilder
extends AbstractPayloadBuilder {
    private final Type payloadType;

    public BinaryPayloadBuilder(Type payloadType) {
        this.payloadType = payloadType;
    }

    @Override
    public Object getValue(BObject entity, boolean readonly) {
        if (this.payloadType.getTag() == 32) {
            Type elementType = ((ArrayType)this.payloadType).getElementType();
            if (elementType.getTag() == 2) {
                return this.createValue(entity, readonly);
            }
        } else if (this.payloadType.getTag() == 33) {
            List memberTypes = ((UnionType)this.payloadType).getMemberTypes();
            for (Type memberType : memberTypes) {
                Type elementType;
                if (memberType.getTag() != 32 || (elementType = ((ArrayType)memberType).getElementType()).getTag() != 2) continue;
                return this.createValue(entity, readonly);
            }
        }
        String message = "incompatible type found: '" + this.payloadType.toString() + "'";
        throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PAYLOAD_BINDING_LISTENER_ERROR, message);
    }

    private Object createValue(BObject entity, boolean readonly) {
        BArray blobDataSource;
        try {
            blobDataSource = EntityBodyHandler.constructBlobDataSource((BObject)entity);
        }
        catch (IOException e) {
            throw HttpUtil.createHttpError(e.getMessage(), HttpErrorType.CLIENT_ERROR);
        }
        EntityBodyHandler.addMessageDataSource((BObject)entity, (Object)blobDataSource);
        if (readonly) {
            blobDataSource.freezeDirect();
        }
        return blobDataSource;
    }
}

