/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contract.config;

import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.config.ForwardedExtensionConfig;
import io.ballerina.stdlib.http.transport.contract.config.InboundMsgSizeValidationConfig;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contract.config.ProxyServerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SslConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.PoolConfiguration;

public class SenderConfiguration
extends SslConfiguration {
    private static final String DEFAULT_KEY = "netty";
    private String id = "netty";
    private int socketIdleTimeout = 60000;
    private boolean httpTraceLogEnabled;
    private boolean httpAccessLogEnabled;
    private ChunkConfig chunkingConfig = ChunkConfig.AUTO;
    private KeepAliveConfig keepAliveConfig = KeepAliveConfig.AUTO;
    private boolean forceHttp2 = false;
    private String httpVersion = "1.1";
    private ProxyServerConfiguration proxyServerConfiguration;
    private PoolConfiguration poolConfiguration;
    private InboundMsgSizeValidationConfig responseSizeValidationConfig = new InboundMsgSizeValidationConfig();
    private ForwardedExtensionConfig forwardedExtensionConfig = ForwardedExtensionConfig.DISABLE;
    private int connectTimeOut = 15000;
    private int receiveBufferSize = 0x100000;
    private int sendBufferSize = 0x100000;
    private boolean tcpNoDelay = true;
    private boolean socketReuse = false;
    private boolean socketKeepAlive = true;
    private int http2InitialWindowSize = 65535;

    @Deprecated
    public static SenderConfiguration getDefault() {
        SenderConfiguration defaultConfig = new SenderConfiguration(DEFAULT_KEY);
        return defaultConfig;
    }

    public SenderConfiguration() {
        this.poolConfiguration = new PoolConfiguration();
    }

    public SenderConfiguration(String id) {
        this.id = id;
        this.poolConfiguration = new PoolConfiguration();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getSocketIdleTimeout(int defaultValue) {
        if (this.socketIdleTimeout == 0) {
            return defaultValue;
        }
        return this.socketIdleTimeout;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }

    public boolean isHttpTraceLogEnabled() {
        return this.httpTraceLogEnabled;
    }

    public void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    public boolean isHttpAccessLogEnabled() {
        return this.httpAccessLogEnabled;
    }

    public void setHttpAccessLogEnabled(boolean httpAccessLogEnabled) {
        this.httpAccessLogEnabled = httpAccessLogEnabled;
    }

    public ChunkConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public void setChunkingConfig(ChunkConfig chunkingConfig) {
        this.chunkingConfig = chunkingConfig;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    public void setProxyServerConfiguration(ProxyServerConfiguration proxyServerConfiguration) {
        this.proxyServerConfiguration = proxyServerConfiguration;
    }

    public ProxyServerConfiguration getProxyServerConfiguration() {
        return this.proxyServerConfiguration;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        if (!httpVersion.isEmpty()) {
            this.httpVersion = httpVersion;
        }
    }

    public boolean isForceHttp2() {
        return this.forceHttp2;
    }

    public void setForceHttp2(boolean forceHttp2) {
        this.forceHttp2 = forceHttp2;
    }

    public PoolConfiguration getPoolConfiguration() {
        return this.poolConfiguration;
    }

    public void setPoolConfiguration(PoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
    }

    public ForwardedExtensionConfig getForwardedExtensionConfig() {
        return this.forwardedExtensionConfig;
    }

    public void setForwardedExtensionConfig(ForwardedExtensionConfig forwardedExtensionEnabled) {
        this.forwardedExtensionConfig = forwardedExtensionEnabled;
    }

    public InboundMsgSizeValidationConfig getMsgSizeValidationConfig() {
        return this.responseSizeValidationConfig;
    }

    public void setMsgSizeValidationConfig(InboundMsgSizeValidationConfig responseSizeValidationConfig) {
        this.responseSizeValidationConfig = responseSizeValidationConfig;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(double connectTimeOut) {
        this.connectTimeOut = (int)(connectTimeOut * 1000.0);
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public void setSocketReuse(boolean socketReuse) {
        this.socketReuse = socketReuse;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public int getHttp2InitialWindowSize() {
        return this.http2InitialWindowSize;
    }

    public void setHttp2InitialWindowSize(int http2InitialWindowSize) {
        this.http2InitialWindowSize = http2InitialWindowSize;
    }
}

