/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl;

import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpWsConnectorFactory;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.ServerBootstrapConfiguration;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnector;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketClientConnectorConfig;
import io.ballerina.stdlib.http.transport.contractimpl.DefaultHttpClientConnector;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLHandlerFactory;
import io.ballerina.stdlib.http.transport.contractimpl.listener.ServerConnectorBootstrap;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.BootstrapConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.DefaultWebSocketClientConnector;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLException;

public class DefaultHttpWsConnectorFactory
implements HttpWsConnectorFactory {
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final EventLoopGroup clientGroup;
    private EventExecutorGroup pipeliningGroup;
    private final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public DefaultHttpWsConnectorFactory() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.bossGroup = new NioEventLoopGroup(availableProcessors);
        this.workerGroup = new NioEventLoopGroup(availableProcessors * 2);
        this.clientGroup = new NioEventLoopGroup(availableProcessors * 2);
    }

    public DefaultHttpWsConnectorFactory(int serverSocketThreads, int childSocketThreads, int clientThreads) {
        this.bossGroup = new NioEventLoopGroup(serverSocketThreads);
        this.workerGroup = new NioEventLoopGroup(childSocketThreads);
        this.clientGroup = new NioEventLoopGroup(clientThreads);
    }

    @Override
    public ServerConnector createServerConnector(ServerBootstrapConfiguration serverBootstrapConfiguration, ListenerConfiguration listenerConfig) {
        ServerConnectorBootstrap serverConnectorBootstrap = new ServerConnectorBootstrap(this.allChannels);
        serverConnectorBootstrap.addSocketConfiguration(serverBootstrapConfiguration);
        SSLConfig sslConfig = listenerConfig.getListenerSSLConfig();
        serverConnectorBootstrap.addSecurity(sslConfig);
        if (sslConfig != null) {
            this.setSslContext(serverConnectorBootstrap, sslConfig, listenerConfig);
        }
        serverConnectorBootstrap.addIdleTimeout(listenerConfig.getSocketIdleTimeout());
        if ("2.0".equals(listenerConfig.getVersion())) {
            serverConnectorBootstrap.setHttp2Enabled(true);
            serverConnectorBootstrap.setHttp2InitialWindowSize(listenerConfig.getHttp2InitialWindowSize());
            serverConnectorBootstrap.setMinIdleTimeInStaleState(listenerConfig.getMinIdleTimeInStaleState());
            serverConnectorBootstrap.setTimeBetweenStaleEviction(listenerConfig.getTimeBetweenStaleEviction());
        }
        serverConnectorBootstrap.addHttpTraceLogHandler(listenerConfig.isHttpTraceLogEnabled());
        serverConnectorBootstrap.addHttpAccessLogHandler(listenerConfig.isHttpAccessLogEnabled());
        serverConnectorBootstrap.addThreadPools(this.bossGroup, this.workerGroup);
        serverConnectorBootstrap.addHeaderAndEntitySizeValidation(listenerConfig.getMsgSizeValidationConfig());
        serverConnectorBootstrap.addChunkingBehaviour(listenerConfig.getChunkConfig());
        serverConnectorBootstrap.addKeepAliveBehaviour(listenerConfig.getKeepAliveConfig());
        serverConnectorBootstrap.addServerHeader(listenerConfig.getServerHeader());
        serverConnectorBootstrap.setGracefulStopTimeout(listenerConfig.getGracefulStopTimeout());
        serverConnectorBootstrap.setPipeliningEnabled(listenerConfig.isPipeliningEnabled());
        serverConnectorBootstrap.setWebSocketCompressionEnabled(listenerConfig.isWebSocketCompressionEnabled());
        serverConnectorBootstrap.setPipeliningLimit(listenerConfig.getPipeliningLimit());
        if (listenerConfig.isPipeliningEnabled()) {
            this.pipeliningGroup = new DefaultEventExecutorGroup(2, (ThreadFactory)new DefaultThreadFactory("pipelining-thread-pool"));
            serverConnectorBootstrap.setPipeliningThreadGroup(this.pipeliningGroup);
        }
        return serverConnectorBootstrap.getServerConnector(listenerConfig.getHost(), listenerConfig.getPort());
    }

    private void setSslContext(ServerConnectorBootstrap serverConnectorBootstrap, SSLConfig sslConfig, ListenerConfiguration listenerConfig) {
        try {
            SSLHandlerFactory sslHandlerFactory = new SSLHandlerFactory(sslConfig);
            serverConnectorBootstrap.addcertificateRevocationVerifier(sslConfig.isValidateCertEnabled());
            serverConnectorBootstrap.addCacheDelay(sslConfig.getCacheValidityPeriod());
            serverConnectorBootstrap.addCacheSize(sslConfig.getCacheSize());
            serverConnectorBootstrap.addOcspStapling(sslConfig.isOcspStaplingEnabled());
            serverConnectorBootstrap.addSslHandlerFactory(sslHandlerFactory);
            if (sslConfig.getKeyStore() != null) {
                if ("2.0".equals(listenerConfig.getVersion())) {
                    serverConnectorBootstrap.addHttp2SslContext(sslHandlerFactory.createHttp2TLSContextForServer(sslConfig));
                } else {
                    serverConnectorBootstrap.addKeystoreSslContext(sslHandlerFactory.createSSLContextFromKeystores(true));
                }
            } else if ("2.0".equals(listenerConfig.getVersion())) {
                serverConnectorBootstrap.addHttp2SslContext(sslHandlerFactory.createHttp2TLSContextForServer(sslConfig));
            } else {
                serverConnectorBootstrap.addCertAndKeySslContext(sslHandlerFactory.createHttpTLSContextForServer());
            }
        }
        catch (SSLException e) {
            throw new RuntimeException("Failed to create ssl context from given certs and key", e);
        }
    }

    @Override
    public HttpClientConnector createHttpClientConnector(Map<String, Object> transportProperties, SenderConfiguration senderConfiguration) {
        BootstrapConfiguration bootstrapConfig = new BootstrapConfiguration(senderConfiguration);
        ConnectionManager connectionManager = new ConnectionManager(senderConfiguration.getPoolConfiguration());
        int configHashCode = Util.getIntProperty(transportProperties, "ClientConfigHashCode", 0);
        return new DefaultHttpClientConnector(connectionManager, senderConfiguration, bootstrapConfig, this.clientGroup, configHashCode);
    }

    @Override
    public HttpClientConnector createHttpsClientConnector(Map<String, Object> transportProperties, SenderConfiguration senderConfiguration) throws Exception {
        BootstrapConfiguration bootstrapConfig = new BootstrapConfiguration(senderConfiguration);
        ConnectionManager connectionManager = new ConnectionManager(senderConfiguration.getPoolConfiguration());
        int configHashCode = Util.getIntProperty(transportProperties, "ClientConfigHashCode", 0);
        DefaultHttpClientConnector httpClientConnector = new DefaultHttpClientConnector(connectionManager, senderConfiguration, bootstrapConfig, this.clientGroup, configHashCode);
        httpClientConnector.initializeSSLContext();
        return httpClientConnector;
    }

    @Override
    public HttpClientConnector createHttpClientConnector(Map<String, Object> transportProperties, SenderConfiguration senderConfiguration, ConnectionManager connectionManager) {
        BootstrapConfiguration bootstrapConfig = new BootstrapConfiguration(senderConfiguration);
        int configHashCode = Util.getIntProperty(transportProperties, "ClientConfigHashCode", 0);
        return new DefaultHttpClientConnector(connectionManager, senderConfiguration, bootstrapConfig, this.clientGroup, configHashCode);
    }

    @Override
    public HttpClientConnector createHttpsClientConnector(Map<String, Object> transportProperties, SenderConfiguration senderConfiguration, ConnectionManager connectionManager) throws Exception {
        BootstrapConfiguration bootstrapConfig = new BootstrapConfiguration(senderConfiguration);
        int configHashCode = Util.getIntProperty(transportProperties, "ClientConfigHashCode", 0);
        DefaultHttpClientConnector httpClientConnector = new DefaultHttpClientConnector(connectionManager, senderConfiguration, bootstrapConfig, this.clientGroup, configHashCode);
        httpClientConnector.initializeSSLContext();
        return httpClientConnector;
    }

    @Override
    public WebSocketClientConnector createWsClientConnector(WebSocketClientConnectorConfig clientConnectorConfig) {
        return new DefaultWebSocketClientConnector(clientConnectorConfig, this.clientGroup);
    }

    @Override
    public WebSocketClientConnector createWsClientConnectorWithSSL(WebSocketClientConnectorConfig clientConnectorConfig) throws Exception {
        DefaultWebSocketClientConnector webSocketClientConnector = new DefaultWebSocketClientConnector(clientConnectorConfig, this.clientGroup);
        webSocketClientConnector.initializeSSLContext();
        return webSocketClientConnector;
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.allChannels.close().sync();
        this.workerGroup.shutdownGracefully().sync();
        this.bossGroup.shutdownGracefully().sync();
        this.clientGroup.shutdownGracefully().sync();
        if (this.pipeliningGroup != null) {
            this.pipeliningGroup.shutdownGracefully().sync();
        }
    }

    public void shutdownNow() {
        this.allChannels.close();
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
        this.clientGroup.shutdownGracefully();
        if (this.pipeliningGroup != null) {
            this.pipeliningGroup.shutdownGracefully();
        }
    }
}

