/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl;

import io.ballerina.stdlib.http.transport.contract.HttpConnectorListener;
import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.BackPressureHandler;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.listener.RequestDataHolder;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.internal.HandlerExecutor;
import io.ballerina.stdlib.http.transport.internal.HttpTransportContextHolder;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.channel.ChannelHandlerContext;
import java.util.Calendar;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOutboundRespListener
implements HttpConnectorListener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpOutboundRespListener.class);
    private final SourceHandler sourceHandler;
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private ChannelHandlerContext sourceContext;
    private RequestDataHolder requestDataHolder;
    private HandlerExecutor handlerExecutor;
    private HttpCarbonMessage inboundRequestMsg;
    private ChunkConfig chunkConfig;
    private KeepAliveConfig keepAliveConfig;
    private String serverName;
    private Calendar inboundRequestArrivalTime;
    private String remoteAddress = "-";

    public HttpOutboundRespListener(HttpCarbonMessage requestMsg, SourceHandler sourceHandler) {
        this.requestDataHolder = new RequestDataHolder(requestMsg);
        this.inboundRequestMsg = requestMsg;
        this.sourceHandler = sourceHandler;
        this.sourceContext = sourceHandler.getInboundChannelContext();
        this.chunkConfig = sourceHandler.getChunkConfig();
        this.keepAliveConfig = sourceHandler.getKeepAliveConfig();
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        this.serverName = sourceHandler.getServerName();
        this.listenerReqRespStateManager = requestMsg.listenerReqRespStateManager;
        this.remoteAddress = sourceHandler.getRemoteHost();
        this.inboundRequestArrivalTime = Calendar.getInstance();
        this.setBackPressureObservableToHttpResponseFuture();
    }

    private void setBackPressureObservableToHttpResponseFuture() {
        this.inboundRequestMsg.getHttpOutboundRespStatusFuture().setBackPressureObservable(Util.getBackPressureHandler(this.sourceContext).getBackPressureObservable());
    }

    @Override
    public void onMessage(HttpCarbonMessage outboundResponseMsg) {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceResponseReceiving(outboundResponseMsg);
        }
        BackPressureHandler backpressureHandler = Util.getBackPressureHandler(this.sourceContext);
        Util.setBackPressureListener(outboundResponseMsg, backpressureHandler, outboundResponseMsg.getTargetContext());
        outboundResponseMsg.getHttpContentAsync().setMessageListener(httpContent -> {
            Util.checkUnWritabilityAndNotify(this.sourceContext, backpressureHandler);
            this.sourceContext.channel().eventLoop().execute(() -> {
                try {
                    this.listenerReqRespStateManager.writeOutboundResponseBody(this, outboundResponseMsg, httpContent);
                }
                catch (Exception exception) {
                    String errorMsg = "Failed to send the outbound response : " + exception.getMessage().toLowerCase(Locale.ENGLISH);
                    LOG.error(errorMsg, (Throwable)exception);
                    this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(exception);
                }
            });
        });
    }

    @Override
    public void onPushPromise(Http2PushPromise pushPromise) {
        this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new UnsupportedOperationException("Sending a PUSH_PROMISE is not supported for HTTP/1.x connections"));
    }

    @Override
    public void onPushResponse(int promiseId, HttpCarbonMessage httpMessage) {
        this.inboundRequestMsg.getHttpOutboundRespStatusFuture().notifyHttpListener(new UnsupportedOperationException("Sending Server Push messages is not supported for HTTP/1.x connections"));
    }

    public boolean isKeepAlive() {
        return Util.isKeepAliveConnection(this.keepAliveConfig, this.requestDataHolder.getConnectionHeaderValue(), this.requestDataHolder.getHttpVersion());
    }

    @Override
    public void onError(Throwable throwable) {
        LOG.error("Couldn't send the outbound response", throwable);
    }

    public ChunkConfig getChunkConfig() {
        return this.chunkConfig;
    }

    public HttpCarbonMessage getInboundRequestMsg() {
        return this.inboundRequestMsg;
    }

    public RequestDataHolder getRequestDataHolder() {
        return this.requestDataHolder;
    }

    public ChannelHandlerContext getSourceContext() {
        return this.sourceContext;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setKeepAliveConfig(KeepAliveConfig config) {
        this.keepAliveConfig = config;
    }

    public SourceHandler getSourceHandler() {
        return this.sourceHandler;
    }

    public Calendar getInboundRequestArrivalTime() {
        return this.inboundRequestArrivalTime;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }
}

